/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.StreamsDomainNode;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ProjectAreaWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamAreaWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class NewStreamAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)element;
            element = AbstractPlaceWrapper.newWrapper(context.getLocal().getResolvedWorkspace());
        }
        if (element != null && Adapters.hasAdapter((Object)element, ContributorPlaceWrapper.class)) {
            this.processContributorPlaceWrapper(shell, page, element);
        } else if (element instanceof DomainSubtreeRoot) {
            this.processDomainSubtreeRoot(shell, page, (DomainSubtreeRoot)element);
        } else if (element instanceof StreamsDomainNode) {
            this.processStreamsDomainNode(shell, page, (StreamsDomainNode)element);
        } else if (element instanceof FolderNode) {
            this.openTeamPlaceEditor(shell, page, (FolderNode)element, true);
        } else if (element != null && Adapters.hasAdapter((Object)element, RawSnapshotWrapper.class)) {
            this.processRawSnapshotWrapper(shell, page, element);
        } else {
            TeamPlacePart2.open(page, TeamPlaceEditorInput.newStream().setRepository(ClientRepositoryUtil.getDefaultRepository()));
        }
    }

    private void processRawSnapshotWrapper(Shell shell, final IWorkbenchPage page, Object element) {
        final RawSnapshotWrapper snapshot = (RawSnapshotWrapper)((Object)Adapters.getAdapter((Object)element, RawSnapshotWrapper.class));
        final Display d = shell.getDisplay();
        this.getOperationRunner().enqueue(Messages.NewStreamAction_FetchingTeamAreaJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                final TeamAreaWrapper[] teamAreaWrapper = new TeamAreaWrapper[1];
                IAuditableHandle owner = null;
                if (snapshot instanceof SnapshotWrapper) {
                    SnapshotWrapper snapshotWrapper = (SnapshotWrapper)snapshot;
                    IWorkspace workspace = snapshotWrapper.getWorkspace();
                    if (workspace != null) {
                        owner = workspace.getOwner();
                    }
                } else {
                    IWorkspace workspace;
                    IWorkspaceHandle workspaceHandle = snapshot.getSnapshot().getOwner();
                    if (workspaceHandle != null && (workspace = (IWorkspace)snapshot.getRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor)) != null) {
                        owner = workspace.getOwner();
                    }
                }
                if (owner instanceof ITeamAreaHandle) {
                    ITeamArea teamArea = (ITeamArea)snapshot.getRepository().itemManager().fetchCompleteItem((IItemHandle)owner, 0, monitor);
                    teamAreaWrapper[0] = new TeamAreaWrapper(snapshot.getRepository(), teamArea);
                }
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TeamPlacePart2.open(page, TeamPlaceEditorInput.newStream().setOriginalSnapshot(snapshot.getSnapshot()).setOwner(teamAreaWrapper[0]).setRepository(snapshot.getRepository()));
                    }
                });
            }
        });
    }

    private void processContributorPlaceWrapper(final Shell shell, final IWorkbenchPage page, Object element) {
        final ContributorPlaceWrapper wrapper = (ContributorPlaceWrapper)((Object)Adapters.getAdapter((Object)element, ContributorPlaceWrapper.class));
        final Display d = shell.getDisplay();
        this.getOperationRunner().enqueue(Messages.NewStreamAction_CheckingWorkspaceJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                final IWorkspaceConnection connection = wrapper.getWorkspaceConnection(monitor);
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!NewStreamAction.this.checkOpenActivities(shell, connection)) {
                            return;
                        }
                        TeamPlacePart2.open(page, TeamPlaceEditorInput.newStream().setPlace(wrapper).setRepository(wrapper.getRepository()));
                    }
                });
            }
        });
    }

    private void processDomainSubtreeRoot(Shell shell, IWorkbenchPage page, DomainSubtreeRoot dsr) {
        Object processArea = null;
        ITeamRepository repo = null;
        if (dsr.getCategoryElement() instanceof ITeamAreaHandle) {
            processArea = (ITeamAreaHandle)dsr.getCategoryElement();
            repo = ClientRepositoryUtil.getRepository((IItemHandle)processArea);
        }
        if (dsr.getCategoryElement() instanceof IProjectAreaHandle) {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)dsr.getCategoryElement();
            repo = ClientRepositoryUtil.getRepository((IItemHandle)projectAreaHandle);
            List teamAreas = dsr.getDomain().getConnectedProjectAreaRegistry().getSelectedTeamAreas(projectAreaHandle);
            processArea = teamAreas.size() == 1 ? (ITeamAreaHandle)teamAreas.iterator().next() : projectAreaHandle;
        }
        this.openTeamPlaceEditor(shell, page, (IProcessAreaHandle)processArea, true, repo);
    }

    private void processStreamsDomainNode(Shell shell, IWorkbenchPage page, StreamsDomainNode element) {
        List teamAreas;
        ITeamRepository repo = element.getRepository();
        IProjectAreaHandle processArea = element.getProjectArea();
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        if (registry != null && (teamAreas = registry.getSelectedTeamAreas(element.getProjectArea())).size() == 1) {
            processArea = (ITeamAreaHandle)teamAreas.iterator().next();
        }
        this.openTeamPlaceEditor(shell, page, (IProcessAreaHandle)processArea, false, repo);
    }

    private void openTeamPlaceEditor(Shell shell, IWorkbenchPage page, FolderNode node, boolean shouldAddToRootFolder) {
        this.openTeamPlaceEditor(shell, page, (IProcessAreaHandle)node.getOwner(), node.getItem(), shouldAddToRootFolder, node.getRepo());
    }

    private void openTeamPlaceEditor(Shell shell, IWorkbenchPage page, IProcessAreaHandle processArea, boolean shouldAddToRootFolder, ITeamRepository repo) {
        this.openTeamPlaceEditor(shell, page, processArea, null, shouldAddToRootFolder, repo);
    }

    private void openTeamPlaceEditor(Shell shell, final IWorkbenchPage page, IProcessAreaHandle processArea, IItemContainer parentFolder, boolean shouldAddToRoot, ITeamRepository repo) {
        final TeamPlaceEditorInput input = TeamPlaceEditorInput.newStream();
        if (repo != null) {
            input.setRepository(repo);
            input.setParentFolder(parentFolder);
            input.setAddToRootFolder(shouldAddToRoot);
            if (processArea != null) {
                final Display d = shell.getDisplay();
                final IProcessAreaHandle finalProcessArea = processArea;
                final ITeamRepository finalRepo = repo;
                this.getOperationRunner().enqueue(Messages.NewStreamAction_FetchingTeamJobName, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IProcessArea area = (IProcessArea)finalRepo.itemManager().fetchCompleteItem((IItemHandle)finalProcessArea, 0, (IProgressMonitor)progress.newChild(50));
                        final AbstractWrapper[] areaWrapper = new AbstractWrapper[1];
                        if (area instanceof ITeamArea) {
                            areaWrapper[0] = new TeamAreaWrapper((ITeamArea)area);
                        } else if (area instanceof IProjectArea) {
                            areaWrapper[0] = new ProjectAreaWrapper((IProjectArea)area);
                        }
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                input.setOwner(areaWrapper[0]);
                                TeamPlacePart2.open(page, input);
                            }
                        });
                    }
                });
                return;
            }
        }
        TeamPlacePart2.open(page, input);
    }

    private boolean checkOpenActivities(Shell shell, IWorkspaceConnection connection) {
        block5: {
            block4: {
                try {
                    if (!this.hasActiveChanges(connection)) break block4;
                    MessageDialog.openInformation((Shell)shell, (String)Messages.NewStreamAction_UnableCreateStreamDialogTitle, (String)Messages.NewStreamAction_ActiveChangesetsDialogMessage);
                    return false;
                }
                catch (TeamRepositoryException e) {
                    IStatus status = StatusUtil.newStatus(((Object)((Object)this)).getClass(), (Throwable)e);
                    StatusUtil.log((IStatus)status);
                    ErrorDialog.openError((Shell)shell, (String)Messages.NewStreamAction_ErrorCheckingActivitiesDialogTitle, (String)Messages.NewStreamAction_ErrorCheckingOpenActivitiesDialogMessage, (IStatus)status);
                    return false;
                }
            }
            if (!this.hasPendingChanges(connection) || MessageDialog.openConfirm((Shell)shell, (String)Messages.NewStreamAction_ConfirmCreateStreamDialogTitle, (String)Messages.NewStreamAction_PendingChangesDialogMessage)) break block5;
            return false;
        }
        return !this.hasUndeliveredChanges(connection) || MessageDialog.openConfirm((Shell)shell, (String)Messages.NewStreamAction_ConfirmCreateStream2DialogTitle, (String)Messages.NewStreamAction_UndeliveredChangesetsDialogMessage);
    }

    private boolean hasActiveChanges(IWorkspaceConnection connection) throws TeamRepositoryException {
        List components = connection.getComponents();
        for (IComponentHandle component : components) {
            if (connection.activeChangeSets(component).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPendingChanges(IWorkspaceConnection connection) {
        IComponentSyncContext[] contexts = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager().getComponentSyncModel().getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            if (context.getComponentSyncInfo().getLocal() == connection && context.getLocalChangeSource().getLocalChanges().size() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasUndeliveredChanges(IWorkspaceConnection connection) {
        IComponentSyncContext[] contexts = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager().getComponentSyncModel().getComponentSyncContexts();
        int i = 0;
        while (i < contexts.length) {
            IComponentSyncContext context = contexts[i];
            if (context.getComponentSyncInfo().getLocal() == connection && context.getOutgoingActivitySource().getActivities().size() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

