/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.filesystem.ui.queries.StreamsDomainNode;
import com.ibm.team.filesystem.ui.queries.WorkspacesDomainNode;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisEditor;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisEditorInput;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddConnectionsCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs.SelectRepositoryPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class NewFlowDiagramAction
extends AbstractActionDelegate {
    private static void add(Map<ITeamRepository, AddConnectionsCommand> map, ITeamRepository repo, Object o) {
        AddConnectionsCommand command = map.get(repo);
        if (command == null) {
            command = new AddConnectionsCommand();
            map.put(repo, command);
        }
        if (o instanceof IWorkspaceHandle) {
            IWorkspaceHandle workspace = (IWorkspaceHandle)o;
            command.addWorkspace(workspace);
        } else if (o instanceof Collection) {
            for (Object item : (Collection)o) {
                if (!(item instanceof IProcessAreaHandle)) continue;
                command.addProcessArea((IProcessAreaHandle)item);
            }
        }
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        HashMap<ITeamRepository, AddConnectionsCommand> map = new HashMap<ITeamRepository, AddConnectionsCommand>();
        boolean addedSomething = false;
        boolean triedToAddWorkspaceDomain = false;
        ITeamRepository repoNode = null;
        for (Object element : selection.toList()) {
            if (element instanceof StreamsDomainNode) {
                StreamsDomainNode allStreamsNode = (StreamsDomainNode)element;
                IProjectAreaHandle projectArea = allStreamsNode.getProjectArea();
                ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
                if (projectArea == null || registry == null) continue;
                NewFlowDiagramAction.add(map, Repositories.getRepository((IItemHandle)projectArea), registry.getSelectedProcessAreas(projectArea));
                continue;
            }
            if (element instanceof WorkspacesDomainNode) {
                triedToAddWorkspaceDomain = true;
                WorkspacesDomainNode allWorkspacesNode = (WorkspacesDomainNode)element;
                ITreePathContentProvider contentProvider = allWorkspacesNode.getWorkspacesDomain().getContentProvider();
                Object[] elements = contentProvider.getElements((Object)allWorkspacesNode);
                if (elements == null) continue;
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object e = objectArray[n2];
                    if (e instanceof AbstractPlaceWrapper) {
                        AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)e);
                        NewFlowDiagramAction.add(map, wrapper.getRepository(), wrapper.getWorkspace().getItemHandle());
                        addedSomething = true;
                    }
                    ++n2;
                }
                continue;
            }
            if (element != null && Adapters.hasAdapter(element, AbstractPlaceWrapper.class)) {
                AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)Adapters.getAdapter(element, AbstractPlaceWrapper.class));
                NewFlowDiagramAction.add(map, wrapper.getRepository(), wrapper.getWorkspace().getItemHandle());
                continue;
            }
            if (element instanceof IWorkspaceSyncContext) {
                IWorkspaceSyncContext context = (IWorkspaceSyncContext)element;
                NewFlowDiagramAction.add(map, context.teamRepository(), context.getLocal().getResolvedWorkspace());
                continue;
            }
            if (!(element instanceof RepositoryNode)) continue;
            repoNode = ((RepositoryNode)element).getRepository();
        }
        if (triedToAddWorkspaceDomain && !addedSomething) {
            ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            this.newDiagramFromRepos(shell, page, map, repos);
        } else if (repoNode != null && !addedSomething) {
            this.newDiagramFromRepos(shell, page, map, new ITeamRepository[]{repoNode});
        } else {
            this.openFromMap(shell, page, map);
        }
    }

    private void newDiagramFromRepos(final Shell shell, final IWorkbenchPage page, final Map<ITeamRepository, AddConnectionsCommand> map, final ITeamRepository[] repos) {
        this.getOperationRunner().enqueue(Messages.NewFlowDiagramAction_0, (Operation)new RepositoryOperation(Arrays.asList(repos)){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewFlowDiagramAction_0, (int)repos.length);
                ITeamRepository[] iTeamRepositoryArray = repos;
                int n = repos.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeamRepository repo = iTeamRepositoryArray[n2];
                    if (sub.isCanceled()) break;
                    IContributor contributor = repo.loggedInContributor();
                    if (contributor != null) {
                        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
                        criteria.getFilterByOwnerOptional().add(contributor);
                        List workspaceHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(criteria, Integer.MAX_VALUE, (IProgressMonitor)sub.newChild(1));
                        List workspaces = repo.itemManager().fetchCompleteItems(workspaceHandles, 0, (IProgressMonitor)sub.newChild(1));
                        if (workspaces.size() == 0) {
                            NewFlowDiagramAction.add(map, repo, null);
                        } else {
                            for (IWorkspace workspace : workspaces) {
                                NewFlowDiagramAction.add(map, repo, workspace);
                            }
                        }
                    }
                    ++n2;
                }
                NewFlowDiagramAction.this.getContext().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NewFlowDiagramAction.this.openFromMap(shell, page, map);
                    }
                });
            }
        });
    }

    private void openFromMap(final Shell shell, final IWorkbenchPage page, final Map<ITeamRepository, AddConnectionsCommand> map) {
        switch (map.size()) {
            case 0: {
                break;
            }
            case 1: {
                Map.Entry<ITeamRepository, AddConnectionsCommand> entry = map.entrySet().iterator().next();
                this.newDiagram(shell, page, entry.getKey(), entry.getValue());
                break;
            }
            default: {
                SelectRepositoryPart.openDialog(this.getContext(), map, new IPartResult<ITeamRepository>(){

                    public void setResult(ITeamRepository repo) {
                        AddConnectionsCommand command = (AddConnectionsCommand)((Object)map.get(repo));
                        NewFlowDiagramAction.this.newDiagram(shell, page, repo, command);
                    }
                });
            }
        }
    }

    private void newDiagram(Shell shell, IWorkbenchPage page, ITeamRepository repo, AddConnectionsCommand command) {
        try {
            FlowVisEditor editor = (FlowVisEditor)page.openEditor((IEditorInput)new FlowVisEditorInput(repo), "com.ibm.team.filesystem.ui.editors.flowvis");
            FlowVisDiagram diagram = editor.getDiagram();
            if (command != null) {
                command.setDiagram(diagram);
                diagram.getUtil().getCommandStack().execute((Command)command);
            }
        }
        catch (PartInitException e) {
            IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
            StatusUtil.log((IStatus)status);
            ErrorDialog.openError((Shell)shell, (String)Messages.NewFlowDiagramAction_1, null, (IStatus)status);
        }
    }

    private boolean shouldEnable(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        List selectionList = selection.toList();
        Set workspaceContexts = ComponentSyncUtil.getWorkspaceContexts((Collection)selectionList);
        boolean allWorkspacesAreTracked = true;
        for (IWorkspaceSyncContext nextContext : workspaceContexts) {
            IWorkspaceConnection wc = nextContext.getLocal();
            if (manager.isWorkspaceTracked((IWorkspaceHandle)wc.getResolvedWorkspace())) continue;
            allWorkspacesAreTracked = false;
            break;
        }
        return allWorkspacesAreTracked;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.shouldEnable((IStructuredSelection)selection));
    }
}

