/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class NewComponentInContributorPlaceAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (obj != null && Adapters.hasAdapter((Object)obj, ContributorPlaceWrapper.class)) {
            ContributorPlaceWrapper wrapper = (ContributorPlaceWrapper)((Object)Adapters.getAdapter((Object)obj, ContributorPlaceWrapper.class));
            this.run(shell, wrapper.getRepository(), wrapper.getWorkspace());
        } else if (obj instanceof IWorkspaceSyncContext) {
            IWorkspaceSyncContext context = (IWorkspaceSyncContext)obj;
            this.run(shell, context.teamRepository(), context.getLocal().getResolvedWorkspace());
        }
    }

    private void run(Shell shell, ITeamRepository repo, IWorkspace workspace) {
        InputDialog dialog = new InputDialog(shell, Messages.NewComponentInContributorPlaceAction_NewComponentDialogTitle, Messages.NewComponentInContributorPlaceAction_EnterNameComponentDialogMessage, "", WorkspaceUtil.getComponentNameValidator());
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getValue();
        this.createComponent(repo, workspace, name);
    }

    private void createComponent(final ITeamRepository repo, final IWorkspace workspace, final String name) {
        this.getOperationRunner().enqueue(Messages.NewComponentInContributorPlaceAction_CreatingComponentJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector sc) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                IWorkspaceConnection wc = mgr.getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)progress.newChild(1));
                IAuditableHandle owner = WorkspaceUtil.getComponentOwner(wc);
                IComponent component = mgr.createComponent(name, owner, (IProgressMonitor)progress.newChild(1));
                IFlowNodeConnection.IComponentAdditionOp addOp = wc.componentOpFactory().addComponent((IComponentHandle)component, false);
                wc.applyComponentOperations(Collections.singletonList(addOp), (IProgressMonitor)progress.newChild(1));
            }
        });
    }
}

