/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.join.JoinWizard;
import com.ibm.team.internal.filesystem.ui.wizards.join.NewWorkspaceSeedData;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class JoinAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection sel) {
        if (sel.isEmpty() || sel.getFirstElement() == null) {
            return;
        }
        final IWorkspace streamWS = (IWorkspace)Adapters.getAdapter((Object)sel.getFirstElement(), IWorkspace.class);
        if (streamWS == null) {
            return;
        }
        final Display display = shell.getDisplay();
        final ITeamRepository repo = (ITeamRepository)streamWS.getOrigin();
        this.getOperationRunner().enqueue(Messages.JoinAction_checkingForInaccessibleSubcomponentsJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                boolean shouldJoinStream = true;
                HashSet<UUID> componentsInSeedStream = new HashSet<UUID>();
                HashSet<UUID> inaccessibleComponentsInSeedStream = new HashSet<UUID>();
                HashMap<UUID, IComponent> subcomponentsInSeedStream = new HashMap<UUID, IComponent>();
                HashMap<UUID, IComponent> subcomponentsNotInSeedStream = new HashMap<UUID, IComponent>();
                HashSet<UUID> allInaccessibleSubcomponents = new HashSet<UUID>();
                HashSet<UUID> inaccessibleSubcomponentsInSeedStream = new HashSet<UUID>();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IWorkspaceConnection stream = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)streamWS, (IProgressMonitor)progress.newChild(50));
                for (Object o : stream.getComponents()) {
                    if (!(o instanceof IComponentHandle)) continue;
                    componentsInSeedStream.add(((IComponentHandle)o).getItemId());
                }
                for (IComponentHandle c : stream.getUnreadableComponents()) {
                    inaccessibleComponentsInSeedStream.add(c.getItemId());
                }
                IComponentHierarchyResult subcomponentResult = stream.getComponentHierarchy(null);
                HashMap subcomponentsToFetch = new HashMap(subcomponentResult.getFlattenedElementsMap());
                if (!subcomponentsToFetch.isEmpty()) {
                    IComponent subcomponent;
                    IFetchResult fetchResult = stream.teamRepository().itemManager().fetchCompleteItemsPermissionAware(new ArrayList(subcomponentsToFetch.values()), 1, (IProgressMonitor)progress.newChild(50));
                    for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                        if (!(retrievedItem instanceof IComponent)) continue;
                        subcomponent = (IComponent)retrievedItem;
                        if (componentsInSeedStream.contains(subcomponent.getItemId())) {
                            subcomponentsInSeedStream.put(subcomponent.getItemId(), subcomponent);
                            continue;
                        }
                        subcomponentsNotInSeedStream.put(subcomponent.getItemId(), subcomponent);
                    }
                    for (Object missingItem : fetchResult.getMissingItems()) {
                        if (!(missingItem instanceof IComponentHandle)) continue;
                        subcomponent = (IComponentHandle)missingItem;
                        allInaccessibleSubcomponents.add(subcomponent.getItemId());
                        if (!inaccessibleComponentsInSeedStream.contains(subcomponent.getItemId())) continue;
                        inaccessibleSubcomponentsInSeedStream.add(subcomponent.getItemId());
                    }
                    if (!allInaccessibleSubcomponents.isEmpty()) {
                        String dialogMessage;
                        String dialogTitle;
                        if (!inaccessibleSubcomponentsInSeedStream.isEmpty()) {
                            int numInaccessibleComponents = inaccessibleSubcomponentsInSeedStream.size();
                            if (numInaccessibleComponents == 1) {
                                dialogTitle = Messages.JoinAction_inaccessibleSubcomponentTitle;
                                String uuid = ((UUID)inaccessibleSubcomponentsInSeedStream.iterator().next()).getUuidValue();
                                dialogMessage = NLS.bind((String)Messages.JoinAction_inaccessibleSubcomponentInStream_proceed_1, (Object)uuid);
                            } else {
                                dialogTitle = Messages.JoinAction_inaccessibleSubcomponentsTitle;
                                dialogMessage = NLS.bind((String)Messages.JoinAction_inaccessibleSubcomponentInStream_proceed_2, (Object)numInaccessibleComponents);
                            }
                            if (!DialogUtil.openQuestionDialog(shell, dialogTitle, dialogMessage, false)) {
                                shouldJoinStream = false;
                            }
                        } else {
                            int numInaccessibleComponents = allInaccessibleSubcomponents.size();
                            if (numInaccessibleComponents == 1) {
                                dialogTitle = Messages.JoinAction_inaccessibleSubcomponentTitle;
                                String uuid = ((UUID)allInaccessibleSubcomponents.iterator().next()).getUuidValue();
                                dialogMessage = NLS.bind((String)Messages.JoinAction_inaccessibleSubcomponentNotInStream, (Object)uuid);
                            } else {
                                dialogTitle = Messages.JoinAction_inaccessibleSubcomponentsTitle;
                                dialogMessage = NLS.bind((String)Messages.JoinAction_inaccessibleSubcomponentsNotInStream, (Object)numInaccessibleComponents);
                            }
                            if (!DialogUtil.openConfirm(shell, dialogTitle, dialogMessage, true)) {
                                shouldJoinStream = false;
                            }
                        }
                    }
                }
                if (shouldJoinStream) {
                    SWTUtil.greedyExec((Display)display, (Control)shell, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JoinWizard wizard = new JoinWizard(new NewWorkspaceSeedData(repo, streamWS, (IReadScope)IReadScope.FACTORY.createPrivateScope()), JoinAction.this.getContext());
                            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                            if (dialog.open() != 0) {
                                return;
                            }
                        }
                    });
                }
            }
        });
    }
}

