/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.filesystem.ide.ui.platformignores.EclipseIgnoreProvider;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.operations.IgnoreOperation;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.IgnorePatternDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.UnignoreComplexRuleDialog;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class IgnoreAction
extends AbstractActionDelegate {
    private static final String JAZZ_IGNORE_TEXT = Messages.IgnoreAction_AddIgnoreListLabel;
    private static final String JAZZ_UNIGNORE_TEXT = Messages.IgnoreAction_RemoveFromIgnoreListLabel;
    private static final String PLATFORM_UNIGNORE_TEXT = Messages.IgnoreAction_RemoveFromPlatformIgnoresLabel;
    protected Mode mode = Mode.IGNORE;

    public void run(final Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        IOperationRunner opRunner = this.getOperationRunner();
        opRunner.enqueue(Messages.IgnoreAction_UpdatingIgnoreListJobName, new Operation(){

            public void run(IProgressMonitor progress, IStatusCollector problems) throws OperationFailedException {
                Map map;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                try {
                    List<IShareable> shareables = IgnoreAction.this.extractSelectedShareables(selection, (IProgressMonitor)monitor.newChild(5));
                    map = CoreShareablesUtil.groupByContributorPlace(shareables, (IProgressMonitor)monitor.newChild(5));
                }
                catch (TeamRepositoryException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                    return;
                }
                monitor.setWorkRemaining(map.size());
                Runner runner = new Runner(shell, IgnoreAction.this.mode);
                for (Map.Entry entry : map.entrySet()) {
                    IStatus status = runner.run((ItemNamespace)entry.getKey(), (List)entry.getValue(), (IProgressMonitor)monitor.newChild(1));
                    if (status.isOK()) continue;
                    problems.reportProblem(status);
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        try {
            this.updateIgnoreMode(structuredSelection, (IProgressMonitor)TempHelper.MONITOR);
        }
        catch (FileSystemException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)"Unexpected exception while determining enablement", (Throwable)e);
        }
        if (this.mode.isDisabled) {
            action.setEnabled(false);
            action.setText(JAZZ_IGNORE_TEXT);
            return;
        }
        action.setEnabled(true);
        if (this.mode == Mode.IGNORE) {
            action.setText(JAZZ_IGNORE_TEXT);
        } else if (this.mode == Mode.UNIGNORE) {
            action.setText(JAZZ_UNIGNORE_TEXT);
        } else if (this.mode == Mode.PLATFORM) {
            action.setText(PLATFORM_UNIGNORE_TEXT);
        } else if (this.mode == Mode.DERIVED) {
            action.setText(JAZZ_UNIGNORE_TEXT);
        } else {
            action.setText(JAZZ_IGNORE_TEXT);
            action.setEnabled(false);
            StatusUtil.log((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", "Unknown mode"));
        }
    }

    public void updateIgnoreMode(IStructuredSelection selection, IProgressMonitor monitor) throws FileSystemException {
        this.mode = this.determineIgnoreMode(selection, monitor);
    }

    private Mode determineIgnoreMode(IStructuredSelection selection, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        if (selection.isEmpty()) {
            return Mode.DISABLED_NO_SELECTION;
        }
        if (!this.selectionFromSameComponent(selection, (IProgressMonitor)monitor.newChild(1))) {
            return Mode.DISABLED_MULTI_COMPONENT;
        }
        boolean modePlatformUnignore = true;
        boolean modeUnignore = true;
        boolean modeIgnore = true;
        monitor.setWorkRemaining(selection.size());
        for (Object item : selection) {
            IShareable shareable = null;
            if (item instanceof IResource) {
                IResource resource = (IResource)item;
                if (!(resource instanceof IFolder) && !(resource instanceof IFile)) {
                    return Mode.DISABLED_UNKNOWN_TYPE;
                }
                shareable = (IShareable)resource.getAdapter(IShareable.class);
            } else if (item instanceof IAdaptable) {
                shareable = (IShareable)((IAdaptable)item).getAdapter(IShareable.class);
            }
            if (shareable == null) {
                return Mode.DISABLED_UNKNOWN_TYPE;
            }
            IIgnoreManager.IIgnoreReason reason = SharingManager.getInstance().getIgnoreManager().findIgnoreReasons(shareable, (IProgressMonitor)monitor.newChild(1));
            if (reason == null) {
                modePlatformUnignore = false;
                modeUnignore = false;
            } else {
                modeIgnore = false;
                for (IIgnoreProvider.IIgnoreRule rule : reason.getRules()) {
                    if (rule.getProvider() instanceof DefaultIgnoreProvider) {
                        modePlatformUnignore = false;
                        continue;
                    }
                    if (!(rule.getProvider() instanceof EclipseIgnoreProvider)) continue;
                    modeUnignore = false;
                }
            }
            if (modeUnignore || modeIgnore || modePlatformUnignore) continue;
            return Mode.DISABLED_HETEROGENEOUS;
        }
        if (modeIgnore) {
            return Mode.IGNORE;
        }
        if (modePlatformUnignore) {
            return Mode.PLATFORM;
        }
        return Mode.UNIGNORE;
    }

    private boolean selectionFromSameComponent(IStructuredSelection selection, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)selection.size());
        IComponentHandle component = null;
        HashSet<IProject> projectsWithCurrentComponent = new HashSet<IProject>();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            IShareable shareable = null;
            Object obj = i.next();
            if (obj instanceof IResource) {
                IResource resource = (IResource)obj;
                IProject proj = resource.getProject();
                if (projectsWithCurrentComponent.contains(proj)) continue;
                projectsWithCurrentComponent.add(proj);
                shareable = (IShareable)resource.getAdapter(IShareable.class);
            } else if (obj instanceof IAdaptable) {
                shareable = (IShareable)((IAdaptable)obj).getAdapter(IShareable.class);
            }
            if (shareable == null) {
                return false;
            }
            IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            if (share == null) {
                return false;
            }
            IComponentHandle other = share.getSharingDescriptor().getComponent();
            if (component == null) {
                component = other;
                continue;
            }
            if (component.sameItemId((IItemHandle)other)) continue;
            return false;
        }
        return true;
    }

    List<IShareable> extractSelectedShareables(IStructuredSelection selection, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<IShareable> shared = new ArrayList<IShareable>(selection.size());
        List selList = selection.toList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selList.size());
        for (Object obj : selList) {
            IShareable shareable;
            if (!(obj instanceof IAdaptable) || (shareable = (IShareable)((IAdaptable)obj).getAdapter(IShareable.class)) == null || shareable.getShare((IProgressMonitor)progress.newChild(1)) == null) continue;
            shared.add(shareable);
        }
        return shared;
    }

    public Mode getMode() {
        return this.mode;
    }

    private static class InconsistentChangeException
    extends RuntimeException {
        private static final long serialVersionUID = 32438L;

        private InconsistentChangeException() {
        }
    }

    public static enum Mode {
        IGNORE(false),
        UNIGNORE(false),
        DERIVED(false),
        PLATFORM(false),
        DISABLED_NO_SELECTION(true),
        DISABLED_MULTI_COMPONENT(true),
        DISABLED_UNKNOWN_TYPE(true),
        DISABLED_HETEROGENEOUS(true);

        final boolean isDisabled;

        private Mode(boolean isDisabled) {
            this.isDisabled = isDisabled;
        }

        public boolean isDisabled() {
            return this.isDisabled;
        }
    }

    private class Runner {
        final Mode mode;
        List<IShareable> shareables = null;
        private Shell parent;
        private ItemNamespace namespace;
        private List<IgnoreRule> rules = null;

        public Runner(Shell shell, Mode mode) {
            this.parent = shell;
            this.mode = mode;
        }

        public IStatus run(ItemNamespace namespace, List<IShareable> shareables, IProgressMonitor progress) {
            IStatus iStatus;
            Assert.isTrue((!this.mode.isDisabled ? 1 : 0) != 0, (String)"May not run in disabled mode");
            this.namespace = namespace;
            this.shareables = shareables;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
            SubMonitor shareCheckProgress = monitor.newChild(1).setWorkRemaining(shareables.size());
            for (final IShareable possibleShare : shareables) {
                try {
                    if (!possibleShare.isShare((IProgressMonitor)shareCheckProgress.newChild(1))) continue;
                    this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (Runner.this.parent.isDisposed()) {
                                return;
                            }
                            MessageDialog.openInformation((Shell)Runner.this.parent, (String)Messages.IgnoreAction_NO_SHARE_TITLE, (String)NLS.bind((String)Messages.IgnoreAction_NO_SHARE_TEXT, (Object)possibleShare.getLocalPath().toPath().toOSString(), (Object)possibleShare.getLocalPath().getName()));
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (FileSystemException e) {
                    return FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)("Failed getting share for " + possibleShare.getLocalPath().toString()), (Throwable)e);
                }
            }
            try {
                switch (this.mode) {
                    case IGNORE: {
                        monitor.setTaskName(Messages.IgnoreAction_IgnoringProgressName);
                        iStatus = this.ignore((IProgressMonitor)monitor);
                        return iStatus;
                    }
                    case UNIGNORE: {
                        monitor.setTaskName(Messages.IgnoreAction_UnignoringProgressName);
                        iStatus = this.unignore((IProgressMonitor)monitor);
                        return iStatus;
                    }
                    case DERIVED: {
                        iStatus = this.derivedApology((IProgressMonitor)monitor);
                        return iStatus;
                    }
                    case PLATFORM: {
                        iStatus = this.showPlatformIgnorePreferences();
                        return iStatus;
                    }
                }
                iStatus = new Status(4, "com.ibm.team.filesystem.ide.ui", "Unexpected value for mode: " + (Object)((Object)this.mode));
                return iStatus;
            }
            catch (FileSystemException e) {
                iStatus = FileSystemStatusUtil.getStatusFor((int)4, (String)"com.ibm.team.filesystem.ide.ui", (String)"Ignore failed", (Throwable)e);
                return iStatus;
            }
            catch (TeamRepositoryException e) {
                iStatus = new Status(4, "com.ibm.team.filesystem.ide.ui", "Ignore failed", (Throwable)e);
                return iStatus;
            }
            catch (InconsistentChangeException e) {
                iStatus = new Status(4, "com.ibm.team.filesystem.ide.ui", "Could not ignore due to inconsisten change state. Reload and try again.", (Throwable)e);
                return iStatus;
            }
            finally {
                monitor.done();
                shareables = null;
                this.namespace = null;
            }
        }

        private IStatus showPlatformIgnorePreferences() {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Runner.this.parent, (String)"org.eclipse.team.ui.IgnorePreferences", null, null);
                    dialog.open();
                }
            });
            return Status.OK_STATUS;
        }

        private List<IShareable> confirmIgnoreChangedResources() {
            final IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean prompt = store.getBoolean("warn_ignore_changed_resource");
            final boolean[] proceed = new boolean[]{true};
            if (prompt) {
                this.parent.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String message = NLS.bind((String)Messages.IgnoreAction_PendingChangesDialogMessage, (Object)Messages.IgnorePendingChangeAction_1, (Object)Messages.ActivityDeleteDialog_36);
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)Runner.this.parent.getShell(), (String)Messages.IgnoreAction_IgnoreAndRemoveFromPendingChangesDialogTitle, (String)message, (String)Messages.IgnorePendingChangeAction_2, (boolean)false, null, null);
                        if (dialog.getReturnCode() == 2) {
                            store.setValue("warn_ignore_changed_resource", !dialog.getToggleState());
                            proceed[0] = true;
                        } else {
                            proceed[0] = false;
                        }
                    }
                });
            }
            return proceed[0] ? this.shareables : Collections.EMPTY_LIST;
        }

        IWorkspaceConnection getWorkspaceConnection(SubMonitor monitor) throws TeamRepositoryException {
            IConnection connection = null;
            try {
                connection = this.namespace.getConnection((IProgressMonitor)monitor);
            }
            catch (ItemNotFoundException e) {
                StatusUtil.log((IStatus)new Status(1, "com.ibm.team.filesystem.ide.ui", "Could not get connection. Committed changes will not be cancelled.", (Throwable)e));
                return null;
            }
            if (!(connection instanceof IWorkspaceConnection)) {
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (String)"Only know how to handle instances of IWorkspaceConnection. Committed changes will not be cancelled.", null);
            }
            return (IWorkspaceConnection)connection;
        }

        private IStatus ignore(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            try {
                IWorkspaceConnection connection = this.getWorkspaceConnection(monitor.newChild(10));
                this.promptForIgnorePattern(SharingManager.getInstance().getIgnoreManager(), DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor.newChild(5)));
                if (connection != null && this.hasUncommittedChanges(connection, monitor.newChild(5))) {
                    this.shareables = this.confirmIgnoreChangedResources();
                }
                if (this.shareables.isEmpty()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                IgnoreOperation op = new IgnoreOperation();
                if (this.rules != null && this.rules.size() > 0) {
                    IComponentHandle c = this.getComponent((IProgressMonitor)monitor.newChild(5));
                    op.setIgnoreRules(connection, c, this.rules, (IProgressMonitor)monitor.newChild(5));
                }
                monitor.setWorkRemaining(100);
                op.execute((IProgressMonitor)monitor.newChild(100));
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private IComponentHandle getComponent(IProgressMonitor monitor) throws FileSystemException {
            if (this.shareables == null || this.shareables.isEmpty()) {
                throw new IllegalStateException("No shareables to ignore");
            }
            IShareable shareable = this.shareables.get(0);
            IShare share = shareable.getShare(monitor);
            if (share == null) {
                throw new IllegalStateException("Attempt to ignore unshared resource");
            }
            return share.getSharingDescriptor().getComponent();
        }

        private void promptForIgnorePattern(final IIgnoreManager igMan, final DefaultIgnoreProvider dip) throws FileSystemException {
            final IgnorePatternDialog[] toQuery = new IgnorePatternDialog[1];
            final int[] result = new int[]{-1};
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IgnorePatternDialog dialog;
                    try {
                        dialog = new IgnorePatternDialog(Runner.this.parent, Runner.this.shareables, igMan, dip);
                    }
                    catch (FileSystemException e) {
                        throw new RuntimeException("Couldn't get default ignore provider");
                    }
                    dialog.setBlockOnOpen(true);
                    result[0] = dialog.open();
                    toQuery[0] = dialog;
                }
            });
            if (result[0] != 0) {
                throw new OperationCanceledException();
            }
            this.shareables = toQuery[0].getIgnoreList();
            this.rules = toQuery[0].getRules();
        }

        private IStatus unignore(IProgressMonitor progress) throws FileSystemException {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.shareables.size() * 2));
            ArrayList<IIgnoreManager.IIgnoreReason> reasons = new ArrayList<IIgnoreManager.IIgnoreReason>(this.shareables.size());
            for (IShareable shareable : this.shareables) {
                reasons.add(SharingManager.getInstance().getIgnoreManager().findIgnoreReasons(shareable, (IProgressMonitor)monitor.newChild(1)));
            }
            boolean shouldContinue = this.promptForUnignore(reasons);
            if (!shouldContinue) {
                return Status.OK_STATUS;
            }
            HashSet rules = IgnoreUtils.extractRulesFromReasons(reasons);
            monitor.setWorkRemaining(rules.size() + 1);
            DefaultIgnoreProvider dip = DefaultIgnoreProvider.getDefault((IProgressMonitor)monitor.newChild(1));
            try {
                int i = 1;
                for (IIgnoreProvider.IIgnoreRule rule : rules) {
                    monitor.setTaskName(NLS.bind((String)Messages.IgnoreAction_RemovingRuleProgressName, (Object)i, (Object)rules.size()));
                    try {
                        dip.removeIgnoreRule(rule, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (FileSystemException e) {
                        IStatus iStatus = StatusUtil.newStatus((Object)this, (Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        boolean promptForUnignore(final List<IIgnoreManager.IIgnoreReason> reasons) {
            final int[] result = new int[]{-1};
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    UnignoreComplexRuleDialog dialog = new UnignoreComplexRuleDialog(Runner.this.parent, reasons, Runner.this.shareables);
                    dialog.setBlockOnOpen(true);
                    result[0] = dialog.open();
                }
            });
            return result[0] == 0;
        }

        private IStatus derivedApology(IProgressMonitor progress) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Runner.this.parent, (String)Messages.IgnoreAction_CannotUnignoreDialogTitle, (String)Messages.IgnoreAction_DerivedFilesDialogMessage);
                }
            });
            return Status.OK_STATUS;
        }

        private boolean hasUncommittedChanges(IWorkspaceConnection wsConnection, SubMonitor monitor) throws TeamRepositoryException, FileSystemException {
            SubMonitor subProgress = monitor.newChild(5).setWorkRemaining(this.shareables.size());
            for (IShareable shareable : this.shareables) {
                ILocalChange change = shareable.getChange((IProgressMonitor)subProgress.newChild(1));
                if (change == null || change.getType() == 0) continue;
                return true;
            }
            return false;
        }
    }
}

