/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.domain.MyWorkspacesDomain;
import com.ibm.team.filesystem.ui.domain.SelectionValidator;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DuplicateWorkspaceAction
extends AbstractActionDelegate {
    public void run(final Shell shell, final IWorkbenchPage page, IStructuredSelection sel) {
        if (sel.isEmpty() || sel.getFirstElement() == null) {
            return;
        }
        final ContributorPlaceWrapper contributorPlace = (ContributorPlaceWrapper)((Object)Adapters.getAdapter((Object)sel.getFirstElement(), ContributorPlaceWrapper.class));
        if (contributorPlace == null) {
            return;
        }
        final Object parentNode = SelectionValidator.getParentNode((ISelection)sel);
        String operationName = Messages.DuplicateWorkspaceAction_DuplicatingWorkspaceJobName;
        final Display display = shell.getDisplay();
        this.getOperationRunner().enqueue(operationName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DuplicateWorkspaceAction_DuplicateWorkspaceProgressName, (int)100);
                PrepareToDuplicateWorkspaceOperation op = new PrepareToDuplicateWorkspaceOperation(contributorPlace, new DuplicateWorkspaceDilemmaHandler(shell, contributorPlace));
                FileSystemResourcesPlugin.configureOperation((IFileSystemOperation)op);
                op.run((IProgressMonitor)reporter.newChild(100));
                SWTUtil.greedyExec((Display)display, (Control)shell, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TeamPlaceEditorInput input = TeamPlaceEditorInput.newForDuplicate(contributorPlace);
                        if (parentNode instanceof RepositoryNode) {
                            input.setAddToRootFolder(true);
                        } else if (parentNode instanceof DomainSubtreeRoot) {
                            DomainSubtreeRoot rootNode = (DomainSubtreeRoot)parentNode;
                            if (rootNode.getDomain() instanceof MyWorkspacesDomain) {
                                input.setAddToRootFolder(true);
                            }
                        } else if (parentNode instanceof FolderNode) {
                            FolderNode folderNode = (FolderNode)parentNode;
                            input.setParentFolder(folderNode.getItem());
                        }
                        TeamPlacePart2.open(page, input);
                    }
                });
            }
        });
    }

    private class DuplicateWorkspaceDilemmaHandler
    extends ChangeHistoryChangeSetsDilemmaHandler {
        private final Shell shell;
        private ContributorPlaceWrapper contributorPlace;
        private WarnBackupUserWithConsole backupHandler;
        private WarnCommitUser warnCommitUser;

        public DuplicateWorkspaceDilemmaHandler(Shell shell, ContributorPlaceWrapper contributorPlace) {
            this.shell = shell;
            this.contributorPlace = contributorPlace;
            this.backupHandler = new WarnBackupUserWithConsole(shell, Messages.DuplicateWorkspaceAction_ConfirmDuplicateWorkspaceDialogTitle);
            this.warnCommitUser = new WarnCommitUser(shell, Messages.DuplicateWorkspaceAction_ConfirmDuplicateWorkspaceDialogTitle, (BackupDilemmaHandler)this.backupHandler);
        }

        public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
            int code = DialogUtil.openYesNoCancel(this.shell, Messages.DuplicateWorkspaceAction_ConfirmDuplicateWorkspaceDialogTitle, NLS.bind((String)Messages.DuplicateWorkspaceAction_PendingChangesDialogMessage, (Object)this.getWorkspaceName()), true);
            switch (code) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 3;
                }
            }
            return 1;
        }

        public int activeChangeSets(List activeChangeSets, boolean loggedInUserIsOwner) {
            if (loggedInUserIsOwner) {
                int code = DialogUtil.openYesNoCancel(this.shell, Messages.DuplicateWorkspaceAction_ConfirmDuplicateWorkspaceDialogTitle, NLS.bind((String)Messages.DuplicateWorkspaceAction_ActiveChangesDialogMessage, (Object)activeChangeSets.size(), (Object)this.getWorkspaceName()), true);
                switch (code) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 3;
                    }
                }
                return 1;
            }
            if (DialogUtil.openConfirm(this.shell, Messages.DuplicateWorkspaceAction_ConfirmDuplicateWorkspaceDialogTitle, NLS.bind((String)Messages.DuplicateWorkspaceAction_ActiveChangeSetsLossCommentsDialogMessage, (Object)activeChangeSets.size(), (Object)this.getWorkspaceName()), true)) {
                return 3;
            }
            return 1;
        }

        public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
            return new WarnOutOfSync(this.shell, Messages.DuplicateWorkspaceAction_DuplicatingWorkspaceJobName, this.getBackupDilemmaHandler());
        }

        public BackupDilemmaHandler getBackupDilemmaHandler() {
            return this.backupHandler;
        }

        private String getWorkspaceName() {
            return this.contributorPlace.getWorkspace().getName();
        }

        public int deletedContent(Collection<IShareable> contentDeleted) {
            return this.warnCommitUser.deletedContent(contentDeleted);
        }

        public CommitDilemmaHandler getCommitDilemmaHandler() {
            return this.warnCommitUser;
        }

        public int inaccessibleSubcomponents(Set<UUID> allInaccessibleSubcomponents, Set<UUID> inaccessibleSubcomponentsInSeedWorkspace) {
            String dialogMessage;
            String dialogTitle;
            if (!inaccessibleSubcomponentsInSeedWorkspace.isEmpty()) {
                String dialogMessage2;
                String dialogTitle2;
                int numInaccessibleComponents = inaccessibleSubcomponentsInSeedWorkspace.size();
                if (numInaccessibleComponents == 1) {
                    dialogTitle2 = Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentTitle;
                    String uuid = inaccessibleSubcomponentsInSeedWorkspace.iterator().next().getUuidValue();
                    dialogMessage2 = NLS.bind((String)Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentInWorkspace, (Object)uuid);
                } else {
                    dialogTitle2 = Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentsTitle;
                    dialogMessage2 = NLS.bind((String)Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentsInWorkspace, (Object)numInaccessibleComponents);
                }
                DialogUtil.openError(this.shell, dialogTitle2, dialogMessage2);
                return 1;
            }
            int numInaccessibleComponents = allInaccessibleSubcomponents.size();
            if (numInaccessibleComponents == 1) {
                dialogTitle = Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentTitle;
                String uuid = allInaccessibleSubcomponents.iterator().next().getUuidValue();
                dialogMessage = NLS.bind((String)Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentNotInWorkspace, (Object)uuid);
            } else {
                dialogTitle = Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentsTitle;
                dialogMessage = NLS.bind((String)Messages.DuplicateWorkspaceAction_inaccessibleSubcomponentsNotInWorkspace, (Object)numInaccessibleComponents);
            }
            if (DialogUtil.openConfirm(this.shell, dialogTitle, dialogMessage, true)) {
                return 0;
            }
            return 1;
        }
    }

    private static class PrepareToDuplicateWorkspaceOperation
    extends ChangeHistoryChangeSetsOperation {
        private final ContributorPlaceWrapper fContributorPlace;
        private IWorkspaceConnection fSeedWorkspace;

        protected PrepareToDuplicateWorkspaceOperation(ContributorPlaceWrapper contributorPlace, DuplicateWorkspaceDilemmaHandler dilemmaHandler) {
            super((ChangeHistoryChangeSetsDilemmaHandler)dilemmaHandler);
            this.fContributorPlace = contributorPlace;
        }

        protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DuplicateWorkspaceAction_DuplicateWorkspaceProgressName, (int)100);
            this.fSeedWorkspace = this.fContributorPlace.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
            DuplicateWorkspaceDilemmaHandler dilemmaHandler = (DuplicateWorkspaceDilemmaHandler)this.getDilemmaHandler();
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(dilemmaHandler.getOutOfSyncDilemmaHandler());
            verifyOp.addToVerify(this.fSeedWorkspace);
            verifyOp.run((IProgressMonitor)progress.newChild(10));
            HashSet<UUID> componentsInSeedWorkspace = new HashSet<UUID>();
            HashSet<UUID> inaccessibleComponentsInSeedWorkspace = new HashSet<UUID>();
            HashMap<UUID, IComponent> subcomponentsInSeedWorkspace = new HashMap<UUID, IComponent>();
            HashMap<UUID, IComponent> subcomponentsNotInSeedWorkspace = new HashMap<UUID, IComponent>();
            HashSet<UUID> allInaccessibleSubcomponents = new HashSet<UUID>();
            HashSet<UUID> inaccessibleSubcomponentsInSeedWorkspace = new HashSet<UUID>();
            for (Object o : this.fSeedWorkspace.getComponents()) {
                if (!(o instanceof IComponentHandle)) continue;
                componentsInSeedWorkspace.add(((IComponentHandle)o).getItemId());
            }
            for (IComponentHandle c : this.fSeedWorkspace.getUnreadableComponents()) {
                inaccessibleComponentsInSeedWorkspace.add(c.getItemId());
            }
            IComponentHierarchyResult subcomponentResult = this.fSeedWorkspace.getComponentHierarchy(null);
            HashMap subcomponentsToFetch = new HashMap(subcomponentResult.getFlattenedElementsMap());
            if (!subcomponentsToFetch.isEmpty()) {
                IComponent subcomponent;
                IFetchResult fetchResult = this.fSeedWorkspace.teamRepository().itemManager().fetchCompleteItemsPermissionAware(new ArrayList(subcomponentsToFetch.values()), 1, (IProgressMonitor)progress.newChild(10));
                for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                    if (!(retrievedItem instanceof IComponent)) continue;
                    subcomponent = (IComponent)retrievedItem;
                    if (componentsInSeedWorkspace.contains(subcomponent.getItemId())) {
                        subcomponentsInSeedWorkspace.put(subcomponent.getItemId(), subcomponent);
                        continue;
                    }
                    subcomponentsNotInSeedWorkspace.put(subcomponent.getItemId(), subcomponent);
                }
                for (Object missingItem : fetchResult.getMissingItems()) {
                    if (!(missingItem instanceof IComponentHandle)) continue;
                    subcomponent = (IComponentHandle)missingItem;
                    allInaccessibleSubcomponents.add(subcomponent.getItemId());
                    if (!inaccessibleComponentsInSeedWorkspace.contains(subcomponent.getItemId())) continue;
                    inaccessibleSubcomponentsInSeedWorkspace.add(subcomponent.getItemId());
                }
                if (!allInaccessibleSubcomponents.isEmpty()) {
                    int result = dilemmaHandler.inaccessibleSubcomponents(allInaccessibleSubcomponents, inaccessibleSubcomponentsInSeedWorkspace);
                    switch (result) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            throw new OperationCanceledException();
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
            progress.setWorkRemaining(70);
            progress.subTask(Messages.DuplicateWorkspaceAction_CheckinLocalChangesProgressName);
            Set<ConfigurationFacade> componentDescriptors = this.getComponentDescriptors(this.fSeedWorkspace);
            this.checkinPendingChanges(componentDescriptors, dilemmaHandler, false, (IProgressMonitor)progress.newChild(50));
            List activeChangeSets = this.fSeedWorkspace.activeChangeSets();
            if (!activeChangeSets.isEmpty()) {
                boolean loggedInUserIsOwner = this.fSeedWorkspace.getOwner().sameItemId((IItemHandle)this.fSeedWorkspace.teamRepository().loggedInContributor());
                int result = dilemmaHandler.activeChangeSets(activeChangeSets, loggedInUserIsOwner);
                switch (result) {
                    case 3: {
                        break;
                    }
                    case 0: {
                        this.fSeedWorkspace.ensureClosed((Collection)activeChangeSets, (IProgressMonitor)progress.newChild(20));
                        break;
                    }
                    case 1: {
                        throw new OperationCanceledException();
                    }
                    case 2: {
                        throw new FileSystemException(NLS.bind((String)Messages.DuplicateWorkspaceAction_ActiveChangeSetsPresent, (Object)this.fContributorPlace.getWorkspace().getName()));
                    }
                    default: {
                        return;
                    }
                }
            }
        }

        private Set<ConfigurationFacade> getComponentDescriptors(IWorkspaceConnection connection) throws TeamRepositoryException {
            List components = connection.getComponents();
            HashSet<ConfigurationFacade> result = new HashSet<ConfigurationFacade>();
            for (Object object : components) {
                IComponentHandle component = (IComponentHandle)object;
                result.add(new ConfigurationFacade((IConnection)connection, component));
            }
            return result;
        }

        protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
            if (this.fSeedWorkspace == null) {
                throw new IllegalStateException();
            }
            SubMonitor entryMon = SubMonitor.convert((IProgressMonitor)progress, (int)affectedAreas.size());
            for (Map.Entry<ISandbox, Set<ConfigurationFacade>> entry : affectedAreas.entrySet()) {
                SubMonitor configMon = entryMon.newChild(1);
                configMon.setWorkRemaining(entry.getValue().size());
                for (ConfigurationFacade desc : entry.getValue()) {
                    refresher.addToRefresh(Collections.singleton(entry.getKey()), this.fSeedWorkspace.getContextHandle(), desc.getComponentHandle(), (IProgressMonitor)configMon.newChild(1));
                }
            }
        }
    }
}

