/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.domain.MyWorkspacesDomain;
import com.ibm.team.filesystem.ui.domain.SelectionValidator;
import com.ibm.team.filesystem.ui.domain.StreamsDomain;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DuplicateStreamAction
extends AbstractActionDelegate {
    public void run(final Shell shell, final IWorkbenchPage page, final IStructuredSelection sel) {
        if (sel.isEmpty() || sel.getFirstElement() == null) {
            return;
        }
        final TeamPlaceWrapper teamPlaceWrapper = (TeamPlaceWrapper)((Object)Adapters.getAdapter((Object)sel.getFirstElement(), TeamPlaceWrapper.class));
        if (teamPlaceWrapper == null) {
            return;
        }
        final Display display = shell.getDisplay();
        this.getOperationRunner().enqueue(Messages.DuplicateStreamAction_JobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                boolean shouldDuplicate = true;
                HashSet<UUID> componentsInSeedStream = new HashSet<UUID>();
                HashSet<UUID> inaccessibleComponentsInSeedStream = new HashSet<UUID>();
                HashMap<UUID, IComponent> subcomponentsInSeedStream = new HashMap<UUID, IComponent>();
                HashMap<UUID, IComponent> subcomponentsNotInSeedStream = new HashMap<UUID, IComponent>();
                HashSet<UUID> allInaccessibleSubcomponents = new HashSet<UUID>();
                HashSet<UUID> inaccessibleSubcomponentsInSeedStream = new HashSet<UUID>();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IWorkspaceConnection stream = teamPlaceWrapper.getWorkspaceConnection((IProgressMonitor)progress.newChild(50), true);
                for (Object o : stream.getComponents()) {
                    if (!(o instanceof IComponentHandle)) continue;
                    componentsInSeedStream.add(((IComponentHandle)o).getItemId());
                }
                for (IComponentHandle c : stream.getUnreadableComponents()) {
                    inaccessibleComponentsInSeedStream.add(c.getItemId());
                }
                IComponentHierarchyResult subcomponentResult = stream.getComponentHierarchy(null);
                HashMap subcomponentsToFetch = new HashMap(subcomponentResult.getFlattenedElementsMap());
                if (!subcomponentsToFetch.isEmpty()) {
                    IComponent subcomponent;
                    IFetchResult fetchResult = stream.teamRepository().itemManager().fetchCompleteItemsPermissionAware(new ArrayList(subcomponentsToFetch.values()), 1, (IProgressMonitor)progress.newChild(50));
                    for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                        if (!(retrievedItem instanceof IComponent)) continue;
                        subcomponent = (IComponent)retrievedItem;
                        if (componentsInSeedStream.contains(subcomponent.getItemId())) {
                            subcomponentsInSeedStream.put(subcomponent.getItemId(), subcomponent);
                            continue;
                        }
                        subcomponentsNotInSeedStream.put(subcomponent.getItemId(), subcomponent);
                    }
                    for (Object missingItem : fetchResult.getMissingItems()) {
                        if (!(missingItem instanceof IComponentHandle)) continue;
                        subcomponent = (IComponentHandle)missingItem;
                        allInaccessibleSubcomponents.add(subcomponent.getItemId());
                        if (!inaccessibleComponentsInSeedStream.contains(subcomponent.getItemId())) continue;
                        inaccessibleSubcomponentsInSeedStream.add(subcomponent.getItemId());
                    }
                    if (!allInaccessibleSubcomponents.isEmpty()) {
                        String dialogMessage;
                        String dialogTitle;
                        if (!inaccessibleSubcomponentsInSeedStream.isEmpty()) {
                            int numInaccessibleComponents = inaccessibleSubcomponentsInSeedStream.size();
                            if (numInaccessibleComponents == 1) {
                                dialogTitle = Messages.DuplicateStreamAction_inaccessibleSubcomponentTitle;
                                String uuid = ((UUID)inaccessibleSubcomponentsInSeedStream.iterator().next()).getUuidValue();
                                dialogMessage = NLS.bind((String)Messages.DuplicateStreamAction_inaccessibleSubcomponentInStream, (Object)uuid);
                            } else {
                                dialogTitle = Messages.DuplicateStreamAction_inaccessibleSubcomponentsTitle;
                                dialogMessage = NLS.bind((String)Messages.DuplicateStreamAction_inaccessibleSubcomponentsInStream, (Object)numInaccessibleComponents);
                            }
                            DialogUtil.openError(shell, dialogTitle, dialogMessage);
                            shouldDuplicate = false;
                        } else {
                            int numInaccessibleComponents = allInaccessibleSubcomponents.size();
                            if (numInaccessibleComponents == 1) {
                                dialogTitle = Messages.DuplicateStreamAction_inaccessibleSubcomponentTitle;
                                String uuid = ((UUID)allInaccessibleSubcomponents.iterator().next()).getUuidValue();
                                dialogMessage = NLS.bind((String)Messages.DuplicateStreamAction_inaccessibleSubcomponentNotInStream, (Object)uuid);
                            } else {
                                dialogTitle = Messages.DuplicateStreamAction_inaccessibleSubcomponentsTitle;
                                dialogMessage = NLS.bind((String)Messages.DuplicateStreamAction_inaccessibleSubcomponentsNotInStream, (Object)numInaccessibleComponents);
                            }
                            if (!DialogUtil.openConfirm(shell, dialogTitle, dialogMessage, true)) {
                                shouldDuplicate = false;
                            }
                        }
                    }
                }
                if (shouldDuplicate) {
                    final Object parentNode = SelectionValidator.getParentNode((ISelection)sel);
                    SWTUtil.greedyExec((Display)display, (Control)shell, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TeamPlaceEditorInput input = TeamPlaceEditorInput.newForDuplicate(teamPlaceWrapper);
                            if (parentNode instanceof RepositoryNode) {
                                input.setAddToRootFolder(true);
                                input.setFolderOwner((IAuditable)teamPlaceWrapper.getRepository().loggedInContributor());
                            } else if (parentNode instanceof DomainSubtreeRoot) {
                                DomainSubtreeRoot rootNode = (DomainSubtreeRoot)parentNode;
                                if (rootNode.getDomain() instanceof MyWorkspacesDomain) {
                                    input.setAddToRootFolder(true);
                                    input.setFolderOwner((IAuditable)teamPlaceWrapper.getRepository().loggedInContributor());
                                } else if (rootNode.getDomain() instanceof StreamsDomain) {
                                    input.setAddToRootFolder(true);
                                    if (rootNode.getCategoryElement() instanceof IProjectArea) {
                                        IProjectArea projectArea = (IProjectArea)rootNode.getCategoryElement();
                                        input.setFolderOwner((IAuditable)projectArea);
                                    }
                                }
                            } else if (parentNode instanceof FolderNode) {
                                FolderNode folderNode = (FolderNode)parentNode;
                                input.setParentFolder(folderNode.getItem());
                            }
                            TeamPlacePart2.open(page, input);
                        }
                    });
                }
            }
        });
    }
}

