/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.changes.dialogs.ChangesDialog;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class DeliverAction
extends AbstractActionDelegate {
    private List selectedResources;
    private Collection<IRemoteActivity> outgoingActivities;
    private Collection<IRemoteActivity> associatedOutgoingActivities;
    private Collection<IRemoteActivity> conflictedOutgoingActivities;
    private Collection<IComponentSyncContext> contextWithLocalChanges;
    private static final String CHECKIN_NAME = Messages.DeliverAction_CheckinLocalChangesDialogTitle;

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IStructuredSelection ss = this.getStructuredSelection();
        boolean hasOutgoing = true;
        this.selectedResources = ss.toList();
        Collection[] results = ComponentSyncUtil.getRemoteActivities((Collection)this.selectedResources, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        this.outgoingActivities = results[0];
        this.associatedOutgoingActivities = results[1];
        this.conflictedOutgoingActivities = results[2];
        this.contextWithLocalChanges = results[3];
        if (this.outgoingActivities.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.DeliverAction_CannotDeliverTitle, (String)Messages.DeliverAction_NoOutgoingChangeSets);
            return;
        }
        for (IRemoteActivity activity : this.outgoingActivities) {
            IComponentSyncContext context = activity.getActivitySource().getModel();
            IWorkspaceConnection ws = context.getRemoteOutgoingTeamPlace();
            if (hasOutgoing &= ws != null && !ws.equals((Object)context.getOutgoingTeamPlace())) continue;
            MessageDialog.openInformation((Shell)shell, (String)Messages.DeliverAction_CannotDeliverTitle, (String)Messages.DeliverAction_NoFlowTarget);
            return;
        }
        if (this.contextWithLocalChanges != null && this.contextWithLocalChanges.size() > 0 && MessageDialog.openQuestion((Shell)shell, (String)CHECKIN_NAME, (String)Messages.DeliverAction_NotIncludeLocalChangesDialogMessage)) {
            this.checkInLocalChanges(shell, this.getPart());
        } else {
            this.deliverSelectedChanges(shell, this.getPart());
        }
    }

    private void checkInLocalChanges(final Shell shell, final IWorkbenchPart targetPart) {
        final Display display = shell.getDisplay();
        this.getOperationRunner().enqueue(CHECKIN_NAME, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)DeliverAction.this.contextWithLocalChanges.size());
                WarnCommitUser problemHandler = new WarnCommitUser(shell, CHECKIN_NAME);
                for (IComponentSyncContext context : DeliverAction.this.contextWithLocalChanges) {
                    context.autoCommitLocalChanges((Collection)context.getLocalChangeSource().getLocalChanges(), false, (CommitDilemmaHandler)problemHandler, (IProgressMonitor)progress.newChild(1));
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DeliverAction.this.deliverSelectedChanges(shell, targetPart);
                    }
                });
            }
        });
    }

    private void deliverSelectedChanges(Shell shell, IWorkbenchPart targetPart) {
        List<IRemoteActivity> activitiesToDeliver;
        ChangesDialog dialog = new ChangesDialog(targetPart, this.outgoingActivities, this.associatedOutgoingActivities, this.conflictedOutgoingActivities, this.selectedResources, false);
        if (dialog.open() == 0 && (activitiesToDeliver = dialog.getSelectedActivities()).size() > 0) {
            com.ibm.team.filesystem.ui.changes.actions.DeliverAction action = new com.ibm.team.filesystem.ui.changes.actions.DeliverAction();
            action.deliver(shell, activitiesToDeliver);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(true);
    }

    protected Object adaptEditorInput(IEditorInput input) {
        return Adapters.getAdapter((Object)input, IResource.class);
    }
}

