/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteSnapshotAction
extends AbstractActionDelegate {
    public static void deleteWithRawSnapshotWrappers(final Shell shell, final List<RawSnapshotWrapper> rawWrappers, final IOperationRunner runner) {
        int size = rawWrappers.size();
        String opName = size == 1 ? NLS.bind((String)Messages.DeleteSnapshotAction_DeletingSnapshotJobName, (Object)rawWrappers.get(0).getSnapshot().getName()) : Messages.DeleteSnapshotAction_DeletingSnapshotsJobName;
        final ArrayList<SnapshotWrapper> snapshotWrappers = new ArrayList<SnapshotWrapper>(rawWrappers.size());
        Iterator<RawSnapshotWrapper> iterator = rawWrappers.iterator();
        while (iterator.hasNext()) {
            SnapshotWrapper rawWrapper = (SnapshotWrapper)iterator.next();
            if (!(rawWrapper instanceof SnapshotWrapper)) continue;
            snapshotWrappers.add(rawWrapper);
            iterator.remove();
        }
        if (rawWrappers.isEmpty()) {
            DeleteSnapshotAction.deleteSnapshots(shell, snapshotWrappers, runner);
            return;
        }
        runner.enqueue(opName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                IWorkspaceHandle workspace;
                HashMap<UUID, IWorkspaceHandle> workspaceHandles;
                HashMap<String, ITeamRepository> repositoryMap = new HashMap<String, ITeamRepository>();
                HashMap workspaceHandlesByRepository = new HashMap();
                HashMap workspacesByRepository = new HashMap();
                for (RawSnapshotWrapper wrapper : rawWrappers) {
                    ITeamRepository repository = wrapper.getRepository();
                    repositoryMap.put(repository.getRepositoryURI(), repository);
                    workspaceHandles = (HashMap<UUID, IWorkspaceHandle>)workspaceHandlesByRepository.get(repository.getRepositoryURI());
                    if (workspaceHandles == null) {
                        workspaceHandles = new HashMap<UUID, IWorkspaceHandle>();
                        workspaceHandlesByRepository.put(repository.getRepositoryURI(), workspaceHandles);
                    }
                    workspace = wrapper.getSnapshot().getOwner();
                    workspaceHandles.put(workspace.getItemId(), workspace);
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositoryMap.size() * 2));
                for (ITeamRepository repository : repositoryMap.values()) {
                    workspaceHandles = (Map)workspaceHandlesByRepository.get(repository.getRepositoryURI());
                    try {
                        IFetchResult fetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(new ArrayList(workspaceHandles.values()), 0, (IProgressMonitor)progress.newChild(1));
                        List retrievedItems = fetchResult.getRetrievedItems();
                        if (retrievedItems.isEmpty()) continue;
                        HashMap<UUID, IWorkspace> workspaces = new HashMap<UUID, IWorkspace>();
                        workspacesByRepository.put(repository.getRepositoryURI(), workspaces);
                        for (Object obj : retrievedItems) {
                            IWorkspace workspace2 = (IWorkspace)obj;
                            workspaces.put(workspace2.getItemId(), workspace2);
                        }
                    }
                    catch (TeamRepositoryException fetchResult) {
                        // empty catch block
                    }
                }
                for (RawSnapshotWrapper wrapper : rawWrappers) {
                    Map workspaces = (Map)workspacesByRepository.get(wrapper.getRepository().getRepositoryURI());
                    if (workspaces != null) {
                        workspace = (IWorkspace)workspaces.get(wrapper.getSnapshot().getOwner().getItemId());
                        if (workspace == null) continue;
                        snapshotWrappers.add(new SnapshotWrapper((IWorkspace)workspace, wrapper.getSnapshot()));
                        continue;
                    }
                    snapshotWrappers.add(new SnapshotWrapper(null, wrapper.getSnapshot()));
                }
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DeleteSnapshotAction.deleteSnapshots(shell, snapshotWrappers, runner);
                    }
                });
            }
        });
    }

    public static void deleteSnapshots(final Shell shell, final List<SnapshotWrapper> snapshotWrappers, IOperationRunner runner) {
        for (SnapshotWrapper wrapper : snapshotWrappers) {
            if (wrapper.getWorkspace() != null) continue;
            MessageDialog.openWarning((Shell)shell, (String)Messages.DeleteSnapshotAction_OrphanedSnapshotsDialogTitle, (String)NLS.bind((String)Messages.DeleteSnapshotAction_OrphanedSnapshotsDialogMessage, (Object)wrapper.getSnapshot().getName()));
            return;
        }
        int size = snapshotWrappers.size();
        if (size == 1) {
            SnapshotWrapper snapshotWrapper = snapshotWrappers.get(0);
            if (!DialogUtil.openQuestionDialog(shell, Messages.DeleteSnapshotAction_ConfirmDisassociateDialogTitle, NLS.bind((String)Messages.DeleteSnapshotAction_DisassociateSnapshotDialogMessage, (Object)snapshotWrapper.getSnapshot().getName(), (Object)snapshotWrapper.getWorkspace().getName()), false)) {
                return;
            }
        } else if (size > 1) {
            if (!DialogUtil.openQuestionDialog(shell, Messages.DeleteSnapshotAction_ConfirmDisassociateDialogTitle, NLS.bind((String)Messages.DeleteSnapshotAction_DisassociateSnapshotsDialogMessage, (Object)String.valueOf(size)), false)) {
                return;
            }
        } else {
            return;
        }
        String opName = size == 1 ? NLS.bind((String)Messages.DeleteSnapshotAction_DeletingSnapshotJobName, (Object)snapshotWrappers.get(0).getSnapshot().getName()) : Messages.DeleteSnapshotAction_DeletingSnapshotsJobName;
        runner.enqueue(opName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                HashMap<Object, ArrayList<IWorkspaceHandle>> owners = new HashMap<Object, ArrayList<IWorkspaceHandle>>();
                final HashMap<UUID, IBaselineSet> ownerToSnapshot = new HashMap<UUID, IBaselineSet>(snapshotWrappers.size());
                for (SnapshotWrapper wrapper : snapshotWrappers) {
                    ITeamRepository repo = wrapper.getRepository();
                    ArrayList<IWorkspaceHandle> ownersInRepo = (ArrayList<IWorkspaceHandle>)owners.get(repo);
                    if (ownersInRepo == null) {
                        ownersInRepo = new ArrayList<IWorkspaceHandle>();
                        owners.put(repo, ownersInRepo);
                    }
                    ownersInRepo.add(wrapper.getSnapshot().getOwner());
                    ownerToSnapshot.put(wrapper.getSnapshot().getOwner().getItemId(), wrapper.getSnapshot());
                }
                SubMonitor loopMonitor = progress.newChild(10).setWorkRemaining(owners.size());
                for (Map.Entry entry : owners.entrySet()) {
                    ITeamRepository repo = (ITeamRepository)entry.getKey();
                    final IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware((List)entry.getValue(), 1, (IProgressMonitor)loopMonitor.newChild(1));
                    if (fetchResult.getNotFoundItems().isEmpty()) continue;
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkspace deletedOwner = (IWorkspace)fetchResult.getNotFoundItems().get(0);
                            IBaselineSet snapshot = (IBaselineSet)ownerToSnapshot.get(deletedOwner.getItemId());
                            MessageDialog.openWarning((Shell)shell, (String)Messages.DeleteSnapshotAction_OrphanedSnapshotsDialogTitle, (String)NLS.bind((String)Messages.DeleteSnapshotAction_OrphanedSnapshotsDialogMessage, (Object)snapshot.getName()));
                        }
                    });
                    return;
                }
                loopMonitor = progress.newChild(10).setWorkRemaining(snapshotWrappers.size());
                HashMap<UUID, IWorkspaceConnection> hashMap = new HashMap<UUID, IWorkspaceConnection>();
                HashMap baselineSetByRepository = new HashMap();
                for (SnapshotWrapper snapshotWrapper : snapshotWrappers) {
                    ArrayList<IBaselineSet> baselinesets;
                    ITeamRepository repo = snapshotWrapper.getRepository();
                    IWorkspace workspace = snapshotWrapper.getWorkspace();
                    IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)hashMap.get(workspace.getItemId());
                    if (workspaceConnection == null) {
                        workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)loopMonitor.newChild(1));
                        hashMap.put(workspace.getItemId(), workspaceConnection);
                    } else {
                        loopMonitor.worked(1);
                    }
                    IBaselineSet snapshot = snapshotWrapper.getSnapshot();
                    HashMap<IWorkspaceConnection, ArrayList<IBaselineSet>> workspaceSnapshotMap = (HashMap<IWorkspaceConnection, ArrayList<IBaselineSet>>)baselineSetByRepository.get(repo);
                    if (workspaceSnapshotMap == null) {
                        workspaceSnapshotMap = new HashMap<IWorkspaceConnection, ArrayList<IBaselineSet>>();
                    }
                    if ((baselinesets = (ArrayList<IBaselineSet>)workspaceSnapshotMap.get(workspaceConnection)) == null) {
                        baselinesets = new ArrayList<IBaselineSet>();
                    }
                    baselinesets.add(snapshot);
                    workspaceSnapshotMap.put(workspaceConnection, baselinesets);
                    baselineSetByRepository.put(repo, workspaceSnapshotMap);
                }
                SubMonitor outerLoopProgress = progress.newChild(80).setWorkRemaining(baselineSetByRepository.size());
                for (Map.Entry repoToWorkspaceMapEntry : baselineSetByRepository.entrySet()) {
                    SubMonitor innerLoopProgress = outerLoopProgress.newChild(1).setWorkRemaining(((Map)repoToWorkspaceMapEntry.getValue()).size());
                    for (Map.Entry workspaceTosnapshotsMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                        List snapshotList = (List)workspaceTosnapshotsMap.getValue();
                        if (snapshotList.size() <= 0) continue;
                        ((IWorkspaceConnection)workspaceTosnapshotsMap.getKey()).removeBaselineSets((Collection)snapshotList, (IProgressMonitor)innerLoopProgress.newChild(1));
                    }
                }
            }
        });
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<SnapshotWrapper> snapshotWrappers = this.getSnapshotWrappers(selection);
        DeleteSnapshotAction.deleteSnapshots(shell, snapshotWrappers, this.getOperationRunner());
    }

    private List<SnapshotWrapper> getSnapshotWrappers(IStructuredSelection selection) {
        ArrayList<SnapshotWrapper> wrappers = new ArrayList<SnapshotWrapper>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            SnapshotWrapper wrapper = (SnapshotWrapper)((Object)Adapters.getAdapter((Object)o, SnapshotWrapper.class));
            if (wrapper != null) {
                wrappers.add(wrapper);
            }
            ++n2;
        }
        return wrappers;
    }
}

