/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.actions.teamplace.SafelyDeleteStreamDialog;
import com.ibm.team.filesystem.ui.actions.teamplace.UnloadAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteContributorPlaceAction
extends CommonAction {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IOperationRunner runner = this.getOperationRunner();
        ArrayList workspaces = NewCollection.arrayList();
        for (Object next : selection.toList()) {
            if (!(next instanceof AbstractPlaceWrapper)) continue;
            workspaces.add((AbstractPlaceWrapper)((Object)next));
        }
        DeleteContributorPlaceAction.deleteWorkspaces(shell, workspaces, runner);
    }

    public static void deleteWorkspaces(final Shell shell, List<AbstractPlaceWrapper> wrappers, IOperationRunner runner) {
        boolean isDeleteStreams;
        boolean isDeleteWorkspaces;
        ArrayList repoHandles = NewCollection.arrayList();
        ArrayList streamHandles = NewCollection.arrayList();
        final ArrayList handles = NewCollection.arrayList();
        ITeamRepository repo = null;
        AbstractPlaceWrapper snapshotPeer = null;
        final ArrayList workspaceWrappers = NewCollection.arrayList();
        final ArrayList streamWrappers = NewCollection.arrayList();
        for (AbstractPlaceWrapper apw : wrappers) {
            repo = apw.getRepository();
            handles.add(apw.getWorkspace());
            if (apw instanceof ContributorPlaceWrapper) {
                repoHandles.add(apw.getWorkspace());
                workspaceWrappers.add((ContributorPlaceWrapper)apw);
                continue;
            }
            streamHandles.add(apw.getWorkspace());
            streamWrappers.add((TeamPlaceWrapper)apw);
        }
        String message = "";
        boolean isDeleteContent = true;
        if (workspaceWrappers.size() > 0) {
            if (workspaceWrappers.size() == 1) {
                String name = ((ContributorPlaceWrapper)((Object)workspaceWrappers.get(0))).getWorkspace().getName();
                message = NLS.bind((String)Messages.DeleteContributorPlaceAction_DeleteWorkspaceMessage, (Object)name);
            } else {
                message = NLS.bind((String)Messages.DeleteContributorPlaceAction_DeleteWorkspacesMessage, (Object)workspaceWrappers.size());
            }
            UnloadAction.UnshareWarningResults promptResults = UnloadAction.promptIfNeeded(shell, Messages.DeleteContributorPlaceAction_ConfirmDeleteDialogTitle, message, repoHandles, true, false);
            isDeleteWorkspaces = !promptResults.isCancelled();
            isDeleteContent = promptResults.isDeleteContent();
        } else {
            isDeleteWorkspaces = false;
        }
        if (streamWrappers.size() > 0) {
            SafelyDeleteStreamDialog dialog = new SafelyDeleteStreamDialog(shell, repo, streamHandles);
            int result = dialog.open();
            isDeleteStreams = result == 0;
            snapshotPeer = dialog.getWorkspace();
        } else {
            isDeleteStreams = false;
        }
        if (!isDeleteWorkspaces && !isDeleteStreams) {
            return;
        }
        final AbstractPlaceWrapper snapshotPeer2 = snapshotPeer;
        final boolean isDeleteContentFinal = isDeleteContent;
        if (DeleteContributorPlaceAction.cancelUnloadForOutgoingChanges(shell, handles)) {
            return;
        }
        String jobName = Messages.DeleteContributorPlaceAction_DeleteWorkspaceAndStreamJobName;
        if (isDeleteWorkspaces && !isDeleteStreams) {
            jobName = Messages.DeleteContributorPlaceAction_DeleteWorkspaceJobName;
        }
        if (!isDeleteWorkspaces && isDeleteStreams) {
            jobName = Messages.DeleteContributorPlaceAction_DeleteStreamJobName;
        }
        runner.enqueue(jobName, (Operation)new RepositoryOperation(){

            private boolean saveBaselineSets(final IWorkspaceConnection connection, SubMonitor progress) throws TeamRepositoryException {
                List baselineSets = connection.getBaselineSets((IProgressMonitor)progress.newChild(1));
                if (baselineSets.size() > 0) {
                    if (!JFaceUtils.showMessageBlocking((String)Messages.DeleteContributorPlaceAction_SNAPSHOT_DIALOG_TITLE, (String)NLS.bind((String)Messages.DeleteContributorPlaceAction_SNAPSHOT_DIALOG_MESSAGE, (Object)connection.getName()), (String[])new String[]{IDialogConstants.OK_LABEL}, (int)4)) {
                        return false;
                    }
                    final AbstractPlaceWrapper[] pw = new AbstractPlaceWrapper[1];
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            pw[0] = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(shell, connection.teamRepository(), Collections.singletonList(connection.getResolvedWorkspace()));
                        }
                    });
                    if (pw[0] != null) {
                        IWorkspaceConnection targetConnection = pw[0].getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                        SubMonitor loopProgress = progress.newChild(1).setWorkRemaining(baselineSets.size());
                        for (IBaselineSetHandle bsh : baselineSets) {
                            targetConnection.addBaselineSet(bsh, (IProgressMonitor)loopProgress);
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                IWorkspaceConnection connection;
                IWorkspaceConnection snapshotPeerConnection;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(handles.size() * 3 + 1));
                IWorkspaceConnection iWorkspaceConnection = snapshotPeerConnection = snapshotPeer2 != null ? snapshotPeer2.getWorkspaceConnection((IProgressMonitor)progress.newChild(1)) : null;
                if (isDeleteStreams) {
                    for (TeamPlaceWrapper streamWrapper : streamWrappers) {
                        connection = streamWrapper.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                        if (!this.saveBaselineSets(connection, progress)) {
                            return;
                        }
                        DeleteContributorPlaceAction.doDelete(true, connection, snapshotPeerConnection, (IProgressMonitor)progress.newChild(1));
                    }
                }
                if (isDeleteWorkspaces) {
                    for (ContributorPlaceWrapper workspaceWrapper : workspaceWrappers) {
                        connection = workspaceWrapper.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                        if (!this.saveBaselineSets(connection, progress)) {
                            return;
                        }
                        DeleteContributorPlaceAction.doDelete(isDeleteContentFinal, connection, null, (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
        });
    }

    private static void doDelete(boolean isDeleteContent, IWorkspaceConnection wc, IWorkspaceConnection peer, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(Messages.DeleteContributorPlaceAction_DeletingProgressName) + wc.getName()), (int)100);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository());
        List components = wc.getComponents();
        if (components.size() > 0) {
            IUnshareOperation op = IOperationFactory.instance.getUnshareOperation(UnloadAction.getUnshareDilemmaHandler(), IRepositoryResolver.EXISTING_SHARED);
            op.requestUnshare((IConnection)wc, (Collection)components);
            op.setDeleteContent(isDeleteContent);
            op.run((IProgressMonitor)progress.newChild(35));
        } else {
            progress.worked(35);
            FileSystemResourcesPlugin.getActiveWorkspaceManager().deactivate((IWorkspaceHandle)wc.getResolvedWorkspace());
        }
        if (peer != null && peer.sameRepository((IConnection)wc)) {
            wm.safelyDeleteStream((IWorkspaceHandle)wc.getResolvedWorkspace(), peer, (IProgressMonitor)progress.newChild(65));
        } else {
            wm.deleteWorkspace((IWorkspaceHandle)wc.getResolvedWorkspace(), (IProgressMonitor)progress.newChild(65));
        }
    }

    @Override
    protected String getOperationName() {
        return Messages.DeleteContributorPlaceAction_DeleteWorkspaceStreamOperationName;
    }

    public static boolean cancelUnloadForOutgoingChanges(Shell shell, List<? extends IWorkspaceHandle> workspaces) {
        if (DeleteContributorPlaceAction.hasOutgoingChanges(workspaces)) {
            String message = workspaces.size() == 1 ? Messages.DeleteContributorPlaceAction_WorkspaceOutgoingChangesetsDialogMessage : Messages.DeleteContributorPlaceAction_WorkspacesOutgoingChangesetsDialogMessage;
            return !DialogUtil.openConfirm(shell, Messages.DeleteContributorPlaceAction_ConfirmUnloadDialogTitle, message, false);
        }
        return false;
    }

    public static boolean hasOutgoingChanges(List<? extends IWorkspaceHandle> workspaces) {
        for (IWorkspaceHandle iWorkspaceHandle : workspaces) {
            IComponentSyncContext[] contexts = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts();
            int i = 0;
            while (i < contexts.length) {
                IComponentSyncContext context = contexts[i];
                if (context.getComponentSyncInfo().getLocalWorkspaceConnection().getResolvedWorkspace().sameItemId((IItemHandle)iWorkspaceHandle) && !context.getOutgoingActivitySource().getActivities().isEmpty()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

