/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class CommonAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.isEnabled());
    }

    protected boolean isEnabled() {
        return true;
    }

    protected Map<String, Map<WorkspaceDescriptor, List<Object>>> getWorkspacesFromSelection(IStructuredSelection selection) {
        HashMap<String, Map<WorkspaceDescriptor, List<Object>>> workspaces = new HashMap<String, Map<WorkspaceDescriptor, List<Object>>>();
        HashMap<UUID, String> uriMap = new HashMap<UUID, String>();
        HashMap<String, String> uriTranslationMap = new HashMap<String, String>();
        if (selection instanceof IStructuredSelection) {
            for (Object element : selection) {
                String uri;
                WorkspaceDescriptor workspace = CommonAction.extractWorkspace(element);
                if (workspace == null) continue;
                if (workspace.getId() != null) {
                    Map descriptors;
                    uri = (String)uriMap.get(workspace.getId());
                    if (uri == null) {
                        uri = workspace.getURI();
                        uriMap.put(workspace.getId(), uri);
                    } else if (!uri.equals(workspace.getURI()) && (descriptors = (Map)workspaces.remove(workspace.getURI())) != null) {
                        for (Map.Entry e : descriptors.entrySet()) {
                            for (Object o : (List)e.getValue()) {
                                this.addToList(workspaces, uri, (WorkspaceDescriptor)e.getKey(), o);
                            }
                        }
                    }
                    uriTranslationMap.put(workspace.getURI(), uri);
                } else {
                    uri = (String)uriTranslationMap.get(workspace.getURI());
                    if (uri == null) {
                        uri = workspace.getURI();
                    }
                }
                this.addToList(workspaces, uri, workspace, element);
            }
        }
        return workspaces;
    }

    protected static List<IWorkspaceHandle> getWorkspaceListFromSelection(IStructuredSelection selection) {
        ArrayList<IWorkspaceHandle> workspaces = new ArrayList<IWorkspaceHandle>();
        if (selection instanceof IStructuredSelection) {
            for (Object element : selection) {
                WorkspaceDescriptor workspace = CommonAction.extractWorkspace(element);
                if (workspace == null) continue;
                workspaces.add(workspace.getWorkspaceHandle());
            }
        }
        return workspaces;
    }

    protected static WorkspaceDescriptor extractWorkspace(Object element) {
        if (element instanceof IShareable) {
            IShareable shareable = (IShareable)element;
            try {
                ITeamRepository teamRepository;
                ISharingDescriptor descriptor;
                IShare share = shareable.getShare((IProgressMonitor)TempHelper.MONITOR);
                if (share != null && (descriptor = share.getSharingDescriptor()).associatedWithWorkspace() && (teamRepository = RepositoryUtils.getTeamRepositoryById((UUID)descriptor.getRepositoryId())) != null) {
                    return new WorkspaceDescriptor(teamRepository.getRepositoryURI(), descriptor.getRepositoryId(), (IWorkspaceHandle)descriptor.getConnectionHandle());
                }
            }
            catch (FileSystemException e) {
                TempHelper.throwEx((TeamRepositoryException)((Object)e));
            }
        } else {
            if (element != null && Adapters.hasAdapter((Object)element, AbstractPlaceWrapper.class)) {
                AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)Adapters.getAdapter((Object)element, AbstractPlaceWrapper.class));
                return new WorkspaceDescriptor(wrapper.getRepository().getRepositoryURI(), wrapper.getRepository().getId(), (IWorkspaceHandle)wrapper.getWorkspace());
            }
            if (element instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)element;
                return new WorkspaceDescriptor(wrapper.getRepository().getRepositoryURI(), wrapper.getRepository().getId(), (IWorkspaceHandle)wrapper.getWorkspace());
            }
            if (element instanceof LoadedConfigurationDescriptor) {
                LoadedConfigurationDescriptor lcd = (LoadedConfigurationDescriptor)element;
                ITeamRepository teamRepository = RepositoryUtils.getTeamRepositoryById((UUID)lcd.getRepositoryId());
                if (teamRepository != null) {
                    return new WorkspaceDescriptor(teamRepository.getRepositoryURI(), lcd.id, (IWorkspaceHandle)lcd.connectionHandle);
                }
            } else {
                IResource resource;
                IShareable shareable = null;
                if (element instanceof IAdaptable) {
                    shareable = (IShareable)((IAdaptable)element).getAdapter(IShareable.class);
                }
                if (shareable == null && (resource = (IResource)Adapters.getAdapter((Object)element, IResource.class)) != null) {
                    shareable = (IShareable)resource.getAdapter(IShareable.class);
                }
                if (shareable != null) {
                    return CommonAction.extractWorkspace(shareable);
                }
            }
        }
        return null;
    }

    private void addToList(Map<String, Map<WorkspaceDescriptor, List<Object>>> target, String uri, WorkspaceDescriptor workspace, Object selectedObject) {
        List<Object> selectedPerWorkspace;
        Map<WorkspaceDescriptor, List<Object>> workspacesPerRepository = target.get(uri);
        if (workspacesPerRepository == null) {
            workspacesPerRepository = new HashMap<WorkspaceDescriptor, List<Object>>();
            target.put(uri, workspacesPerRepository);
            selectedPerWorkspace = new ArrayList<Object>();
            workspacesPerRepository.put(workspace, selectedPerWorkspace);
        } else {
            selectedPerWorkspace = workspacesPerRepository.get(workspace);
            if (selectedPerWorkspace == null) {
                selectedPerWorkspace = new ArrayList<Object>();
                workspacesPerRepository.put(workspace, selectedPerWorkspace);
            }
        }
        selectedPerWorkspace.add(selectedObject);
    }

    protected void runOnSelection(IStructuredSelection selection, final ITeamPlaceRunnable runnable) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        final Map<String, Map<WorkspaceDescriptor, List<Object>>> workspaces = this.getWorkspacesFromSelection(selection);
        if (workspaces.isEmpty()) {
            return;
        }
        this.getOperationRunner().enqueue(this.getOperationName(), new Operation(){

            public void run(IProgressMonitor mon, IStatusCollector errors) throws OperationFailedException {
                int size = 0;
                HashMap<String, ITeamRepository> repositoryMap = new HashMap<String, ITeamRepository>();
                for (Map.Entry entry : workspaces.entrySet()) {
                    String repositoryUri = (String)entry.getKey();
                    Map workspacesForRepo = (Map)entry.getValue();
                    size += workspacesForRepo.size();
                    ITeamRepository repo = null;
                    for (WorkspaceDescriptor desc : workspacesForRepo.keySet()) {
                        ITeamRepository newRepo;
                        if (desc.getId() != null && (newRepo = RepositoryUtils.getTeamRepositoryById((UUID)desc.getId())) != null && (repo = newRepo).loggedIn()) break;
                    }
                    if (repo == null) continue;
                    repositoryMap.put(repositoryUri, repo);
                }
                SubMonitor loop = SubMonitor.convert((IProgressMonitor)mon, (int)(size * 10));
                try {
                    try {
                        for (String repositoryUri : workspaces.keySet()) {
                            ITeamRepository repoHandle = (ITeamRepository)repositoryMap.get(repositoryUri);
                            if (repoHandle == null) {
                                repoHandle = RepositoryUtils.getTeamRepository((String)repositoryUri);
                            }
                            Map workspacesForRepo = (Map)workspaces.get(repositoryUri);
                            for (Map.Entry current : workspacesForRepo.entrySet()) {
                                IWorkspaceHandle workspace = ((WorkspaceDescriptor)current.getKey()).getWorkspaceHandle();
                                Object[] selectedForWorkspace = ((List)current.getValue()).toArray();
                                IWorkspaceConnection teamPlace = SCMPlatform.getWorkspaceManager((ITeamRepository)repoHandle).getWorkspaceConnection(workspace, (IProgressMonitor)loop.newChild(1));
                                IStatus result = runnable.run(teamPlace, selectedForWorkspace, (IProgressMonitor)loop.newChild(9));
                                if (result.isOK()) continue;
                                throw new OperationFailedException(result);
                            }
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                }
                finally {
                    mon.done();
                }
            }
        });
    }

    protected void runOnSelection(IStructuredSelection selection, final TeamPlaceRunnable runnable) {
        final Map<String, Map<WorkspaceDescriptor, List<Object>>> workspaces = this.getWorkspacesFromSelection(selection);
        if (workspaces.isEmpty()) {
            return;
        }
        int numDescriptors = 0;
        final HashMap<String, ITeamRepository> repositoryMap = new HashMap<String, ITeamRepository>();
        for (Map.Entry<String, Map<WorkspaceDescriptor, List<Object>>> entry : workspaces.entrySet()) {
            String repositoryUri = entry.getKey();
            Map<WorkspaceDescriptor, List<Object>> workspacesForRepo = entry.getValue();
            for (WorkspaceDescriptor desc : workspacesForRepo.keySet()) {
                ITeamRepository repo = RepositoryUtils.getTeamRepository((String)desc.getURI(), (int)4, (UUID)desc.getId());
                if (repo == null) {
                    repo = RepositoryUtils.getTeamRepository((String)repositoryUri);
                }
                repositoryMap.put(repositoryUri, repo);
                ++numDescriptors;
            }
        }
        final int size = numDescriptors;
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(repositoryMap.values()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 11));
                HashMap<ITeamRepository, Map<IWorkspaceConnection, Object[]>> selection = new HashMap<ITeamRepository, Map<IWorkspaceConnection, Object[]>>();
                for (Map.Entry descriptors : workspaces.entrySet()) {
                    ITeamRepository repo = (ITeamRepository)repositoryMap.get(descriptors.getKey());
                    for (Map.Entry entry : ((Map)descriptors.getValue()).entrySet()) {
                        IWorkspaceHandle workspaceHandle = ((WorkspaceDescriptor)entry.getKey()).getWorkspaceHandle();
                        Object[] array = ((List)entry.getValue()).toArray();
                        IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspaceHandle, (IProgressMonitor)sub.newChild(1));
                        HashMap<IWorkspaceConnection, Object[]> selectionForWorkspace = (HashMap<IWorkspaceConnection, Object[]>)selection.get(repo);
                        if (selectionForWorkspace == null) {
                            selectionForWorkspace = new HashMap<IWorkspaceConnection, Object[]>();
                            selection.put(repo, selectionForWorkspace);
                        }
                        selectionForWorkspace.put(workspaceConnection, array);
                    }
                }
                IStatus status = runnable.run(selection, (IProgressMonitor)sub.newChild(size * 10));
                if (!status.isOK()) {
                    throw new OperationFailedException(status);
                }
            }
        });
    }

    protected String getOperationName() {
        return "";
    }

    protected Map<IComponentHandle, IShareable[]> partitionByComponent(IShareable[] shareables, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<IShareable> sl;
        IComponentHandle cmp;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)shareables.length);
        HashMap<UUID, IComponentHandle> handleMap = new HashMap<UUID, IComponentHandle>();
        HashMap<UUID, ArrayList<IShareable>> shareableMap = new HashMap<UUID, ArrayList<IShareable>>();
        IShareable[] iShareableArray = shareables;
        int n = shareables.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable s = iShareableArray[n2];
            cmp = this.getComponent(s, (IProgressMonitor)progress.newChild(1));
            if (cmp != null) {
                sl = (ArrayList<IShareable>)shareableMap.get(cmp.getItemId());
                if (sl == null) {
                    handleMap.put(cmp.getItemId(), cmp);
                    sl = new ArrayList<IShareable>();
                    shareableMap.put(cmp.getItemId(), sl);
                }
                sl.add(s);
            }
            ++n2;
        }
        HashMap<IComponentHandle, IShareable[]> result = new HashMap<IComponentHandle, IShareable[]>();
        for (Map.Entry e : handleMap.entrySet()) {
            UUID id = (UUID)e.getKey();
            cmp = (IComponentHandle)e.getValue();
            sl = (List)shareableMap.get(id);
            result.put(cmp, sl.toArray(new IShareable[sl.size()]));
        }
        return result;
    }

    private IComponentHandle getComponent(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        ISharingDescriptor sharingDescriptor;
        IShare share = shareable.getShare(monitor);
        if (share != null && (sharingDescriptor = share.getSharingDescriptor()) != null) {
            return sharingDescriptor.getComponent();
        }
        return null;
    }

    protected IShareable[] extractShareables(Object[] selection) {
        ArrayList<IShareable> list = new ArrayList<IShareable>(selection.length);
        int i = 0;
        while (i < selection.length) {
            IShareable shareable = (IShareable)Adapters.getAdapter((Object)selection[i], IShareable.class);
            if (shareable == null) {
                IResource resource = (IResource)Adapters.getAdapter((Object)selection[i], IResource.class);
                shareable = (IShareable)Adapters.getAdapter((Object)resource, IShareable.class);
            }
            if (shareable != null) {
                list.add(shareable);
            }
            ++i;
        }
        return list.toArray(new IShareable[list.size()]);
    }

    protected static interface ITeamPlaceRunnable {
        public IStatus run(IWorkspaceConnection var1, Object[] var2, IProgressMonitor var3);
    }

    protected static abstract class TeamPlaceRunnable {
        protected TeamPlaceRunnable() {
        }

        public IStatus run(Map<ITeamRepository, Map<IWorkspaceConnection, Object[]>> selection, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)selection.size());
            for (Map.Entry<ITeamRepository, Map<IWorkspaceConnection, Object[]>> entry : selection.entrySet()) {
                Map<IWorkspaceConnection, Object[]> selectionByConnectionMap;
                ITeamRepository repo = entry.getKey();
                IStatus status = this.run(repo, selectionByConnectionMap = entry.getValue(), (IProgressMonitor)sub.newChild(1));
                if (status.isOK()) continue;
                return status;
            }
            return Status.OK_STATUS;
        }

        private IStatus run(ITeamRepository repo, Map<IWorkspaceConnection, Object[]> selection, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)selection.size());
            for (Map.Entry<IWorkspaceConnection, Object[]> entry : selection.entrySet()) {
                Object[] selectionByConnection;
                IWorkspaceConnection workspaceConnection = entry.getKey();
                IStatus status = this.run(workspaceConnection, selectionByConnection = entry.getValue(), (IProgressMonitor)sub.newChild(1));
                if (status.isOK()) continue;
                return status;
            }
            return Status.OK_STATUS;
        }

        public abstract IStatus run(IWorkspaceConnection var1, Object[] var2, IProgressMonitor var3) throws TeamRepositoryException, FileSystemException;
    }

    protected static class WorkspaceDescriptor {
        private String uri;
        private UUID repoId;
        private IWorkspaceHandle workspaceHandle;

        public WorkspaceDescriptor(String uri, UUID repoId, IWorkspaceHandle workspaceHandle) {
            this.uri = uri;
            this.repoId = repoId;
            this.workspaceHandle = workspaceHandle;
        }

        public String getURI() {
            return this.uri;
        }

        public UUID getId() {
            return this.repoId;
        }

        IWorkspaceHandle getWorkspaceHandle() {
            return this.workspaceHandle;
        }

        public int hashCode() {
            return this.workspaceHandle.getItemId().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WorkspaceDescriptor)) {
                return false;
            }
            return this.workspaceHandle.sameItemId((IItemHandle)((WorkspaceDescriptor)obj).workspaceHandle);
        }
    }
}

