/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class CommitAction
extends CommonAction {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.runOnSelection(selection, new CommonAction.ITeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection teamPlace, Object[] selection, IProgressMonitor monitor) {
                Map<IComponentHandle, IShareable[]> shareablesByComponent;
                IShareable[] shareables = CommitAction.this.extractShareables(selection);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
                SubMonitor ignoreLoopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)10).setWorkRemaining(shareables.length);
                int numIgnored = 0;
                IShareable[] iShareableArray = shareables;
                int n = shareables.length;
                int n2 = 0;
                while (n2 < n) {
                    IShareable shareable = iShareableArray[n2];
                    try {
                        if (shareable.shouldBeIgnored((IProgressMonitor)ignoreLoopProgress.newChild(1))) {
                            ++numIgnored;
                        }
                    }
                    catch (FileSystemException e) {
                        ignoreLoopProgress.worked(1);
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                    if (numIgnored > 1) {
                        ignoreLoopProgress.setWorkRemaining(0);
                        break;
                    }
                    ++n2;
                }
                if (numIgnored == 1 && shareables.length == 1) {
                    JFaceUtils.showMessage((String)Messages.CommitAction_RESOURCE_IGNORED_DIALOG_TITLE, (String)Messages.CommitAction_RESOURCE_IGNORED_DIALOG_MESSAGE, (int)2);
                    return Status.OK_STATUS;
                }
                if (numIgnored > 1 && shareables.length == numIgnored) {
                    JFaceUtils.showMessage((String)Messages.CommitAction_RESOURCES_IGNORED_DIALOG_TITLE, (String)Messages.CommitAction_ALL_RESOURCE_IGNORED_DIALOG_MESSAGE, (int)2);
                    return Status.OK_STATUS;
                }
                if (numIgnored > 0 && shareables.length != numIgnored) {
                    int returnCode = JFaceUtils.showMessageButtonsBlocking((String)Messages.CommitAction_RESOURCES_IGNORED_DIALOG_TITLE, (String)Messages.CommitAction_RESOURCES_IGNORED_DIALOG_MESSAGE, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (int)4, (int)0, null);
                    switch (returnCode) {
                        case -1: {
                            return Status.OK_STATUS;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            return Status.OK_STATUS;
                        }
                    }
                }
                try {
                    shareablesByComponent = CommitAction.this.partitionByComponent(shareables, (IProgressMonitor)progress.newChild(5));
                }
                catch (FileSystemException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                WarnCommitUser problemHandler = new WarnCommitUser(shell, CommitAction.this.getOperationName());
                progress.setWorkRemaining(shareablesByComponent.size());
                Iterator<Map.Entry<IComponentHandle, IShareable[]>> iShareablesByComponent = shareablesByComponent.entrySet().iterator();
                while (iShareablesByComponent.hasNext()) {
                    SubMonitor iterProgress = progress.newChild(1).setWorkRemaining(100);
                    Map.Entry<IComponentHandle, IShareable[]> entry = iShareablesByComponent.next();
                    final IComponentHandle component = entry.getKey();
                    IComponentSyncContext context = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContext((IConnection)teamPlace, component);
                    if (context == null) continue;
                    try {
                        IShareable[] toCommit = entry.getValue();
                        final ArrayList collected = new ArrayList();
                        if (toCommit != null) {
                            SubMonitor subProgress = iterProgress.newChild(5).setWorkRemaining(toCommit.length);
                            int i = 0;
                            while (i < toCommit.length) {
                                ((Shareable)toCommit[i]).accept(new IShareableVisitor(){

                                    public boolean visit(IShareable shareable, IProgressMonitor monitor) {
                                        try {
                                            ILocalChange shareableChange = shareable.getChange(monitor);
                                            if (shareableChange != null && shareableChange.getType() != 0) {
                                                collected.add(shareableChange);
                                            }
                                        }
                                        catch (FileSystemException fileSystemException) {
                                            // empty catch block
                                        }
                                        return true;
                                    }

                                    public IComponentHandle getComponent() {
                                        return component;
                                    }
                                }, Integer.MAX_VALUE, true, false, (IProgressMonitor)subProgress.newChild(1));
                                ++i;
                            }
                        }
                        iterProgress.setWorkRemaining(100);
                        if (collected.size() == 0) {
                            if (toCommit.length > 1) {
                                JFaceUtils.showMessage((String)Messages.CommitAction_RESOURCES_UNCHANGED_DIALOG_TITLE, (String)Messages.CommitAction_RESOURCES_UNCHANGED_DIALOG_MESSAGE, (int)1);
                            } else {
                                JFaceUtils.showMessage((String)Messages.CommitAction_RESOURCES_UNCHANGED_DIALOG_TITLE, (String)Messages.CommitAction_RESOURCE_UNCHANGED_DIALOG_MESSAGE, (int)1);
                            }
                            return Status.OK_STATUS;
                        }
                        context.autoCommitLocalChanges(collected, false, (CommitDilemmaHandler)problemHandler, (IProgressMonitor)iterProgress.newChild(95));
                    }
                    catch (TeamRepositoryException e) {
                        return StatusUtil.newStatus((Object)this, (Throwable)e);
                    }
                }
                LocalWorkspaceChangesView.requestShowPendingView();
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    protected String getOperationName() {
        return Messages.CommitAction_CheckinInJobName;
    }

    protected Object adaptEditorInput(IEditorInput input) {
        return Adapters.getAdapter((Object)input, IResource.class);
    }
}

