/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.SnapshotListView;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ChangeSnapshotOwnerAction
extends AbstractActionDelegate {
    public static final String ACTION_ID = "com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper.actions.ChangeSnapshotOwnerAction";

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        HashMap<ITeamRepository, HashMap<UUID, IBaselineSet>> snapshotsInRepo = new HashMap<ITeamRepository, HashMap<UUID, IBaselineSet>>(selection.size());
        for (Object e : selection.toList()) {
            IBaselineSet snapshot = (IBaselineSet)Adapters.getAdapter(e, IBaselineSet.class);
            if (snapshot == null) continue;
            ITeamRepository repo = (ITeamRepository)snapshot.getOrigin();
            if (repo == null) {
                throw new IllegalArgumentException("The selected snapshot does not have the origin (repository) set.");
            }
            HashMap<UUID, IBaselineSet> snapshots = (HashMap<UUID, IBaselineSet>)snapshotsInRepo.get(repo);
            if (snapshots == null) {
                snapshots = new HashMap<UUID, IBaselineSet>();
                snapshotsInRepo.put(repo, snapshots);
            }
            snapshots.put(snapshot.getItemId(), snapshot);
        }
        for (Map.Entry entry : snapshotsInRepo.entrySet()) {
            ITeamRepository repo = (ITeamRepository)entry.getKey();
            final Collection snapshots = ((Map)entry.getValue()).values();
            final AbstractPlaceWrapper newOwner = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(page.getWorkbenchWindow().getShell(), repo);
            if (newOwner == null) continue;
            String opName = NLS.bind((String)Messages.ChangeSnapshotOwnerAction_SetSnapshotOwnerJobName, (Object)newOwner.getWorkspace().getName());
            this.getOperationRunner().enqueue(opName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(snapshots.size() + 10));
                    IWorkspaceConnection newOwnerConnection = newOwner.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
                    for (IBaselineSet snapshot : snapshots) {
                        newOwnerConnection.addBaselineSet((IBaselineSetHandle)snapshot, (IProgressMonitor)progress.newChild(1));
                    }
                    SnapshotListView.openSearch(ChangeSnapshotOwnerAction.this.getContext().getDisplay(), newOwner);
                }
            });
        }
    }
}

