/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.ui.changes.dialogs.ChangesDialog;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class AcceptAction
extends AbstractActionDelegate {
    private List selectedResources;
    private Collection incomingActivities;
    private Collection associatedIncomingActivities;
    private Collection conflictedIncomingActivities;

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final Display display = shell.getDisplay();
        this.getOperationRunner().enqueue(Messages.AcceptAction_AcceptingChangeSetsJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IStructuredSelection ss = AcceptAction.this.getStructuredSelection();
                AcceptAction.this.selectedResources = ss.toList();
                Collection[] results = ComponentSyncUtil.getRemoteActivities((Collection)AcceptAction.this.selectedResources, (boolean)true, (IProgressMonitor)progress);
                AcceptAction.this.incomingActivities = results[0];
                AcceptAction.this.associatedIncomingActivities = results[1];
                AcceptAction.this.conflictedIncomingActivities = results[2];
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        List<IRemoteActivity> activitiesToAccept;
                        if (AcceptAction.this.incomingActivities.isEmpty()) {
                            MessageDialog.openInformation((Shell)shell, (String)Messages.AcceptAction_CannotAcceptTitle, (String)Messages.AcceptAction_NoIncomingChangeSets);
                            return;
                        }
                        ChangesDialog dialog = new ChangesDialog(AcceptAction.this.getPart(), AcceptAction.this.incomingActivities, AcceptAction.this.associatedIncomingActivities, AcceptAction.this.conflictedIncomingActivities, AcceptAction.this.selectedResources, true);
                        if (dialog.open() == 0 && (activitiesToAccept = dialog.getSelectedActivities()).size() > 0) {
                            final String name = Messages.AcceptAction_AcceptingChangeSetsJobName;
                            AcceptAction.this.getOperationRunner().enqueue(name, (Operation)new RepositoryOperation(){

                                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                    WarnWorkspaceUpdate warnWorkspaceUpdate = new WarnWorkspaceUpdate(AcceptAction.this.getContext(), name);
                                    WorkspaceUpdateUtil.accept((Collection)activitiesToAccept, (WorkspaceUpdateDilemmaHandler)warnWorkspaceUpdate, (boolean)false, (boolean)false, (IProgressMonitor)monitor);
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(true);
    }

    protected Object adaptEditorInput(IEditorInput input) {
        return Adapters.getAdapter((Object)input, IResource.class);
    }
}

