/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.teamplace;

import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractCopyItemWebURLAction
extends AbstractActionDelegate {
    public abstract void run(Shell var1, IWorkbenchPage var2, IStructuredSelection var3);

    public static void copyToClipboard(UIContext context, List<AbstractWrapper> selections) {
        if (selections.isEmpty()) {
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (AbstractWrapper selection : selections) {
            if (sb.length() > 0) {
                sb.append(lineSeparator);
            }
            String webURL = AbstractCopyItemWebURLAction.getWebURL(selection);
            sb.append(webURL);
        }
        if (sb.length() > 0) {
            Clipboard cb = new Clipboard(context.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
            cb.dispose();
        }
    }

    private static String getWebURL(AbstractWrapper selection) {
        String repoURI = Repositories.getPublicURI(selection.getRepository());
        Location selectionLoc = Location.itemLocation((IItemHandle)selection.getItem(), (String)repoURI);
        return selectionLoc.toString();
    }
}

