/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.query;

import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.IReadScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RenameQueryItemAction
extends AbstractActionDelegate {
    public static final String ACTION_ID = "com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper.actions.RenameQueryItemAction";

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<QueryItemWrapper> queryItems = AdapterUtil.adaptList(selection.toList(), QueryItemWrapper.class);
        if (queryItems.isEmpty()) {
            return;
        }
        String dialogTitle = Messages.RenameQueryItemAction_RenameQueryItemDialogTitle;
        String dialogMessage = Messages.RenameQueryItemAction_RenameQueryItemDialogMessage;
        final QueryItemWrapper wrapper = queryItems.get(0);
        String originalName = wrapper.getQueryItem().getName();
        InputDialog dialog = new InputDialog(shell, dialogTitle, dialogMessage, originalName, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.equals("")) {
                    return "";
                }
                if (!newText.trim().equals(newText)) {
                    return Messages.RenameQueryItemAction_WhiteSpaceErrorMessage;
                }
                return null;
            }
        });
        if (dialog.open() != 0 || dialog.getValue() == null) {
            return;
        }
        final String newName = dialog.getValue();
        if (!newName.equals(originalName)) {
            this.getOperationRunner().enqueue(Messages.RenameQueryItemAction_RenameQueryItemJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ITeamRepository repo = wrapper.getRepository();
                    IQueryItem query = wrapper.getQueryItem();
                    String name = newName;
                    String description = query.getDescription();
                    IAuditableHandle owner = query.getOwner();
                    IReadScope readScope = query.getReadScope();
                    IItemSearchCriteria searchCriteria = query.getSearchCriteria();
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    IQueryItem savedQuery = wm.updateQueryItem(query, name, description, owner, readScope, searchCriteria, (IProgressMonitor)progress.newChild(80));
                    repo.itemManager().refreshSharedItems(Collections.unmodifiableList(Arrays.asList(savedQuery)), (IProgressMonitor)progress.newChild(20));
                }
            });
        }
    }
}

