/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.query;

import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryEditor;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IQueryItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class EditQueryItemAction
extends AbstractActionDelegate {
    public static final String ACTION_ID = "com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper.actions.EditQueryItemAction";

    public void run(Shell shell, final IWorkbenchPage page, IStructuredSelection ss) {
        final HashMap<UUID, QueryItemWrapper> allWrappers = new HashMap<UUID, QueryItemWrapper>();
        final HashMap<ITeamRepository, HashMap<UUID, IQueryItem>> allHandlesToFetch = new HashMap<ITeamRepository, HashMap<UUID, IQueryItem>>();
        for (Object selection : ss.toList()) {
            if (!(selection instanceof QueryItemWrapper)) continue;
            QueryItemWrapper wrapper = (QueryItemWrapper)((Object)selection);
            ITeamRepository repo = wrapper.getRepository();
            allWrappers.put(wrapper.getQueryItem().getItemId(), wrapper);
            HashMap<UUID, IQueryItem> handlesInRepo = (HashMap<UUID, IQueryItem>)allHandlesToFetch.get(repo);
            if (handlesInRepo == null) {
                handlesInRepo = new HashMap<UUID, IQueryItem>();
                allHandlesToFetch.put(repo, handlesInRepo);
            }
            handlesInRepo.put(wrapper.getQueryItem().getItemId(), wrapper.getQueryItem());
        }
        final Display display = shell.getDisplay();
        this.getOperationRunner().enqueue(Messages.ScmQueryItemPickerDialog_FetchQueryItemsJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)allHandlesToFetch.size());
                for (Map.Entry repoMap : allHandlesToFetch.entrySet()) {
                    ITeamRepository repo = (ITeamRepository)repoMap.getKey();
                    repo.itemManager().fetchCompleteItemsPermissionAware(new ArrayList(((Map)repoMap.getValue()).values()), 1, (IProgressMonitor)progress.newChild(1));
                }
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (Map.Entry entry : allWrappers.entrySet()) {
                                ScmQueryEditor.openEditor(page, (QueryItemWrapper)((Object)entry.getValue()));
                            }
                        }
                    });
                }
            }
        });
    }
}

