/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.query;

import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryWorkingCopy;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IQueryItemHandle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteQueryItemAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        final HashMap<ITeamRepository, HashMap<UUID, IQueryItemHandle>> queryHandles = new HashMap<ITeamRepository, HashMap<UUID, IQueryItemHandle>>();
        String queryName = null;
        for (Object object : ss) {
            Object wrapper = null;
            if (object instanceof QueryItemWrapper) {
                wrapper = (QueryItemWrapper)((Object)object);
            } else if (object instanceof ScmQueryWorkingCopy) {
                ScmQueryWorkingCopy workingCopy = (ScmQueryWorkingCopy)((Object)object);
                wrapper = workingCopy.getQueryItemWrapper();
            }
            if (wrapper == null) continue;
            queryName = ((QueryItemWrapper)((Object)wrapper)).getQueryItem().getName();
            ITeamRepository repo = ((QueryItemWrapper)((Object)wrapper)).getRepository();
            IQueryItem query = ((QueryItemWrapper)((Object)wrapper)).getQueryItem();
            HashMap<UUID, IQueryItemHandle> uuidToQueryMap = (HashMap<UUID, IQueryItemHandle>)queryHandles.get(repo);
            if (uuidToQueryMap == null) {
                uuidToQueryMap = new HashMap<UUID, IQueryItemHandle>();
            }
            uuidToQueryMap.put(query.getItemId(), (IQueryItemHandle)query.getItemHandle());
            queryHandles.put(repo, uuidToQueryMap);
        }
        if (queryHandles.size() == 0) {
            return;
        }
        int queryCount = 0;
        for (Map queriesInRepo : queryHandles.values()) {
            queryCount += queriesInRepo.size();
        }
        String title = Messages.DeleteQueryItemAction_DELETE_DIALOG_TITLE;
        String message = queryCount == 1 ? (queryName != null ? NLS.bind((String)Messages.DeleteQueryItemAction_DELETE_DIALOG_MESSAGE_SINGLE_WITH_NAME, (Object)queryName) : Messages.DeleteQueryItemAction_DELETE_DIALOG_MESSAGE_SINGLE) : NLS.bind((String)Messages.DeleteQueryItemAction_DELETE_DIALOG_MESSAGE_MULTI, (Object)queryCount);
        if (!DialogUtil.openQuestionDialog(shell, title, message, false)) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.DeleteQueryItemAction_DELETE_QUERIES_JOB_NAME, new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                for (Map.Entry entry : queryHandles.entrySet()) {
                    ITeamRepository repo = (ITeamRepository)entry.getKey();
                    Map queries = (Map)entry.getValue();
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    try {
                        wm.deleteQueryItems(queries.values(), monitor);
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportException((Throwable)e);
                    }
                }
            }
        });
    }
}

