/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs;

import com.ibm.icu.text.Collator;
import com.ibm.team.filesystem.ui.actions.gcartifacts.GcContextReference;
import com.ibm.team.filesystem.ui.actions.gcartifacts.GlobalConfigControl;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.ILinkTypeInfo;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SelectLinkTypeDialog
extends TitleAreaDialog {
    private final String fTitle;
    private final String fMessage;
    private final String desc;
    private final List<LinkTypeIdentifier> comboEntryData = NewCollection.arrayList();
    private final List<String> comboEntryLabels = NewCollection.arrayList();
    private Combo list;
    private String selectedItemLabel;
    private LinkTypeIdentifier selectedItemId;
    private ITeamRepository repository;
    private GlobalConfigControl gcControl;

    public SelectLinkTypeDialog(IWorkbenchPage page, String title, String message, String description, Map<LinkTypeIdentifier, ILinkTypeInfo> supportedLinkTypes, ITeamRepository repo) {
        this(page.getWorkbenchWindow().getShell(), title, message, description, supportedLinkTypes, repo);
    }

    public SelectLinkTypeDialog(Shell shell, String title, String message, String description, Map<LinkTypeIdentifier, ILinkTypeInfo> supportedLinkTypes, ITeamRepository repo) {
        super(shell);
        this.fTitle = title;
        this.fMessage = message;
        this.desc = description;
        this.repository = repo;
        this.initComboEntries(supportedLinkTypes);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        this.gcControl = new GlobalConfigControl(composite, this.repository, null);
        this.addControl(composite, this.gcControl);
        this.gcControl.addGCChangedListener(2, new Listener(){

            public void handleEvent(Event e) {
                SelectLinkTypeDialog.this.enableDialogControls();
            }
        });
        this.gcControl.getShell().addListener(22, new Listener(){

            public void handleEvent(Event e) {
                SelectLinkTypeDialog.this.enableDialogControls();
            }
        });
        this.createLabelForSelect(composite);
        this.list = new Combo(composite, 16392);
        this.addControl(composite, (Composite)this.list);
        this.addItemsToSelect();
        this.setTitle(this.fTitle);
        this.setMessage(this.desc);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 225).applyTo((Control)composite);
        return dialogArea;
    }

    private void enableDialogControls() {
        GcContextReference ref = this.gcControl.getSelectedGCContext();
        if (ref != null) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected String getDialogTitle() {
        return this.fTitle;
    }

    private Label createLabelForSelect(Composite parent) {
        Label label = new Label(parent, 16448);
        label.setText(this.fMessage);
        GridData data = this.createGridDataForControl();
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        return label;
    }

    private void addControl(Composite parent, Composite control) {
        GridData data = this.createGridDataForControl();
        control.setLayoutData((Object)data);
        control.setFont(parent.getFont());
    }

    private void addItemsToSelect() {
        String[] items = this.comboEntryLabels.toArray(new String[this.comboEntryLabels.size()]);
        this.list.setItems(items);
        this.list.select(0);
    }

    private void initComboEntries(Map<LinkTypeIdentifier, ILinkTypeInfo> supportedLinkTypes) {
        List sortedTypes = NewCollection.arrayList(supportedLinkTypes.entrySet());
        Collections.sort(sortedTypes, new TypeEntryComparator());
        for (Map.Entry entry : sortedTypes) {
            this.comboEntryLabels.add(((ILinkTypeInfo)entry.getValue()).getLabel());
            this.comboEntryData.add((LinkTypeIdentifier)entry.getKey());
        }
    }

    private GridData createGridDataForControl() {
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        return data;
    }

    protected Point getInitialSize() {
        Point pt = super.getInitialSize();
        pt.x = 550;
        pt.y = 450;
        return pt;
    }

    protected boolean isResizable() {
        return true;
    }

    public LinkTypeIdentifier getSelectedItemData() {
        return this.selectedItemId;
    }

    public String getSelectedItemLabel() {
        return this.selectedItemLabel;
    }

    public GcContextReference getSelectedGlobalContext() {
        return this.gcControl.getSelectedGCContext();
    }

    protected void okPressed() {
        int n = this.list.getSelectionIndex();
        this.selectedItemLabel = this.list.getItem(n);
        this.selectedItemId = this.comboEntryData.get(n);
        this.setReturnCode(0);
        this.close();
    }

    private static class TypeEntryComparator
    implements Comparator<Map.Entry<LinkTypeIdentifier, ILinkTypeInfo>> {
        private final Collator currentLocaleCollator = CollatorCache.getInstance();

        private TypeEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<LinkTypeIdentifier, ILinkTypeInfo> o1, Map.Entry<LinkTypeIdentifier, ILinkTypeInfo> o2) {
            int compare = this.currentLocaleCollator.compare(o1.getValue().getLabel(), o2.getValue().getLabel());
            if (compare == 0) {
                compare = o1.getKey().toLinkServiceId().compareTo(o2.getKey().toLinkServiceId());
            }
            return compare;
        }
    }
}

