/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs;

import com.ibm.team.filesystem.ui.actions.gcartifacts.FileLinkTypeUtil;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinkNode;
import com.ibm.team.foundation.common.text.XMLString;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class OpenRemoveDlgContextMenuAction
extends Action {
    public static String FILELINK_ACTION_COPYLINK_ID = "scmgc.filelink.action.id.copylink";
    public static String FILELINK_ACTION_COPYLABEL_ID = "scmgc.filelink.action.id.copylabel";
    private List<FileLinkNode> fileLinkNodes = new ArrayList<FileLinkNode>();
    private final String lineSeparator = "line.separator";

    public boolean isEnabled() {
        return this.enableMenu();
    }

    private boolean enableMenu() {
        return this.fileLinkNodes != null && this.fileLinkNodes.size() >= 1;
    }

    public void run() {
        if (FILELINK_ACTION_COPYLINK_ID.equals(this.getId())) {
            this.copyURLToClipboard(this.fileLinkNodes);
        }
        if (FILELINK_ACTION_COPYLABEL_ID.equals(this.getId())) {
            this.copyCommentToClipboard(this.fileLinkNodes);
        }
    }

    public void copyCommentToClipboard(List<FileLinkNode> selectedNodes) {
        this.copyToClipboard(selectedNodes, true);
    }

    public void copyURLToClipboard(List<FileLinkNode> selectedNodes) {
        this.copyToClipboard(selectedNodes, false);
    }

    private void copyToClipboard(List<FileLinkNode> selectedNodes, boolean copyComment) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer htmlBuffer = new StringBuffer();
        int length = selectedNodes.size();
        int k = 0;
        while (k < length) {
            FileLinkNode o = selectedNodes.get(k);
            String comment = o.getOslcFileLink().toString();
            if (copyComment) {
                comment = o.getLinkLabel();
            }
            String uri = o.getOslcFileLink().toString();
            buffer.append(comment);
            if (k < length - 1) {
                buffer.append(this.getLineSeparator());
            }
            htmlBuffer.append("<a href=\"");
            htmlBuffer.append(uri);
            htmlBuffer.append("\">");
            htmlBuffer.append(XMLString.createFromPlainText((String)comment).getPlainText());
            htmlBuffer.append("</a>");
            if (k < length - 1) {
                htmlBuffer.append("<br/>");
            }
            ++k;
        }
        String textContent = buffer.toString();
        String htmlContent = FileLinkTypeUtil.escapeForHTMLTransfer(htmlBuffer.toString());
        if (textContent.length() > 0 && htmlContent.length() > 0) {
            Display display = Display.getDefault();
            Clipboard cb = new Clipboard(display);
            try {
                cb.setContents(new Object[]{textContent, htmlContent}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
            }
            finally {
                cb.dispose();
            }
        }
    }

    public String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public void setNodes(List<FileLinkNode> nodes) {
        this.fileLinkNodes = nodes;
    }
}

