/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.IScmTreeDialogPart;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ScmTreeDialog;
import com.ibm.team.filesystem.ui.actions.gcartifacts.FileLinkDialogInput;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.ExternalLinksWithStatus;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinkDialogPart;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.internal.RelatedArtifactsUtils;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.RelatedArtifacts;
import com.ibm.team.scm.common.internal.gc.GCUriUtils;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class FileLinksDialog
extends ScmTreeDialog {
    private final String fTitle;
    private final String fMessage;
    private final IShareableLinks orgLinks;
    private final String okButtonLabel;

    public FileLinksDialog(Shell shell, IShareableLinks shareableLinks) {
        super(shell);
        this.fTitle = shareableLinks.getTitle();
        this.fMessage = shareableLinks.getMessage();
        this.orgLinks = shareableLinks;
        this.okButtonLabel = shareableLinks.getOKButtonLabel();
    }

    @Override
    protected IScmTreeDialogPart getCustomPart(Composite parent) {
        return new FileLinkDialogPart(parent, this.orgLinks);
    }

    @Override
    protected String getDialogTitle() {
        return this.fTitle;
    }

    @Override
    protected String getDialogMessage() {
        return this.fMessage;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.okButtonLabel, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point pt = super.getInitialSize();
        pt.x = 650;
        pt.y = 550;
        return pt;
    }

    @Override
    protected void addChangeListener() {
        this.getPart().getValidationStatus().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                IStatus status = (IStatus)FileLinksDialog.this.part.getValidationStatus().getValue();
                boolean ok = status.isOK();
                if (ok) {
                    FileLinksDialog.this.setErrorMessage(null);
                }
                FileLinksDialog.this.getButton(0).setEnabled(ok);
            }
        });
    }

    public static interface IShareableLinks {
        public FileLinkDialogInput getDialogInput();

        public ITeamRepository getRepository();

        public ExternalLinksWithStatus getLinks(String var1, IProgressMonitor var2);

        public String getTitle();

        public String getMessage();

        public String getOKButtonLabel();
    }

    public static class ShareableOutgoingLinks
    extends VersionableOutgoingLinks {
        private final IShareable fShareable;

        public ShareableOutgoingLinks(IShareable inShareable, IProgressMonitor monitor, ITeamRepository repository, FileLinkDialogInput input) throws FileSystemException {
            super(inShareable.getVersionable(monitor), repository, input);
            this.fShareable = inShareable;
        }

        @Override
        public ExternalLinksWithStatus getLinks(String gcContext, IProgressMonitor monitor) {
            RelatedArtifacts links = null;
            ExternalLinksWithStatus.LinkStatus status = ExternalLinksWithStatus.LinkStatus.ok;
            try {
                links = this.fShareable.getRelatedArtifacts(gcContext, monitor);
            }
            catch (FileSystemException e) {
                status = ExternalLinksWithStatus.LinkStatus.outgoing_failed;
                StatusUtil.log((IStatus)StatusUtil.newStatus(FileLinksDialog.class, (int)4, (String)NLS.bind((String)Messages.FileExternalLink_FAILURE_TO_FETCH_OUTGOING, (Object)"", (Object[])new Object[0]), (Throwable)e));
            }
            return new ExternalLinksWithStatus(links.getRelatedArtifacts(), status);
        }
    }

    public static class VersionableAllLinks
    implements IShareableLinks {
        private final VersionableOutgoingLinks versionableOutgoingLinks;

        public VersionableAllLinks(IVersionableHandle inVersionable, ITeamRepository repository, FileLinkDialogInput input) throws FileSystemException {
            this.versionableOutgoingLinks = new VersionableOutgoingLinks(inVersionable, repository, input);
        }

        public VersionableAllLinks(IShareable inShareable, IProgressMonitor monitor, ITeamRepository repository, FileLinkDialogInput input) throws FileSystemException {
            this.versionableOutgoingLinks = new ShareableOutgoingLinks(inShareable, monitor, repository, input);
        }

        @Override
        public ExternalLinksWithStatus getLinks(String gcContext, IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            ExternalLinksWithStatus linksWithStatus = this.versionableOutgoingLinks.getLinks(gcContext, (IProgressMonitor)progress.newChild(1));
            ExternalLinksWithStatus.LinkStatus status = linksWithStatus.getStatus();
            List<OslcFileLink> links = linksWithStatus.getExternalLinks() == null ? new ArrayList<OslcFileLink>() : new ArrayList<OslcFileLink>(linksWithStatus.getExternalLinks());
            try {
                links = this.getIncomingOSLCLinksForVersionable(links, gcContext, (IProgressMonitor)progress.newChild(1));
            }
            catch (TeamRepositoryException e) {
                status = linksWithStatus.getStatus() == ExternalLinksWithStatus.LinkStatus.ok ? ExternalLinksWithStatus.LinkStatus.incoming_failed : ExternalLinksWithStatus.LinkStatus.outgoing_incoming_failed;
                StatusUtil.log((IStatus)StatusUtil.newStatus(FileLinksDialog.class, (int)4, (String)NLS.bind((String)Messages.FileExternalLink_FAILURE_TO_FETCH_INCOMING, (Object)"", (Object[])new Object[0]), (Throwable)e));
            }
            return new ExternalLinksWithStatus(links, status);
        }

        @Override
        public FileLinkDialogInput getDialogInput() {
            return this.versionableOutgoingLinks.getDialogInput();
        }

        @Override
        public ITeamRepository getRepository() {
            return this.versionableOutgoingLinks.getRepository();
        }

        @Override
        public String getTitle() {
            return this.versionableOutgoingLinks.getTitle();
        }

        @Override
        public String getMessage() {
            return this.versionableOutgoingLinks.getMessage();
        }

        @Override
        public String getOKButtonLabel() {
            return this.versionableOutgoingLinks.getOKButtonLabel();
        }

        private List<OslcFileLink> getIncomingOSLCLinksForVersionable(List<OslcFileLink> links, String gcContext, IProgressMonitor monitor) throws TeamRepositoryException {
            IVersionableHandle vH;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            if (links == null) {
                links = NewCollection.arrayList();
            }
            if ((vH = this.versionableOutgoingLinks.getVersionableHandle()) != null && vH.hasStateId() && gcContext != null && !gcContext.isEmpty()) {
                ITeamRepository repo = this.getRepository();
                Collection relatedArtifacts = RelatedArtifactsUtils.getRelatedArtifacts(Collections.singleton(vH), (URI)GCUriUtils.optionalUri((String)gcContext), (String[])IScmService.FETCH_INCOMING_LINKS_ONLY, (ITeamRepository)repo, (IProgressMonitor)progress.newChild(1)).values();
                if (!relatedArtifacts.isEmpty()) {
                    List incomingLinks = ((RelatedArtifacts)relatedArtifacts.iterator().next()).getRelatedArtifacts();
                    links.addAll(incomingLinks);
                }
            }
            return links;
        }
    }

    public static class VersionableOutgoingLinks
    implements IShareableLinks {
        private final FileLinkDialogInput fDlgInput;
        private final ITeamRepository fRepo;
        private final IVersionableHandle fVersionable;

        public VersionableOutgoingLinks(IVersionableHandle inVersionable, ITeamRepository repository, FileLinkDialogInput input) {
            Assert.isNotNull((Object)repository);
            this.fDlgInput = input;
            this.fVersionable = inVersionable;
            this.fRepo = repository;
        }

        public IVersionableHandle getVersionableHandle() {
            return this.fVersionable;
        }

        @Override
        public FileLinkDialogInput getDialogInput() {
            return this.fDlgInput;
        }

        @Override
        public ITeamRepository getRepository() {
            return this.fRepo;
        }

        @Override
        public ExternalLinksWithStatus getLinks(String gcContext, IProgressMonitor monitor) {
            List links = NewCollection.arrayList();
            ExternalLinksWithStatus.LinkStatus status = ExternalLinksWithStatus.LinkStatus.ok;
            try {
                Collection relatedArtifacts = RelatedArtifactsUtils.getRelatedArtifacts(Collections.singleton(this.fVersionable), (URI)GCUriUtils.optionalUri((String)gcContext), (String[])IScmService.FETCH_OUTGOING_LINKS_ONLY, (ITeamRepository)this.fRepo, (IProgressMonitor)monitor).values();
                if (!relatedArtifacts.isEmpty()) {
                    links = ((RelatedArtifacts)relatedArtifacts.iterator().next()).getRelatedArtifacts();
                }
            }
            catch (TeamRepositoryException e) {
                status = ExternalLinksWithStatus.LinkStatus.outgoing_failed;
                StatusUtil.log((IStatus)StatusUtil.newStatus(FileLinksDialog.class, (int)4, (String)NLS.bind((String)Messages.FileExternalLink_FAILURE_TO_FETCH_OUTGOING, (Object)"", (Object[])new Object[0]), (Throwable)e));
            }
            return new ExternalLinksWithStatus(links, status);
        }

        @Override
        public String getMessage() {
            return this.fDlgInput.getMessage();
        }

        @Override
        public String getOKButtonLabel() {
            return this.fDlgInput.getOKButtonLabel();
        }

        @Override
        public String getTitle() {
            return this.fDlgInput.getTitle();
        }
    }
}

