/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinkNode;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public class FileLinkTypeNode {
    private final URI linkTypeResourceUri;
    private final String linkTypeLabel;
    private final URI linkTypeIconUri;
    private final Collection<FileLinkNode> children;

    public static FileLinkTypeNode create(OslcFileLink link) {
        return new FileLinkTypeNode(link.getRelatedArtifactUrl(), link.getRelationshipDisplayName(), link.getRelationshipIcon());
    }

    public FileLinkTypeNode(URI linkTypeResourceUri, String linkTypeLabel, URI linkTypeIconUri) {
        Assert.isNotNull((Object)linkTypeLabel);
        this.linkTypeResourceUri = linkTypeResourceUri;
        this.linkTypeLabel = linkTypeLabel;
        this.linkTypeIconUri = linkTypeIconUri;
        this.children = NewCollection.arrayList();
    }

    public String getLinkTypeResourceUri() {
        if (this.linkTypeResourceUri == null) {
            return null;
        }
        return this.linkTypeResourceUri.toString();
    }

    public String getLinkTypeLabel() {
        return this.linkTypeLabel;
    }

    public Collection<FileLinkNode> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public void setChildren(Collection<FileLinkNode> children) {
        this.children.clear();
        this.children.addAll(children);
    }

    public ImageDescriptor getLinkTypeImage(Display display, IOperationRunner runner) {
        if (this.linkTypeIconUri != null) {
            try {
                return UiPlugin.getImageDescriptor(display, runner, this.linkTypeIconUri.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

