/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs;

import com.ibm.team.filesystem.ui.actions.gcartifacts.FileLinkTypeUtil;
import com.ibm.team.filesystem.ui.tooltips.IOslcURIReference;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;

public class FileLinkNode
implements IOslcURIReference {
    private static final String BROKEN_LINK_IMAGE = "/icons/obj16/link_broken_obj.gif";
    private static final String PLUGIN_ID = "com.ibm.team.scm.common";
    private OslcFileLink linkInfo;
    private String linkLabel;
    private URI linkIconURI;

    public FileLinkNode(OslcFileLink linkInfo) {
        Assert.isNotNull((Object)(linkInfo != null ? 1 : 0));
        this.linkInfo = linkInfo;
    }

    public OslcFileLink getOslcFileLinkInfo() {
        return this.linkInfo;
    }

    public void setOslcFileLinkInfo(OslcFileLink linkInfo) {
        this.linkInfo = linkInfo;
    }

    public String getLinkLabel() {
        return this.linkLabel;
    }

    public void setLinkLabel(String label) {
        this.linkLabel = label;
    }

    @Override
    public URI getOslcFileLink() {
        return this.linkInfo.getRelatedArtifactUrl();
    }

    public String getDisplayName() {
        if (this.linkLabel == null || this.linkLabel.isEmpty()) {
            return Messages.FileExternalLink_Unresolved_link;
        }
        return this.linkLabel;
    }

    public ImageDescriptor getLinkImageDescriptor() throws MalformedURLException {
        if (this.linkIconURI == null) {
            return FileLinkTypeUtil.getImageFromLocalFile(BROKEN_LINK_IMAGE, PLUGIN_ID);
        }
        return FileLinkTypeUtil.getImageFromLocalUri(this.linkIconURI);
    }

    public URI getIconURI() {
        return this.linkIconURI;
    }

    public void setIconURI(URI iconUri) {
        this.linkIconURI = iconUri;
    }

    @Override
    public String getTitle() {
        return this.linkLabel;
    }
}

