/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs;

import com.ibm.team.filesystem.ide.ui.internal.dialogs.ScmTreeDialogViewer;
import com.ibm.team.filesystem.ui.actions.gcartifacts.FileLinkTypeUtil;
import com.ibm.team.filesystem.ui.actions.gcartifacts.GcContextReference;
import com.ibm.team.filesystem.ui.actions.gcartifacts.GlobalConfigControl;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.ExternalLinksWithStatus;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinkNode;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinkTypeNode;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinksDialog;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.OpenRemoveDlgContextMenuAction;
import com.ibm.team.filesystem.ui.tooltips.OslcURITooltipSupport;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.Query;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class FileLinkDialogViewer
extends ScmTreeDialogViewer {
    private static final String ERROR_NODE_URI_STR = "https://example.com/error";
    private FileLinksDialog.IShareableLinks linkMetadata;
    private GlobalConfigControl gcControl;
    private JobRunner jobRunner;

    public FileLinkDialogViewer(Composite parent, Object input) {
        super(parent, input);
        IFilter initialSelection = new IFilter(){

            public boolean select(Object toTest) {
                return false;
            }
        };
        this.addCheckedListener(initialSelection, this.getSorter());
    }

    @Override
    protected Comparator getSorter() {
        return new LinkComparator();
    }

    @Override
    protected String getLabelText() {
        return Messages.FileExternalLink_OPENREMOVE_DLG_TREE_LABEL;
    }

    @Override
    protected void createDialogSpecificControls(Composite composite, JobRunner runner) {
        this.jobRunner = runner;
        this.gcControl = new GlobalConfigControl(composite, this.linkMetadata != null ? this.linkMetadata.getRepository() : null, runner);
        GridDataFactory.defaultsFor((Control)this.gcControl).grab(true, false).applyTo((Control)this.gcControl);
        this.gcControl.addGCChangedListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (FileLinkDialogViewer.this.gcControl.getSelectedGCContext() != null) {
                    FileLinkDialogViewer.this.redrawTree();
                }
            }
        });
        this.gcControl.getShell().addListener(22, new Listener(){

            public void handleEvent(Event e) {
                FileLinkDialogViewer.this.enableDialogControls(true);
                FileLinkDialogViewer.this.redrawTree();
            }
        });
    }

    @Override
    protected void setControlState() {
        if (this.gcControl.getSelectedGCContext() == null) {
            this.enableDialogControls(false);
        }
    }

    private void redrawTree() {
        if (this.linkMetadata == null || this.gcControl == null) {
            return;
        }
        GcContextReference ref = this.gcControl.getSelectedGCContext();
        if (ref == null) {
            return;
        }
        final String gc = ref.getResourceURI().toString();
        final Display display = this.getControl().getShell().getDisplay();
        if (this.jobRunner != null) {
            this.setInputData(Messages.FileExternalLink_OPERATION_FETCHING_RELATED_ARTIFACTS);
            this.jobRunner.enqueue(Messages.FileExternalLink_OPERATION_FETCHING_PROVIDERS, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    final ExternalLinksWithStatus metadata = FileLinkDialogViewer.this.getLinkData(FileLinkDialogViewer.this.linkMetadata, gc, monitor);
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FileLinkDialogViewer.this.setInputData(FileLinkDialogViewer.this.linkMetadata, metadata, gc);
                        }
                    });
                    monitor.done();
                }
            });
        }
    }

    @Override
    protected SimpleTreeViewer createTreeViewer(JobRunner runner) {
        this.treeViewer = new SimpleTreeViewer(this.composite, (ITreeProvider)new FileLinkNodeTreeProvider((IOperationRunner)runner, this.linkMetadata.getRepository(), (ISetWithListeners)this.rootSet), 2816);
        this.treeViewer.setLabelProvider((IViewerLabelProvider)new FileLinkNodeLabelProvider(runner));
        this.treeViewer.setSorter(this.getSorter());
        this.treeViewer.setInput((Object)this.rootSet);
        this.treeViewer.expandAll();
        this.createContextMenu(this.treeViewer);
        new OslcURITooltipSupport(this.treeViewer.getControl(), this.linkMetadata.getRepository());
        return this.treeViewer;
    }

    private void enableDialogControls(boolean enable) {
        this.treeViewer.getTree().setEnabled(enable);
    }

    private void createContextMenu(SimpleTreeViewer stv) {
        MenuManager menuMgr = stv.getContextMenu();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FileLinkDialogViewer.this.addTreeNodeActions(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(stv.getControl());
        stv.getControl().setMenu(menu);
    }

    protected void addTreeNodeActions(IMenuManager manager) {
        TreeItem[] items = this.treeViewer.getTree().getSelection();
        LinkedList<FileLinkNode> nodes = new LinkedList<FileLinkNode>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem obj = treeItemArray[n2];
            if (obj.getData() instanceof FileLinkNode) {
                nodes.add((FileLinkNode)obj.getData());
            }
            ++n2;
        }
        if (nodes == null || nodes.size() < 1) {
            return;
        }
        this.addCopyURLAction(manager, nodes);
        this.addCopyCommentAction(manager, nodes);
    }

    protected boolean canAddContextMenu(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem obj = treeItemArray[n2];
            if (!(obj.getData() instanceof FileLinkNode)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void addSeparator(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void addCopyURLAction(IMenuManager manager, List<FileLinkNode> nodes) {
        OpenRemoveDlgContextMenuAction contextMenu = new OpenRemoveDlgContextMenuAction();
        contextMenu.setText(Messages.FileExternalLink_FILELINKTYPE_OPENREMOVE_DLG_CONTEXTMENU_COPYLINK_LABEL);
        contextMenu.setId(OpenRemoveDlgContextMenuAction.FILELINK_ACTION_COPYLINK_ID);
        contextMenu.setNodes(nodes);
        manager.add((IAction)contextMenu);
    }

    protected void addCopyCommentAction(IMenuManager manager, List<FileLinkNode> nodes) {
        OpenRemoveDlgContextMenuAction contextMenu = new OpenRemoveDlgContextMenuAction();
        contextMenu.setText(Messages.FileExternalLink_FILELINKTYPE_OPENREMOVE_DLG_CONTEXTMENU_COPYLINKCOMMENT_LABEL);
        contextMenu.setId(OpenRemoveDlgContextMenuAction.FILELINK_ACTION_COPYLABEL_ID);
        contextMenu.setNodes(nodes);
        manager.add((IAction)contextMenu);
    }

    protected void addCheckedListener(IFilter initialSelection, Comparator comparator) {
        this.checked.clear();
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 0) {
                    TreeItem item = (TreeItem)e.item;
                    FileLinkDialogViewer.this.checked.clear();
                    if (item.getData() instanceof FileLinkNode) {
                        FileLinkDialogViewer.this.checked.add(item.getData());
                    }
                }
            }
        });
    }

    private void setInputData(String statusMessage) {
        FileLinkTypeNode typeNode = new FileLinkTypeNode(null, statusMessage, null);
        this.rootSet.clear();
        this.checked.clear();
        this.rootSet.add((Object)typeNode);
    }

    private void setInputData(ExternalLinksWithStatus.LinkStatus fetchError) {
        String errorLabel = "";
        if (fetchError == ExternalLinksWithStatus.LinkStatus.outgoing_failed) {
            errorLabel = NLS.bind((String)Messages.FileExternalLink_FAILURE_TO_FETCH_OUTGOING, (Object)Messages.FileExternalLink_ERROR_LOG_REFERAL, (Object[])new Object[0]);
        } else if (fetchError == ExternalLinksWithStatus.LinkStatus.incoming_failed) {
            errorLabel = NLS.bind((String)Messages.FileExternalLink_FAILURE_TO_FETCH_INCOMING, (Object)Messages.FileExternalLink_ERROR_LOG_REFERAL, (Object[])new Object[0]);
        } else if (fetchError == ExternalLinksWithStatus.LinkStatus.outgoing_incoming_failed) {
            errorLabel = NLS.bind((String)Messages.FileExternalLink_FAILURE_TO_FETCH_OUTGOING_AND_INCOMING, (Object)Messages.FileExternalLink_ERROR_LOG_REFERAL, (Object[])new Object[0]);
        }
        ErrorNode typeNode = new ErrorNode(errorLabel);
        this.rootSet.clear();
        this.checked.clear();
        this.rootSet.add((Object)typeNode);
    }

    private void setInputData(FileLinksDialog.IShareableLinks data, ExternalLinksWithStatus linksWithStatus, String gc) {
        List<OslcFileLink> links = linksWithStatus.getExternalLinks();
        if (links == null || links.isEmpty()) {
            if (linksWithStatus.hasError()) {
                this.setInputData(linksWithStatus.getStatus());
            } else {
                this.setInputData(Messages.FileExternalLink_OPERATION_FETCHING_NO_RELATED_ARTIFACTS);
            }
            return;
        }
        if (linksWithStatus.hasError()) {
            this.setInputData(linksWithStatus.getStatus());
        } else {
            this.rootSet.clear();
            this.checked.clear();
        }
        HashMap allNodes = NewCollection.hashMap();
        HashMap typeNodes = NewCollection.hashMap();
        for (OslcFileLink link : links) {
            String key = String.valueOf(link.getRelationshipDisplayName()) + link.getOslcRelationshipUri();
            if (allNodes.get(key) == null) {
                allNodes.put(key, new LinkedList());
            }
            FileLinkNode node = new FileLinkNode(link);
            ((List)allNodes.get(key)).add(node);
            if (typeNodes.containsKey(key)) continue;
            FileLinkTypeNode tnode = FileLinkTypeNode.create(link);
            typeNodes.put(key, tnode);
        }
        for (String key : allNodes.keySet()) {
            FileLinkTypeNode typeNode = (FileLinkTypeNode)typeNodes.get(key);
            typeNode.setChildren((Collection)allNodes.get(key));
            this.rootSet.add((Object)typeNode);
        }
    }

    private ExternalLinksWithStatus getLinkData(FileLinksDialog.IShareableLinks data, String gc, IProgressMonitor monitor) throws TeamRepositoryException {
        return data.getLinks(gc, monitor);
    }

    @Override
    protected void getInitialTreeRoots(Object input) {
        this.linkMetadata = (FileLinksDialog.IShareableLinks)input;
    }

    @Override
    protected String getStatusMessage(Object input) {
        return Messages.FileExternalLink_FILELINKTYPE_ERROR_OPENREMOVE_DLG_NOITEMSELECTED;
    }

    @Override
    protected IObservableValue getValidationStatus() {
        return this.validationStatus;
    }

    @Override
    public Composite getControl() {
        return this.composite;
    }

    public List<FileLinkNode> getResult() {
        ArrayList<FileLinkNode> result = new ArrayList<FileLinkNode>(this.checked.size());
        for (Object o : this.checked) {
            if (!(o instanceof FileLinkNode)) continue;
            FileLinkNode selected = (FileLinkNode)o;
            result.add(selected);
        }
        return result;
    }

    private static class DecoratedFileLinkNodesQuery
    extends Query<FileLinkNode> {
        private final Collection<FileLinkNode> children;
        private final ITeamRepository repository;

        public DecoratedFileLinkNodesQuery(IOperationRunner runner, ITeamRepository repo, Collection<FileLinkNode> inChildren) {
            super(runner);
            this.children = inChildren;
            this.repository = repo;
        }

        public List<FileLinkNode> computeResult(IProgressMonitor monitor) throws InvocationTargetException {
            ArrayList<FileLinkNode> nodes = new ArrayList<FileLinkNode>(this.children.size());
            for (FileLinkNode node : this.children) {
                FileLinkTypeUtil.QuickPreview quickView = null;
                try {
                    quickView = FileLinkTypeUtil.resolveExternalURI(this.repository, node.getOslcFileLink(), monitor);
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
                if (quickView != null) {
                    node.setIconURI(quickView.iconURI);
                    node.setLinkLabel(quickView.comment);
                }
                nodes.add(node);
            }
            return nodes;
        }

        public String getName() {
            return Messages.FileExternalLink_FILELINKTYPE_INFO_DLG_OPENREMOVE;
        }
    }

    private static class ErrorNode
    extends FileLinkTypeNode {
        public ErrorNode(String errorLabel) {
            super(URI.create(FileLinkDialogViewer.ERROR_NODE_URI_STR), errorLabel, null);
        }

        @Override
        public ImageDescriptor getLinkTypeImage(Display display, IOperationRunner runner) {
            return ImagePool.ERROR_OBJ;
        }
    }

    private static class FileLinkNodeLabelProvider
    extends BaseLabelProvider {
        private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        private final JobRunner runner;

        FileLinkNodeLabelProvider(JobRunner runner) {
            this.runner = runner;
        }

        public void updateLabel(ViewerLabel label, Object element) {
            ImageDescriptor desc;
            Object node;
            if (element instanceof FileLinkTypeNode) {
                node = (FileLinkTypeNode)element;
                label.setText(((FileLinkTypeNode)node).getLinkTypeLabel());
                desc = ((FileLinkTypeNode)node).getLinkTypeImage(this.getDisplay(), (IOperationRunner)this.runner);
                if (desc != null) {
                    label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)desc));
                } else {
                    label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.CLOCK_ICON));
                }
            }
            if (element instanceof FileLinkNode) {
                node = (FileLinkNode)element;
                label.setText(((FileLinkNode)node).getDisplayName());
                try {
                    desc = ((FileLinkNode)node).getLinkImageDescriptor();
                    if (desc != null) {
                        label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)desc));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        public void dispose() {
            this.fResourceManager.dispose();
        }
    }

    private static class FileLinkNodeTreeProvider
    extends AbstractRepositoryTreeProvider {
        private final ISetWithListeners root;
        private final ITeamRepository repo;

        public FileLinkNodeTreeProvider(IOperationRunner runner, ITeamRepository inRepo, ISetWithListeners root) {
            this.root = root;
            this.repo = inRepo;
        }

        public ISetWithListeners getChildren(Object element) {
            if (element == this.root) {
                return this.root;
            }
            if (element instanceof FileLinkTypeNode) {
                if (element instanceof ErrorNode) {
                    return null;
                }
                FileLinkTypeNode linkTypeNode = (FileLinkTypeNode)element;
                return new DecoratedFileLinkNodesQuery((IOperationRunner)new JobRunner(true), this.repo, linkTypeNode.getChildren());
            }
            return null;
        }
    }

    private static class LinkComparator
    implements Comparator {
        private LinkComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object c1;
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof FileLinkTypeNode) {
                c1 = (FileLinkTypeNode)o1;
                if (o2 instanceof FileLinkTypeNode) {
                    FileLinkTypeNode c2 = (FileLinkTypeNode)o2;
                    return ((FileLinkTypeNode)c1).getLinkTypeLabel().compareToIgnoreCase(c2.getLinkTypeLabel());
                }
            }
            if (o1 instanceof FileLinkNode) {
                c1 = (FileLinkNode)o1;
                if (o2 instanceof FileLinkNode) {
                    FileLinkNode c2 = (FileLinkNode)o2;
                    return ((FileLinkNode)c1).getDisplayName().compareToIgnoreCase(c2.getDisplayName());
                }
            }
            throw new ClassCastException();
        }
    }
}

