/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnChangeFileProperties;
import com.ibm.team.filesystem.ui.actions.gcartifacts.FileLinkDialogInput;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinkNode;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinksDialog;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RemoveFileLinksActionDelegate
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.isEmpty() || selection.getFirstElement() == null) {
            return;
        }
        IShareable shareable = (IShareable)Adapters.getAdapter((Object)selection.getFirstElement(), IShareable.class);
        if (shareable == null) {
            return;
        }
        this.showOpenRemoveLinksDialog(shell, Messages.FileExternalLink_REMOVELINKTYPE_DLG_TITLE, Messages.FileExternalLink_REMOVELINKTYPE_DLG_LABEL, shareable);
    }

    private void showOpenRemoveLinksDialog(final Shell shell, final String title, final String message, final IShareable shareable) {
        this.getOperationRunner().enqueue(Messages.FileExternalLink_OPERATION_FETCHING_PROVIDERS, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                IShare share = shareable.getShare(monitor);
                if (share != null) {
                    ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)share.getSharingDescriptor().getRepositoryId());
                    FileLinkDialogInput dlgInData = new FileLinkDialogInput(title, message, Messages.FileExternalLink_FILELINKTYPE_REMOVE_OKBUTTON_LABEL);
                    final FileLinksDialog.ShareableOutgoingLinks shareableLinks = new FileLinksDialog.ShareableOutgoingLinks(shareable, monitor, repo, dlgInData);
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object result;
                            FileLinksDialog dialog = new FileLinksDialog(shell, shareableLinks);
                            if (dialog.open() == 0 && (result = dialog.getResult()) instanceof Collection) {
                                Collection resultList = (Collection)result;
                                LinkedList<FileLinkNode> nodes = new LinkedList<FileLinkNode>();
                                for (Object obj : resultList) {
                                    if (!(obj instanceof FileLinkNode)) continue;
                                    nodes.add((FileLinkNode)obj);
                                }
                                RemoveFileLinksActionDelegate.this.handleRemoveLinks(shell, shareable, nodes);
                            }
                        }
                    });
                }
            }
        });
    }

    private boolean handleRemoveLinks(final Shell shell, final IShareable shareable, final List<FileLinkNode> linksToDelete) {
        final boolean[] retCode = new boolean[1];
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.FileExternalLink_REMOVELINKTYPE_PROGRESS_STATUS, 100);
                    try {
                        retCode[0] = RemoveFileLinksActionDelegate.this.removeExternalLinks(shell, shareable, linksToDelete, monitor);
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return retCode[0];
    }

    private boolean removeExternalLinks(Shell shell, IShareable shareable, List<FileLinkNode> linkstoDelete, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 + linkstoDelete.size()));
        WarnChangeFileProperties dilemmaHandler = new WarnChangeFileProperties(shell, Messages.FileExternalLink_ERROR_REMOVEFILELINK);
        IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation((ChangePropertiesDilemmaHandler)dilemmaHandler);
        for (FileLinkNode obj : linkstoDelete) {
            if (!(obj instanceof FileLinkNode)) continue;
            FileLinkNode linfo = obj;
            operation.removeExternalLink(shareable, linfo.getOslcFileLinkInfo(), (IProgressMonitor)progress.newChild(1));
        }
        boolean errorOccured = false;
        try {
            operation.run((IProgressMonitor)progress.newChild(10));
        }
        catch (FileSystemException e) {
            errorOccured = true;
            StatusUtil.log((Object)((Object)this), (String)Messages.FileExternalLink_ERROR_REMOVEFILELINK, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            errorOccured = true;
            StatusUtil.log((Object)((Object)this), (String)Messages.FileExternalLink_ERROR_REMOVEFILELINK, (Throwable)e);
        }
        return !errorOccured;
    }
}

