/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ui.actions.gcartifacts.FileLinkDialogInput;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinkNode;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.FileLinksDialog;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenFileLinksActionDelegate
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.isEmpty() || selection.getFirstElement() == null) {
            return;
        }
        final IShareable shareable = (IShareable)Adapters.getAdapter((Object)selection.getFirstElement(), IShareable.class);
        if (shareable == null) {
            return;
        }
        ILinkInfoGetter linkInfoGetter = new ILinkInfoGetter(){

            @Override
            public FileLinksDialog.IShareableLinks getShareableLinks(IProgressMonitor monitor, FileLinkDialogInput dlgInData) throws FileSystemException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
                if (share != null) {
                    ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)share.getSharingDescriptor().getRepositoryId());
                    return new FileLinksDialog.VersionableAllLinks(shareable, (IProgressMonitor)progress.newChild(50), repo, dlgInData);
                }
                return null;
            }
        };
        this.showTreeDialog(shell, linkInfoGetter, Messages.FileExternalLink_OPENLINKTYPE_DLG_TITLE, Messages.FileExternalLink_OPENLINKTYPE_DLG_LABEL);
    }

    protected void showTreeDialog(final Shell shell, final ILinkInfoGetter linkInfoGetter, final String title, final String message) {
        this.getOperationRunner().enqueue(Messages.FileExternalLink_OPERATION_FETCHING_PROVIDERS, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                FileLinkDialogInput dlgInData = new FileLinkDialogInput(title, message, Messages.FileExternalLink_FILELINKTYPE_OPEN_OKBUTTON_LABEL);
                final FileLinksDialog.IShareableLinks shareableLinks = linkInfoGetter.getShareableLinks(monitor, dlgInData);
                if (shareableLinks != null) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object result;
                            FileLinksDialog dialog = new FileLinksDialog(shell, shareableLinks);
                            if (dialog.open() == 0 && (result = dialog.getResult()) instanceof Collection) {
                                Collection resultList = (Collection)result;
                                LinkedList<FileLinkNode> nodes = new LinkedList<FileLinkNode>();
                                for (Object obj : resultList) {
                                    if (!(obj instanceof FileLinkNode)) continue;
                                    nodes.add((FileLinkNode)obj);
                                }
                                OpenFileLinksActionDelegate.this.openReferences(nodes);
                            }
                        }
                    });
                }
            }
        });
    }

    private void openReferences(final List<FileLinkNode> selectedNodes) {
        if (selectedNodes.size() < 1) {
            return;
        }
        FoundationJob job = new FoundationJob(Messages.FileExternalLink_STATUSMSG_OPENING_LINKS){

            protected IStatus runProtected(IProgressMonitor monitor) {
                ArrayList uris = NewCollection.arrayList();
                URI context = null;
                for (Object object : selectedNodes) {
                    FileLinkNode link;
                    if (!(object instanceof FileLinkNode) || (context = (link = (FileLinkNode)object).getOslcFileLink()) == null) continue;
                    uris.add(context);
                }
                return Hyperlinks.open((List)uris, (ContextProvider)new StandardContextProvider(null, new URIReference("context", "", context)), (IProgressMonitor)monitor);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected static interface ILinkInfoGetter {
        public FileLinksDialog.IShareableLinks getShareableLinks(IProgressMonitor var1, FileLinkDialogInput var2) throws FileSystemException;
    }
}

