/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts;

import com.ibm.team.calm.foundation.common.linking.OSLCReference;
import com.ibm.team.calm.foundation.rcp.ui.linking.GcPickerDialog;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.actions.gcartifacts.GcContextReference;
import com.ibm.team.filesystem.ui.tooltips.IOslcURIReference;
import com.ibm.team.filesystem.ui.tooltips.OslcURITooltipSupport;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GlobalConfigControl
extends Composite
implements SelectionListener {
    private static final String SETTINGS = "fileTraceabilityLinksDialog";
    private static final String KEYS = "uris";
    private static final String VALUES = "displaynames";
    private static final int maxMruSize = 5;
    private final Combo globalConfigComboBox;
    private final Deque<MruGcContext> mru;
    private final ITeamRepository repository;
    private final JobRunner jobRunner;
    private GcContextReference selectedGC;

    private static Deque<MruGcContext> getStoredMruContexts() {
        Deque mru = NewCollection.arrayDeque();
        IDialogSettings parentSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = parentSettings.getSection(SETTINGS);
        if (dialogSettings != null) {
            String[] uris = dialogSettings.getArray(KEYS);
            String[] values = dialogSettings.getArray(VALUES);
            if (uris != null && values != null) {
                int k = 0;
                String[] stringArray = uris;
                int n = uris.length;
                int n2 = 0;
                while (n2 < n) {
                    String uri = stringArray[n2];
                    String label = values[k++];
                    mru.addLast(new MruGcContext(uri, label));
                    ++n2;
                }
            }
        }
        return mru;
    }

    private static void storeMruContexts(Deque<MruGcContext> mru) {
        Assert.isNotNull(mru);
        IDialogSettings parentSettings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = parentSettings.getSection(SETTINGS);
        if (dialogSettings == null) {
            dialogSettings = parentSettings.addNewSection(SETTINGS);
        }
        while (mru.size() > 5) {
            mru.removeLast();
        }
        int size = mru.size();
        String[] keys = new String[size];
        String[] values = new String[size];
        int k = 0;
        for (MruGcContext context : mru) {
            keys[k] = context.furi;
            values[k] = context.displayName;
            ++k;
        }
        dialogSettings.put(KEYS, keys);
        dialogSettings.put(VALUES, values);
    }

    public GlobalConfigControl(Composite parent, ITeamRepository repo, JobRunner runner) {
        super(parent, 0);
        Assert.isNotNull((Object)repo);
        this.repository = repo;
        this.jobRunner = runner == null ? new JobRunner(true) : runner;
        this.mru = GlobalConfigControl.getStoredMruContexts();
        this.selectMostRecentSelection();
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(0, 0, 0, 0).margins(0, 0).generateLayout((Composite)this);
        Label label = new Label((Composite)this, 16448);
        label.setText(Messages.FileExternalLink_Dlg_CurrentGlobalContext);
        this.globalConfigComboBox = new Combo((Composite)this, 18440);
        GridDataFactory.defaultsFor((Control)this.globalConfigComboBox).grab(true, false).applyTo((Control)this.globalConfigComboBox);
        this.globalConfigComboBox.setToolTipText(Messages.GlobalConfigControl_Message_TooltipSelect);
        this.globalConfigComboBox.addSelectionListener((SelectionListener)this);
        GC gc = new GC((Drawable)this.globalConfigComboBox);
        gc.dispose();
        this.globalConfigComboBox.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GlobalConfigControl.storeMruContexts(GlobalConfigControl.this.mru);
            }
        });
        this.addOslcToolTipSupport();
        this.updateDialogState();
    }

    private void selectMostRecentSelection() {
        MruGcContext latest = this.mru.peek();
        if (latest != null) {
            try {
                this.selectedGC = new GcContextReference(new URI(latest.furi), latest.displayName);
            }
            catch (URISyntaxException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
    }

    private void addOslcToolTipSupport() {
        new OslcURITooltipSupport((Control)this.globalConfigComboBox, this.repository);
    }

    public GcContextReference getSelectedGCContext() {
        return this.selectedGC;
    }

    public void addGCChangedListener(int eventType, Listener listener) {
        this.globalConfigComboBox.addListener(eventType, listener);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.globalConfigComboBox) {
            String selectedText = this.globalConfigComboBox.getText();
            if (selectedText == null || selectedText.isEmpty()) {
                return;
            }
            if (selectedText.equals(Messages.GlobalConfigControl_Message_More)) {
                this.letUserPickGC();
            } else if (selectedText.equals(Messages.GlobalConfigControl_Message_Select)) {
                this.letUserPickGC();
            } else {
                GcOslcURIReference ref = (GcOslcURIReference)this.globalConfigComboBox.getData(selectedText);
                if (ref != null) {
                    this.updateSelection(new GcContextReference(ref.getOslcFileLink(), selectedText));
                }
            }
        }
    }

    private void letUserPickGC() {
        final Display display = this.getShell().getDisplay();
        this.jobRunner.enqueue(Messages.FileExternalLink_FILELINKTYPE_INFO_DLG_OPENREMOVE, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                ITeamRepository[] repos = new ITeamRepository[]{GlobalConfigControl.this.repository};
                final boolean isGcAvailable = GcPickerDialog.isGcPickerAvailable((ITeamRepository[])repos);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GlobalConfigControl.this.selectGcIfGCServiceAvailable(isGcAvailable);
                    }
                });
            }
        });
    }

    private void selectGcIfGCServiceAvailable(boolean isGcAvailable) {
        if (!isGcAvailable) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.FileExternalLink_NO_GC_FOUND_TITLE, (String)NLS.bind((String)Messages.FileExternalLink_NO_GC_FOUND, (Object)this.repository.getName(), (Object[])new Object[0]));
        } else {
            GcContextReference userSelection = this.selectGc();
            if (userSelection != null) {
                this.updateSelection(userSelection);
            } else {
                this.updateDialogState();
            }
        }
    }

    private GcContextReference selectGc() {
        try {
            IWorkbenchWindow runnableContext = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            GcPickerDialog gcPicker = new GcPickerDialog(this.getShell(), (IRunnableContext)runnableContext, new ITeamRepository[]{this.repository});
            Collection ref = gcPicker.openAndGetResults();
            if (ref != null) {
                for (OSLCReference oslcref : ref) {
                    if (oslcref == null) continue;
                    return new GcContextReference(oslcref);
                }
            }
        }
        catch (Exception e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
        return null;
    }

    private void updateSelection(GcContextReference userSelection) {
        this.selectedGC = userSelection;
        this.updateMru();
        this.updateDialogState();
        this.globalConfigComboBox.notifyListeners(2, null);
    }

    private void updateMru() {
        MruGcContext temp = new MruGcContext(this.selectedGC.getResourceURI().toString(), this.selectedGC.getLabel());
        this.mru.remove(temp);
        this.mru.addFirst(temp);
    }

    private void updateDialogState() {
        assert (this.selectedGC == null == this.mru.isEmpty());
        assert (this.mru.isEmpty() || GlobalConfigControl.isSameGc(this.selectedGC, this.mru.peek()));
        if (this.globalConfigComboBox.isDisposed()) {
            return;
        }
        this.globalConfigComboBox.removeAll();
        if (this.selectedGC != null) {
            for (MruGcContext context : this.mru) {
                try {
                    this.addToCombo(new GcContextReference(new URI(context.furi), context.displayName));
                }
                catch (URISyntaxException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                }
            }
            this.globalConfigComboBox.add(Messages.GlobalConfigControl_Message_More);
        } else {
            this.globalConfigComboBox.add(Messages.GlobalConfigControl_Message_Disconnected);
            this.globalConfigComboBox.add(Messages.GlobalConfigControl_Message_Select);
        }
        this.globalConfigComboBox.removeSelectionListener((SelectionListener)this);
        this.globalConfigComboBox.select(0);
        this.globalConfigComboBox.addSelectionListener((SelectionListener)this);
    }

    private void addToCombo(GcContextReference ref) {
        assert (!this.globalConfigComboBox.isDisposed());
        this.globalConfigComboBox.add(ref.getLabel());
        this.globalConfigComboBox.setData(ref.getLabel(), (Object)new GcOslcURIReference(ref.getResourceURI().toString()));
    }

    private static boolean isSameGc(GcContextReference gcReference, MruGcContext gcContext) {
        URI refUri = gcReference.getResourceURI();
        String refUriStr = Objects.toString(refUri);
        return Objects.equals(refUriStr, gcContext.furi);
    }

    private static class GcOslcURIReference
    implements IOslcURIReference {
        private final URI uri;

        public GcOslcURIReference(String uriString) {
            this.uri = URI.create(uriString);
        }

        @Override
        public URI getOslcFileLink() {
            return this.uri;
        }

        @Override
        public String getTitle() {
            return "";
        }
    }

    private static class MruGcContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String furi;
        public String displayName;

        public MruGcContext(String uri, String label) {
            Assert.isNotNull((Object)uri);
            Assert.isNotNull((Object)label);
            this.furi = uri;
            this.displayName = label;
        }

        public int hashCode() {
            return this.furi.hashCode() ^ this.displayName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            MruGcContext in = (MruGcContext)obj;
            return in.furi.equals(this.furi);
        }
    }
}

