/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts;

import com.ibm.team.calm.foundation.client.preview.ResourcePreviewManager;
import com.ibm.team.calm.foundation.common.preview.IResourcePreviewManager;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.internal.gc.ExternalLink;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FileLinkTypeUtil {
    public static QuickPreview createQuickPreview() {
        return new QuickPreview();
    }

    public static ImageDescriptor getImageFromLocalFile(String relPath, String pluginId) {
        if (relPath != null && !relPath.isEmpty()) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)relPath);
        }
        return null;
    }

    public static ImageDescriptor getImageFromLocalUri(URI uri) throws MalformedURLException {
        if (uri != null) {
            return ImageDescriptor.createFromURL((URL)uri.toURL());
        }
        return null;
    }

    public static QuickPreview resolveExternalURI(ITeamRepository fRepo, ExternalLink linkInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return FileLinkTypeUtil.resolveExternalURI(fRepo, linkInfo.getUri(), monitor);
    }

    public static QuickPreview resolveExternalURI(ITeamRepository fRepo, URI linkURL, IProgressMonitor monitor) throws TeamRepositoryException {
        String url = linkURL.toString();
        QuickPreview quickView = null;
        URI qualifiedLinkURI = null;
        try {
            qualifiedLinkURI = new URI(url);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (qualifiedLinkURI == null) {
            return quickView;
        }
        IURIReference fReference = IReferenceFactory.INSTANCE.createReferenceFromURI(qualifiedLinkURI, "");
        if (fReference == null) {
            return quickView;
        }
        ResourcePreviewManager mgr = (ResourcePreviewManager)fRepo.getClientLibrary(IResourcePreviewManager.class);
        if (mgr == null) {
            return quickView;
        }
        ResourcePreview obj = null;
        try {
            obj = mgr.fetchPreviewFromReference(fReference, 0, true, monitor);
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((IStatus)StatusUtil.newStatus(FileLinkTypeUtil.class, (Throwable)e));
        }
        if (obj == null) {
            return quickView;
        }
        ResourcePreview details = null;
        if (obj instanceof ResourcePreview) {
            details = obj;
        }
        if (details == null) {
            return quickView;
        }
        quickView = new QuickPreview();
        quickView.comment = details.getTitle().getPlainText();
        quickView.iconURI = details.getIconURI();
        quickView.uri = linkURL.toString();
        return quickView;
    }

    public static String escapeForHTMLTransfer(String string) {
        if (string == null || string.length() == 0 || !SWT.getPlatform().equals("win32")) {
            return string;
        }
        Charset defaultCharset = Charset.defaultCharset();
        if (!defaultCharset.canEncode()) {
            return string;
        }
        CharsetEncoder encoder = defaultCharset.newEncoder();
        if (encoder.canEncode(string)) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (encoder.canEncode(ch)) {
                builder.append(ch);
            } else {
                builder.append("&#");
                builder.append((int)ch);
                builder.append(";");
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String createURIWithGCContext(String url, String gcContext) {
        if (gcContext != null && !gcContext.isEmpty()) {
            return String.valueOf(url) + "?" + "oslc_config.context" + "=" + gcContext;
        }
        return url;
    }

    public static String createURIWithGCContext(ExternalLink link, String gcContext) {
        String str = link.getUri().toString();
        return FileLinkTypeUtil.createURIWithGCContext(str, gcContext);
    }

    public static class QuickPreview {
        public String uri;
        public String comment;
        public URI iconURI;
        public Image image;

        private QuickPreview() {
        }
    }
}

