/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.gcartifacts;

import com.ibm.team.calm.foundation.client.linking.CALMLinkingCache;
import com.ibm.team.calm.foundation.common.linking.OSLCReference;
import com.ibm.team.calm.foundation.rcp.ui.linking.CALMResourcePickerDialog;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.gc.ContextUtilities;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ui.actions.gcartifacts.GcContextReference;
import com.ibm.team.filesystem.ui.actions.gcartifacts.dialogs.SelectLinkTypeDialog;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.LinkTypeClientUtils;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.CustomLinkTypeInfo;
import com.ibm.team.scm.common.links.ILinkTypeInfo;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class AddFileLinksActionDelegate
extends AbstractActionDelegate {
    public void run(final Shell shell, final IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.isEmpty() || selection.getFirstElement() == null) {
            return;
        }
        final IShareable shareable = (IShareable)Adapters.getAdapter((Object)selection.getFirstElement(), IShareable.class);
        if (shareable == null) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.FileExternalLink_OPERATION_ADDING_LINKS, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                if (share == null) {
                    return;
                }
                final ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)share.getSharingDescriptor().getRepositoryId());
                IProjectAreaHandle projectArea = AddFileLinksActionDelegate.this.getProjectArea(share, repo, (IProgressMonitor)progress.newChild(1));
                final Map supportedLinkTypes = AddFileLinksActionDelegate.this.asLinkIdMap(LinkTypeClientUtils.getAllLinkTypes((ITeamRepository)repo, (IProjectAreaHandle)projectArea, (IItemType)IFileItem.ITEM_TYPE, (IProgressMonitor)progress.newChild(1)));
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String dialogTitle = Messages.FileExternalLink_SELECTLINKTYPE_DLG_TITLE;
                        String dialogMessage = Messages.FileExternalLink_SELECTLINKTYPE_DLG_LABEL;
                        String dialogDescription = Messages.FileExternalLink_SELECTLINKTYPE_DLG_DESC;
                        SelectLinkTypeDialog dlg = new SelectLinkTypeDialog(page, dialogTitle, dialogMessage, dialogDescription, (Map<LinkTypeIdentifier, ILinkTypeInfo>)supportedLinkTypes, repo);
                        if (dlg.open() == 0) {
                            LinkTypeIdentifier linkTypeId = dlg.getSelectedItemData();
                            String linkTypeLabel = dlg.getSelectedItemLabel();
                            String gcContext = null;
                            GcContextReference ref = dlg.getSelectedGlobalContext();
                            if (ref != null) {
                                gcContext = ref.getResourceURI().toString();
                            }
                            AddFileLinksActionDelegate.this.okHandler(shell, page, shareable, linkTypeId, linkTypeLabel, gcContext, supportedLinkTypes.keySet());
                        }
                    }
                });
            }
        });
    }

    protected IProjectAreaHandle getProjectArea(IShare share, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        if (descriptor.associatedWithWorkspace()) {
            return ContextUtilities.getProjectArea((IWorkspaceHandle)((IWorkspaceHandle)descriptor.getConnectionHandle()), (ITeamRepository)repo, (IProgressMonitor)monitor);
        }
        return null;
    }

    private Map<LinkTypeIdentifier, ILinkTypeInfo> asLinkIdMap(Collection<ILinkType> allLinkTypes) {
        Map result = NewCollection.hashMap((int)(allLinkTypes.size() * 2));
        for (ILinkType type : allLinkTypes) {
            ILinkTypeInfo typeInfo = CustomLinkTypeInfo.create((ILinkType)type);
            result.put(LinkTypeIdentifier.create((ILinkType)type), typeInfo);
        }
        return result;
    }

    private String[] asLinkServiceIds(Collection<LinkTypeIdentifier> linkTypeIdentifiers) {
        String[] result = new String[linkTypeIdentifiers.size()];
        int i = 0;
        for (LinkTypeIdentifier identifier : linkTypeIdentifiers) {
            result[i++] = identifier.toLinkServiceId();
        }
        return result;
    }

    private void okHandler(final Shell shell, final IWorkbenchPage page, final IShareable shareable, final LinkTypeIdentifier linkType, final String linkTypeLabel, final String gcContext, final Collection<LinkTypeIdentifier> supportedLinkTypeIds) {
        this.getOperationRunner().enqueue(Messages.FileExternalLink_OPERATION_ADDING_LINKS, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(5));
                if (share == null) {
                    return;
                }
                ITeamRepository repo = RepositoryUtils.getTeamRepositoryById((UUID)share.getSharingDescriptor().getRepositoryId());
                IWorkspaceHandle wHandle = (IWorkspaceHandle)share.getSharingDescriptor().getConnectionHandle();
                if (repo == null) {
                    return;
                }
                IProjectAreaHandle projectArea = ContextUtilities.getProjectArea((IWorkspaceHandle)wHandle, (ITeamRepository)repo, (IProgressMonitor)progress.newChild(5));
                if (projectArea == null) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)shell, (String)Messages.FileExternalLink_ADDLINKTYPE_DLG_TITLE, (String)Messages.FileExternalLink_NO_PROJECT_AREA);
                        }
                    });
                    return;
                }
                CALMLinkingCache calmLinkCache = CALMLinkingCache.cache((String[])AddFileLinksActionDelegate.this.asLinkServiceIds(supportedLinkTypeIds), (IProjectAreaHandle)projectArea, (IProgressMonitor)progress.newChild(30));
                String encodedContext = gcContext;
                try {
                    encodedContext = URLEncoder.encode(gcContext, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    StatusUtil.log((Object)((Object)this), (String)e.getMessage(), (Throwable)e);
                }
                encodedContext = "oslc_config.context=" + encodedContext;
                CALMResourcePickerDialog calmResourcePickerDialog = null;
                boolean associationExists = true;
                try {
                    calmResourcePickerDialog = new CALMResourcePickerDialog(shell, (IRunnableContext)page.getWorkbenchWindow(), linkType.toLinkServiceId(), calmLinkCache, encodedContext);
                }
                catch (IllegalArgumentException e) {
                    associationExists = false;
                }
                if (!associationExists) {
                    final IProjectArea proj = (IProjectArea)repo.itemManager().fetchCompleteItem((IItemHandle)projectArea, 0, (IProgressMonitor)progress.newChild(10));
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)shell, (String)Messages.FileExternalLink_ADDLINKTYPE_DLG_TITLE, (String)NLS.bind((String)Messages.FileExternalLink_NO_MATCHING_CONTAINER, (Object[])new String[]{proj.getName(), linkTypeLabel}));
                        }
                    });
                    return;
                }
                Collection selections = calmResourcePickerDialog.openAndGetResults();
                IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation(null);
                for (OSLCReference selection : selections) {
                    operation.addExternalLink(shareable, linkType, selection.getResourceURI());
                }
                operation.run((IProgressMonitor)progress.newChild(50));
            }
        });
    }
}

