/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions.flows;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.WorkspaceCollaboration;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.INCOMING_OR_OUTGOING;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SwitchCollaborationAction
extends AbstractActionDelegate {
    private IWorkspaceSyncContext workspaceContext;
    private Set<IComponentSyncContext> contexts;
    private INCOMING_OR_OUTGOING flowDirection;
    private boolean isSameAsRepositoryWorkspace = false;

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final IWorkspaceConnection local = this.workspaceContext.getLocal();
        final ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
        if (this.contexts != null) {
            for (IComponentSyncContext context : this.contexts) {
                components.add((IComponentHandle)context.getComponent());
            }
        }
        final AbstractPlaceWrapper pw = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(shell, local.teamRepository(), local, components, WORKSPACES_OR_STREAMS.STREAMS, true, null, null, true);
        this.flowDirection = WorkspaceAndStreamSelectionDialog.getFlowDirection();
        this.isSameAsRepositoryWorkspace = WorkspaceAndStreamSelectionDialog.isSameAsRepositoryWorkspace();
        if (this.isSameAsRepositoryWorkspace && !components.isEmpty()) {
            this.getOperationRunner().enqueue(Messages.DeliverAndOverrideAction_6, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SwitchCollaborationAction_ChangingFlowTargetMonitorProgress, (int)2);
                    WorkspaceCollaboration collaboration = FileSystemResourcesPlugin.getActiveWorkspaceManager().getWorkspaceCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), (IProgressMonitor)progress.newChild(1));
                    FileSystemResourcesPlugin.getActiveWorkspaceManager().setComponentCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), (Collection)components, collaboration, !local.isStream(), (IProgressMonitor)progress.newChild(1));
                }
            });
            return;
        }
        if (pw != null) {
            this.getOperationRunner().enqueue(Messages.SwitchCollaborationAction_ChangingFlowTargetJobName, (Operation)new RepositoryOperation(pw.getRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    boolean persist;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SwitchCollaborationAction_ChangingFlowTargetMonitorProgress, (int)3);
                    IWorkspaceConnection remote = pw.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                    boolean bl = persist = !local.isStream();
                    if (components.isEmpty()) {
                        if (SwitchCollaborationAction.this.flowDirection == INCOMING_OR_OUTGOING.INCOMING) {
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceIncomingCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), remote, persist, (IProgressMonitor)progress.newChild(1));
                            if (FlowTableUtil.isCurrentOutgoingCollaboration((IWorkspaceConnection)local, (IWorkspace)remote.getResolvedWorkspace())) {
                                FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceOutgoingCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), null, persist, (IProgressMonitor)progress.newChild(1));
                            }
                        } else if (SwitchCollaborationAction.this.flowDirection == INCOMING_OR_OUTGOING.OUTGOING) {
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceOutgoingCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), remote, persist, (IProgressMonitor)progress.newChild(1));
                            if (FlowTableUtil.isCurrentIncomingCollaboration((IWorkspaceConnection)local, (IWorkspace)remote.getResolvedWorkspace())) {
                                FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceIncomingCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), null, persist, (IProgressMonitor)progress.newChild(1));
                            }
                        } else {
                            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), remote, persist, (IProgressMonitor)progress.newChild(2));
                        }
                    } else if (SwitchCollaborationAction.this.flowDirection == INCOMING_OR_OUTGOING.BOTH) {
                        FileSystemResourcesPlugin.getActiveWorkspaceManager().setComponentCollaboration((IWorkspaceHandle)local.getResolvedWorkspace(), (Collection)components, remote, persist, (IProgressMonitor)progress.newChild(2));
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean allFlows;
        Set[] result;
        super.selectionChanged(action, selection);
        this.workspaceContext = null;
        this.contexts = null;
        boolean enable = false;
        List ss = ((IStructuredSelection)selection).toList();
        Set wscs = ComponentSyncUtil.getWorkspaceContexts((Collection)ss);
        boolean isStream = false;
        boolean isUntrackedWorkspace = false;
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        for (IWorkspaceSyncContext wsc : wscs) {
            IWorkspaceConnection workspaceConnection = wsc.getLocal();
            if (workspaceConnection.isStream()) {
                isStream = true;
                break;
            }
            if (manager.isWorkspaceTracked((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace())) continue;
            isUntrackedWorkspace = true;
            break;
        }
        if (!isStream && !isUntrackedWorkspace && (result = ComponentSyncUtil.filter((Collection)ss, (Class[])new Class[]{IWorkspaceSyncContext.class, IComponentSyncContext.class, Object.class}))[2].isEmpty() && !(allFlows = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("show_all_flow_targets"))) {
            Set workspaceContexts;
            if (result[0].size() == 1) {
                this.workspaceContext = (IWorkspaceSyncContext)result[0].iterator().next();
                enable = true;
            }
            if (result[0].isEmpty() && !result[1].isEmpty() && (workspaceContexts = ComponentSyncUtil.getWorkspaceContexts((Collection)result[1])).size() == 1) {
                boolean isLocal = true;
                boolean hasFlow = true;
                for (IComponentSyncContext context : result[1]) {
                    if (!context.isLocal()) {
                        isLocal = false;
                        break;
                    }
                    if (ComponentSyncUtil.hasComponentFlow((IComponentSyncContext)context)) continue;
                    hasFlow = false;
                    break;
                }
                if (isLocal && hasFlow) {
                    this.workspaceContext = (IWorkspaceSyncContext)workspaceContexts.iterator().next();
                    this.contexts = result[1];
                    enable = true;
                }
            }
        }
        if (action != null) {
            action.setEnabled(enable);
        }
    }

    class MyLabelProvider
    extends LabelProvider {
        MyLabelProvider() {
        }

        public String getText(Object element) {
            IWorkspaceConnection teamPlace = (IWorkspaceConnection)element;
            return teamPlace.getName();
        }
    }
}

