/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.rcp.core.internal.resources.ApoRepositoryProvider;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUnShareUser;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPage;

public class UnShareProjectAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final ArrayList<IResource> shareRoots = new ArrayList<IResource>(selection.size());
        for (Object o : selection) {
            if (!(o instanceof IResource)) continue;
            shareRoots.add((IResource)o);
        }
        String message = shareRoots.size() > 1 ? Messages.UnShareAction_2 : Messages.UnShareAction_1;
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean("pref_prompt_disconnect_project");
        boolean proceed = true;
        if (prompt) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)Messages.UnShareAction_0, (String)message, (String)Messages.UnShareAction_3, (boolean)false, null, null);
            if (dialog.getReturnCode() != 0) {
                proceed = false;
            } else {
                store.setValue("pref_prompt_disconnect_project", !dialog.getToggleState());
            }
        }
        if (proceed) {
            this.getOperationRunner().enqueue(Messages.UnShareAction_DisconnectingProjects, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    UnShareProjectAction.unshare(shareRoots, monitor, problems, shell);
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object next : sel) {
                if (next instanceof IProject) continue;
                action.setEnabled(false);
            }
            action.setEnabled(!sel.isEmpty());
        }
    }

    public static void unshare(List<IResource> shareRoots, IProgressMonitor monitor, IStatusCollector problems, Shell shell) throws FileSystemException, TeamRepositoryException {
        HashMap<IRelativeLocation, IShare> toUnshareList = new HashMap<IRelativeLocation, IShare>();
        ArrayList<IResource> toUnmapList = new ArrayList<IResource>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subProgress = progress.newChild(1).setWorkRemaining(shareRoots.size());
        for (IResource root : shareRoots) {
            IShareable shareable = (IShareable)root.getAdapter(IShareable.class);
            if (shareable == null) {
                toUnmapList.add(root);
                continue;
            }
            IShare share = shareable.getShare((IProgressMonitor)subProgress.newChild(1));
            IRelativeLocation localPath = shareable.getLocalPath();
            if (share != null && share.getPath().equals((Object)localPath)) {
                toUnshareList.put(share.getPath(), share);
                continue;
            }
            IShare[] allShares = shareable.getSandbox().allShares((IProgressMonitor)progress.newChild(5));
            boolean containsShares = false;
            IShare[] iShareArray = allShares;
            int n = allShares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare currentShare = iShareArray[n2];
                if (localPath.isPrefixOf(currentShare.getPath())) {
                    containsShares = true;
                    toUnshareList.put(currentShare.getPath(), currentShare);
                }
                ++n2;
            }
            if (containsShares) continue;
            toUnmapList.add(root);
        }
        ArrayList<IShareable> shares = new ArrayList<IShareable>();
        for (IShare share : toUnshareList.values()) {
            shares.add(share.getShareable());
        }
        if (!UnShareProjectAction.promptDeleteNestedShareRoots(shell, shares.toArray(new IShareable[shares.size()]))) {
            return;
        }
        IUnshareOperation unshareOp = IOperationFactory.instance.getUnshareOperation((UnshareDilemmaHandler)new WarnUnShareUser(shell, Messages.UnLoadAction_UnShareOperationTitle, false), IRepositoryResolver.EXISTING_SHARED);
        unshareOp.requestUnshareShares(toUnshareList.values());
        unshareOp.run((IProgressMonitor)progress.newChild(80));
        LocalChangeManager.getInstance().refreshChanges(toUnshareList.values().toArray(new IShare[toUnshareList.size()]), ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, (IProgressMonitor)progress.newChild(10));
        progress.setWorkRemaining(toUnmapList.size());
        for (IResource resource : toUnmapList) {
            try {
                if (!(resource instanceof IProject)) continue;
                ApoRepositoryProvider.unmap((IProject)((IProject)resource), (IProgressMonitor)progress.newChild(1));
            }
            catch (TeamException e) {
                problems.reportException((Throwable)e);
            }
        }
    }

    public static boolean promptDeleteNestedShareRoots(final Shell shell, IShareable[] shares) throws FileSystemException {
        if (!CopyFileAreaUtil.hasNestedShareRoots((IShareable[])shares)) {
            return true;
        }
        final TreeSet<String> allnested = new TreeSet<String>();
        IShareable[] iShareableArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable share = iShareableArray[n2];
            for (IShare inner : CopyFileAreaUtil.getNestedShares((IShareable)share)) {
                allnested.add(inner.getPath() + " (" + inner.getSharingDescriptor().getComponentName() + ")");
            }
            ++n2;
        }
        if (allnested.size() == 0) {
            return true;
        }
        final boolean[] unshareAll = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String dialogText = NLS.bind((String)Messages.UnloadAction_NestedChildrenText, (Object)(allnested.size() == 2 ? Messages.UnloadAction_NestedChildrenBoth : String.valueOf(Messages.UnloadAction_NestedChildrenAll) + ' ' + allnested.size()));
                ListDetailsDialog dialog = new ListDetailsDialog(shell, Messages.UnloadAction_NestedChildrenTitle, dialogText, 1, DetailsDialog.ButtonBar.YesNoDetails, allnested);
                dialog.setDefaultButtonId(3);
                dialog.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

                    public void updateLabel(ViewerLabel label, Object element) {
                        label.setText(element.toString());
                    }
                });
                unshareAll[0] = 2 == dialog.open();
            }
        });
        return unshareAll[0];
    }
}

