/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUnShareUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UnShareAction
extends CommonAction {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final IShareable[] shareables = this.extractShareables(selection.toArray());
        String message = shareables.length > 1 ? Messages.UnShareAction_2 : Messages.UnShareAction_1;
        IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean("pref_prompt_disconnect_project");
        boolean proceed = true;
        if (prompt) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)Messages.UnShareAction_0, (String)message, (String)Messages.UnShareAction_3, (boolean)false, null, null);
            if (dialog.getReturnCode() != 0) {
                proceed = false;
            } else {
                store.setValue("pref_prompt_disconnect_project", !dialog.getToggleState());
            }
        }
        if (proceed) {
            this.getOperationRunner().enqueue(Messages.UnShareAction_DisconnectingProjects, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    UnShareAction.this.unshare(shareables, monitor, problems, shell);
                }
            });
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            IShareable[] shareables = this.extractShareables(((IStructuredSelection)selection).toArray());
            action.setEnabled(shareables.length > 0);
        }
    }

    private void unshare(IShareable[] shareables, IProgressMonitor monitor, IStatusCollector problems, Shell shell) throws FileSystemException, TeamRepositoryException {
        ArrayList<IShare> toUnshareList = new ArrayList<IShare>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subProgress = progress.newChild(1).setWorkRemaining(shareables.length);
        IShareable[] iShareableArray = shareables;
        int n = shareables.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable = iShareableArray[n2];
            IShare share = shareable.getShare((IProgressMonitor)subProgress.newChild(1));
            IRelativeLocation localPath = shareable.getLocalPath();
            if (share != null && share.getPath().segmentCount() == localPath.segmentCount()) {
                toUnshareList.add(share);
            }
            ++n2;
        }
        IUnshareOperation unshareOp = IOperationFactory.instance.getUnshareOperation((UnshareDilemmaHandler)new WarnUnShareUser(shell, Messages.UnLoadAction_UnShareOperationTitle, false), IRepositoryResolver.EXISTING_SHARED);
        unshareOp.requestUnshareShares(toUnshareList);
        unshareOp.run((IProgressMonitor)progress.newChild(80));
        if (toUnshareList.size() != shareables.length) {
            problems.reportProblem((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", Messages.UnShareAction_6));
        }
    }
}

