/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.operations.IMetadataSynchronizeOperation;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SynchronizeAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final Object[] resources = selection.toArray();
        this.getOperationRunner().enqueue(Messages.SynchronizeAction_SynchronizingProjectsJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) {
                ArrayList<IShare> shares = new ArrayList<IShare>(resources.length);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                SubMonitor subProgress = progress.newChild(1).setWorkRemaining(resources.length);
                Object[] objectArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    try {
                        IShare share = ((IShareable)((IResource)o).getAdapter(IShareable.class)).getShare((IProgressMonitor)subProgress.newChild(1));
                        if (share != null) {
                            shares.add(share);
                        }
                    }
                    catch (FileSystemException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                    ++n2;
                }
                progress.setWorkRemaining(shares.size());
                for (IShare share : shares) {
                    progress.subTask(NLS.bind((String)Messages.SynchronizeAction_SynchronizingProgressName, (Object)share.getPath()));
                    try {
                        IMetadataSynchronizeOperation synchronizeOperation = IOperationFactory.instance.getMetadataSynchronizeOperation(IRepositoryResolver.EXISTING_SHARED);
                        synchronizeOperation.synchronizeRequest(share, null);
                        synchronizeOperation.run((IProgressMonitor)progress.newChild(1));
                    }
                    catch (Exception e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                }
                progress.done();
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            action.setEnabled(!sel.isEmpty());
        }
    }
}

