/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.core.SharingMetadataFactory;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ShowInSystemExplorerAction
extends AbstractActionDelegate {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        final Object obj = selection.getFirstElement();
        RepositoryOperation operation = new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                try {
                    Set sandboxes = null;
                    if (obj instanceof ComponentSyncContext) {
                        ComponentSyncContext context = (ComponentSyncContext)obj;
                        sandboxes = ShowInSystemExplorerAction.this.getSandboxes(context.getOutgoingTeamPlace(), (IComponentHandle)context.getComponent(), monitor);
                    } else if (obj instanceof WorkspaceSyncContext) {
                        WorkspaceSyncContext context = (WorkspaceSyncContext)obj;
                        sandboxes = ShowInSystemExplorerAction.this.getSandboxes(context, monitor);
                    } else if (obj instanceof ContributorPlaceWrapper) {
                        ContributorPlaceWrapper context = (ContributorPlaceWrapper)((Object)obj);
                        sandboxes = ShowInSystemExplorerAction.this.getSandboxes(context, monitor);
                    } else if (obj instanceof ContributorPlaceComponentWrapper) {
                        ContributorPlaceComponentWrapper context = (ContributorPlaceComponentWrapper)obj;
                        sandboxes = ShowInSystemExplorerAction.this.getSandboxes(context.getWorkspaceConnection(), (IComponentHandle)context.getComponent(), monitor);
                    }
                    if (sandboxes == null || sandboxes.size() == 0) {
                        ShowInSystemExplorerAction.this.showNotLoadedMessage(shell);
                        return;
                    }
                    if (sandboxes.size() > 1) {
                        sandboxes = ShowInSystemExplorerAction.this.promptForSandboxes(shell, sandboxes);
                    }
                    ShowInSystemExplorerAction.this.openSandboxes(shell, sandboxes);
                }
                catch (FileSystemException e) {
                    problems.reportException((Throwable)e);
                }
                catch (IOException e) {
                    problems.reportException((Throwable)e);
                }
            }
        };
        this.getOperationRunner().enqueue(Messages.ShowInSystemExplorerAction_OperationName, (Operation)operation);
    }

    private void showNotLoadedMessage(final Shell shell) {
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)Messages.ShowInSystemExplorerAction_NoSandboxesMessageTitle, (String)Messages.ShowInSystemExplorerAction_NoSandboxesMessageText);
            }
        });
    }

    private Set<String> promptForSandboxes(final Shell shell, final Set<String> sandboxes) {
        final Object[][] selectedSandboxes = new Object[1][];
        HashSet<String> result = new HashSet<String>();
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                BaseLabelProvider labelProvider = new BaseLabelProvider(){

                    public void updateLabel(ViewerLabel label, Object element) {
                        label.setText((String)element);
                    }
                };
                ListSelectionDialog dialog = new ListSelectionDialog(shell, (Object)sandboxes.toArray(), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, Messages.ShowInSystemExplorerAction_PickerMessage);
                dialog.setTitle(Messages.ShowInSystemExplorerAction_PickerTitle);
                dialog.setBlockOnOpen(true);
                dialog.setHelpAvailable(false);
                dialog.open();
                selectedSandboxes[0] = dialog.getResult();
            }
        });
        if (selectedSandboxes[0] != null) {
            int i = 0;
            while (i < selectedSandboxes[0].length) {
                result.add((String)selectedSandboxes[0][i]);
                ++i;
            }
        }
        return result;
    }

    private Set<String> getSandboxes(IWorkspaceConnection workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<String> result = new HashSet<String>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        workspace.refresh((IProgressMonitor)progress.newChild(10));
        List components = workspace.getComponents();
        SubMonitor loopProgress = progress.newChild(90).setWorkRemaining(components.size());
        for (Object componentHandle : components) {
            Set<String> sandboxes = this.getSandboxes(workspace, (IComponentHandle)componentHandle, (IProgressMonitor)loopProgress);
            result.addAll(sandboxes);
        }
        return result;
    }

    private Set<String> getSandboxes(ContributorPlaceWrapper wrapper, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IWorkspaceConnection connection = wrapper.getWorkspaceConnection((IProgressMonitor)progress.newChild(10), true);
        return this.getSandboxes(connection, (IProgressMonitor)progress.newChild(90));
    }

    private Set<String> getSandboxes(IWorkspaceConnection workspaceConnection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        HashSet<String> result = new HashSet<String>();
        Collection sandboxes = FileSystemCore.getSharingManager().getSandboxes(new ConfigurationFacade((IConnection)workspaceConnection, component), monitor);
        for (ISandbox sandbox : sandboxes) {
            result.add(sandbox.getRoot().toOSString());
        }
        return result;
    }

    private Set<String> getSandboxes(WorkspaceSyncContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection workspaceConnection = context.getLocal();
        return this.getSandboxes(workspaceConnection, monitor);
    }

    private void openSandboxes(Shell shell, Set<String> sandboxes) throws IOException {
        for (String sandboxPath : sandboxes) {
            String command = this.getCommand(sandboxPath);
            if (command == null) {
                this.showPreferenceError(shell);
                return;
            }
            try {
                Process process = Util.isLinux() || Util.isMac() ? Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command}) : Runtime.getRuntime().exec(command);
                int exitCode = process.waitFor();
                if (Util.isWindows() || exitCode == 0) continue;
                this.showExecutionError(shell);
                return;
            }
            catch (Exception e) {
                this.showExecutionError(shell);
            }
        }
    }

    private void showExecutionError(final Shell shell) {
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)Messages.ShowInSystemExplorerAction_PreferenceErrorTitle, (String)Messages.ShowInSystemExplorerAction_ExecutionErrorText);
            }
        });
    }

    private void showPreferenceError(final Shell shell) {
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)Messages.ShowInSystemExplorerAction_PreferenceErrorTitle, (String)Messages.ShowInSystemExplorerAction_PreferenceErrorText);
            }
        });
    }

    private String getCommand(String path) {
        String pathUri = new File(path).toURI().toString();
        String[] stringArray = SharingMetadataFactory.SUPPORTED_METADATA_FOLDERS;
        int n = SharingMetadataFactory.SUPPORTED_METADATA_FOLDERS.length;
        int n2 = 0;
        while (n2 < n) {
            String rootFile = stringArray[n2];
            File metaDataDirectory = new File(path, rootFile);
            if (metaDataDirectory.exists()) {
                path = metaDataDirectory.getAbsolutePath();
                pathUri = metaDataDirectory.toURI().toString();
                break;
            }
            ++n2;
        }
        IPreferenceStore eclipsePrefStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String command = eclipsePrefStore.getString("SYSTEM_EXPLORER");
        String result = Util.replaceAll((String)command, (String)"${selected_resource_loc}", (String)this.quotePath(path));
        result = Util.replaceAll((String)result, (String)"${selected_resource_uri}", (String)this.quotePath(pathUri));
        if (result.equals(command)) {
            return null;
        }
        return result;
    }

    private String quotePath(String path) {
        if (Util.isLinux() || Util.isMac()) {
            path = path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }
}

