/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RenameShareRootAction
extends CommonAction {
    private static final char[] INVALID_CHARACTERS = new char[]{'\\', ':', '/'};

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IShareable[] shareables = this.extractShareables(selection.toArray());
        if (shareables.length != 1) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.RenameShareRootAction_RenameDialogTitle, (String)Messages.RenameShareRootAction_CannotRenameDialogMessage);
            return;
        }
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IShareable shareable = shareables[0];
        final String oldName = shareable.getLocalPath().getName();
        IResource resourceAdapter = (IResource)shareable.getAdapter(IResource.class);
        final boolean isProject = resourceAdapter != null && resourceAdapter.getType() == 4;
        InputDialog input = new InputDialog(shell, Messages.RenameShareRootAction_RenameDialogTitle, Messages.RenameShareRootAction_NewNameLabel, oldName, new IInputValidator(){

            public String isValid(String newText) {
                IStatus nameStatus = workspace.validateName(newText, 4);
                if (!nameStatus.isOK()) {
                    return nameStatus.getMessage();
                }
                int i = 0;
                while (i < INVALID_CHARACTERS.length) {
                    int index = newText.indexOf(INVALID_CHARACTERS[i]);
                    if (index >= 0) {
                        String message = NLS.bind((String)Messages.RenameShareRootAction_BackslashInvalidCharacter, (Object)Character.valueOf(INVALID_CHARACTERS[i]), (Object)newText);
                        return message;
                    }
                    ++i;
                }
                return null;
            }
        });
        final String[] desiredName = new String[1];
        if (input.open() == 0) {
            desiredName[0] = input.getValue();
        }
        if (desiredName[0] == null) {
            return;
        }
        this.runOnSelection(selection, new CommonAction.ITeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection teamPlace, Object[] selection, IProgressMonitor monitor) {
                Map shareablesByComponent;
                IShareable[] shareables = RenameShareRootAction.this.extractShareables(selection);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    shareablesByComponent = RenameShareRootAction.this.partitionByComponent(shareables, (IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemException e) {
                    throw TempHelper.throwEx((TeamRepositoryException)((Object)e));
                }
                final WarnCommitUser problemHandler = new WarnCommitUser(shell, RenameShareRootAction.this.getOperationName());
                HashMap<String, IShare> toVerify = new HashMap<String, IShare>();
                SubMonitor subProgress = progress.newChild(1).setWorkRemaining(shareables.length);
                for (Map.Entry entry : shareablesByComponent.entrySet()) {
                    IShareable[] toRename = (IShareable[])entry.getValue();
                    try {
                        int j = 0;
                        while (j < toRename.length) {
                            IShareable shareable = toRename[j];
                            IShare share = shareable.getShare((IProgressMonitor)subProgress.newChild(1));
                            if (share != null) {
                                if (!share.getShareable().equals(shareable)) {
                                    String path = RenameShareRootAction.getPathString(shareable);
                                    return StatusUtil.newStatus((Object)this, (String)NLS.bind((String)Messages.RenameShareRootAction_0, (Object)path));
                                }
                                toVerify.put(share.getPath().toString(), share);
                            }
                            ++j;
                        }
                    }
                    catch (FileSystemException e) {
                        TempHelper.throwEx((TeamRepositoryException)((Object)e));
                    }
                }
                try {
                    IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(problemHandler.getOutOfSyncDilemmaHandler());
                    verifyOp.addToVerify((IConnection)teamPlace, toVerify.values());
                    verifyOp.run((IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                UpdateDilemmaHandler ignoreSyncs = new UpdateDilemmaHandler(){

                    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                        return new OutOfSyncDilemmaHandler(){

                            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                                return 0;
                            }

                            public boolean willIgnoreAllSharesOutOfSync() {
                                return true;
                            }

                            public BackupDilemmaHandler getBackupDilemmaHandler() {
                                return problemHandler.getBackupDilemmaHandler();
                            }
                        };
                    }

                    public BackupDilemmaHandler getBackupDilemmaHandler() {
                        return problemHandler.getBackupDilemmaHandler();
                    }
                };
                progress.setWorkRemaining(shareables.length);
                for (Map.Entry entry : shareablesByComponent.entrySet()) {
                    IComponentHandle component = (IComponentHandle)entry.getKey();
                    IShareable[] toRename = (IShareable[])entry.getValue();
                    SubMonitor iterProgress = progress.newChild(toRename.length).setWorkRemaining(100);
                    try {
                        ArrayList<IVersionableHandle> versionables = new ArrayList<IVersionableHandle>(toRename.length);
                        ArrayList<IShare> shares = new ArrayList<IShare>(toRename.length);
                        SubMonitor subIterProgress = iterProgress.newChild(5).setWorkRemaining(toRename.length);
                        int j = 0;
                        while (j < toRename.length) {
                            IShare share = toRename[j].getShare((IProgressMonitor)subIterProgress.newChild(1));
                            shares.add(share);
                            versionables.add(share.getSharingDescriptor().getRootVersionable());
                            ++j;
                        }
                        ArrayList<IWorkspaceConnection.ISaveOp> configOps = new ArrayList<IWorkspaceConnection.ISaveOp>(toRename.length);
                        List items = teamPlace.configuration(component).fetchCompleteItems(versionables, (IProgressMonitor)iterProgress.newChild(15));
                        for (IVersionable itemToRename : items) {
                            if (itemToRename == null) continue;
                            itemToRename = (IVersionable)itemToRename.getWorkingCopy();
                            itemToRename.setName(desiredName[0]);
                            configOps.add(teamPlace.configurationOpFactory().save(itemToRename));
                        }
                        IChangeSetHandle changeSet = teamPlace.getCurrentChangeSet(component);
                        if (changeSet == null) {
                            String message = isProject ? NLS.bind((String)Messages.RenameShareRootAction_RenameProjectMessage, (Object)oldName, (Object)desiredName[0]) : NLS.bind((String)Messages.RenameShareRootAction_RenameShareRootMessage, (Object)oldName, (Object)desiredName[0]);
                            changeSet = teamPlace.createChangeSet(component, message, true, (IProgressMonitor)iterProgress.newChild(15));
                        }
                        iterProgress.setWorkRemaining(65);
                        IUpdateReport report = teamPlace.commit(changeSet, configOps, (IProgressMonitor)iterProgress.newChild(30));
                        new UpdateOperation(teamPlace, Collections.singletonList(report), 3, ignoreSyncs, null).run((IProgressMonitor)iterProgress.newChild(35));
                    }
                    catch (FileSystemException e) {
                        return StatusUtil.newStatus((Object)this, (Throwable)e);
                    }
                    catch (TeamRepositoryException e) {
                        return StatusUtil.newStatus((Object)this, (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            action.setEnabled(((IStructuredSelection)selection).size() == 1);
            return;
        }
        action.setEnabled(false);
    }

    @Override
    protected String getOperationName() {
        return Messages.RenameShareRootAction_RenamingShareRootInRepositoryJobName;
    }

    protected static String getPathString(IShareable shareable) {
        String path;
        Object resource = shareable.getAdapter(IResource.class);
        if (resource instanceof IResource) {
            IResource r = (IResource)resource;
            path = r.getFullPath().toString();
        } else {
            path = shareable.getFullPath().toOSString();
        }
        return path;
    }
}

