/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.ui.actions.RemoveChangeRequestAction;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RemoveChangeSetChangeRequestsAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        List<ChangeSetWrapper> changeSets = AdapterUtil.adaptList(ss.toList(), ChangeSetWrapper.class);
        this.removeLinks(this.getContext(), changeSets);
    }

    void removeLinks(final UIContext context, final List<ChangeSetWrapper> changeSets) {
        if (!MessageDialog.openQuestion((Shell)context.getShell(), (String)Messages.RemoveChangeSetChangeRequestsAction_0, (String)Messages.RemoveChangeSetChangeRequestsAction_1)) {
            return;
        }
        context.getUserOperationRunner().enqueue(Messages.RemoveChangeSetChangeRequestsAction_2, new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changeSets.size());
                ArrayList<ILink> allLinks = new ArrayList<ILink>();
                try {
                    for (ChangeSetWrapper wrapper : changeSets) {
                        ITeamRepository repo = wrapper.getRepository();
                        List links = OslcLinkUtil.fetchScmOslcLinks((ITeamRepository)repo, Collections.singletonList(wrapper.getChangeSet()), (IProgressMonitor)progress.newChild(1));
                        allLinks.addAll(links);
                    }
                    if (allLinks.isEmpty()) {
                        JFaceUtils.showMessage((String)Messages.RemoveChangeSetChangeRequestsAction_3, (String)Messages.RemoveChangeSetChangeRequestsAction_4, (int)0);
                    } else {
                        RemoveChangeRequestAction.removeOslcLinks(context, allLinks);
                    }
                }
                catch (TeamRepositoryException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (String)"Problems removing change requests", (Throwable)e));
                }
            }
        });
    }

    public static List<ILink> removeOslcCMBackLinks(ITeamRepository repo, List<ILink> links, IChangeSetHandle changeSet, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)links.size());
        ArrayList<ILink> failed = new ArrayList<ILink>();
        for (ILink link : links) {
            IReference reference = link.getTargetRef();
            if (!reference.isURIReference()) {
                throw new IllegalArgumentException();
            }
            IURIReference ref = (IURIReference)reference;
            URI uri = ref.getURI();
            ITeamRepository uriRepo = null;
            try {
                uriRepo = OslcLinkUtil.deserializeExtraInfo((String)ref.getExtraInfo(), (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                OslcLinkUtil.removeOslcCMBacklink((ITeamRepository)repo, (IChangeSetHandle)changeSet, (ITeamRepository)uriRepo, (URI)uri, (IProgressMonitor)progress.newChild(1));
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log(RemoveChangeSetChangeRequestsAction.class, (Throwable)e);
                failed.add(link);
            }
        }
        return failed;
    }
}

