/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.rcp.core.internal.oslc.OslcLinkWrapper;
import com.ibm.team.filesystem.ui.actions.RemoveChangeSetChangeRequestsAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class RemoveChangeRequestAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        this.removeLinks(this.getContext(), ss.toList());
    }

    void removeLinks(UIContext context, List<OslcLinkWrapper> wrappers) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        for (OslcLinkWrapper wrapper : wrappers) {
            links.add(wrapper.getLink());
        }
        RemoveChangeRequestAction.removeOslcLinks(context, links);
    }

    public static void removeOslcLinks(final UIContext context, final List<ILink> links) {
        if (!MessageDialog.openQuestion((Shell)context.getShell(), (String)Messages.RemoveChangeSetChangeRequestsAction_0, (String)Messages.RemoveChangeSetChangeRequestsAction_1)) {
            return;
        }
        context.getUserOperationRunner().enqueue(Messages.RemoveChangeSetChangeRequestsAction_2, new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                ITeamRepository repo;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)links.size());
                if (links.size() == 0) {
                    JFaceUtils.showMessage((String)Messages.RemoveChangeSetChangeRequestsAction_3, (String)Messages.RemoveChangeSetChangeRequestsAction_4, (int)0);
                    return;
                }
                final ArrayList<ILink> backLinkFailures = new ArrayList<ILink>();
                final ArrayList<ILink> backLinkSuccess = new ArrayList<ILink>();
                for (ILink link : links) {
                    if (!link.getLinkTypeId().equals("com.ibm.team.filesystem.oslc_cm.change_request.change_set")) continue;
                    repo = (ITeamRepository)link.getOrigin();
                    IChangeSetHandle changeSet = (IChangeSetHandle)((IItemReference)link.getSourceRef()).getReferencedItem();
                    List<ILink> failed = RemoveChangeSetChangeRequestsAction.removeOslcCMBackLinks(repo, Collections.singletonList(link), changeSet, (IProgressMonitor)progress.newChild(1));
                    if (!failed.isEmpty()) {
                        backLinkFailures.addAll(failed);
                        continue;
                    }
                    backLinkSuccess.add(link);
                }
                if (!backLinkFailures.isEmpty()) {
                    new UIJob(context.getDisplay(), Messages.RemoveChangeRequestAction_0){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MessageBox dialog = new MessageBox(context.getShell(), 296);
                            dialog.setText(Messages.RemoveChangeRequestAction_1);
                            dialog.setMessage(Messages.RemoveChangeRequestAction_2);
                            final List toLink = backLinkSuccess;
                            if (dialog.open() == 32) {
                                toLink.addAll(backLinkFailures);
                            }
                            if (!toLink.isEmpty()) {
                                context.getUserOperationRunner().enqueue(Messages.RemoveChangeRequestAction_3, new Operation(){

                                    public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toLink.size());
                                        for (ILink link : toLink) {
                                            ITeamRepository repo = (ITeamRepository)link.getOrigin();
                                            try {
                                                OslcLinkUtil.deleteScmOslcLinks((ITeamRepository)repo, Collections.singletonList(link), (IProgressMonitor)progress.newChild(1));
                                            }
                                            catch (TeamRepositoryException e) {
                                                problems.reportProblem(StatusUtil.newStatus((Object)this, (String)"Problems removing change requests", (Throwable)e));
                                            }
                                        }
                                    }
                                });
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                } else {
                    for (ILink link : backLinkSuccess) {
                        repo = (ITeamRepository)link.getOrigin();
                        try {
                            OslcLinkUtil.deleteScmOslcLinks((ITeamRepository)repo, Collections.singletonList(link), (IProgressMonitor)progress.newChild(1));
                        }
                        catch (TeamRepositoryException e) {
                            problems.reportProblem(StatusUtil.newStatus((Object)this, (String)"Problems removing change requests", (Throwable)e));
                        }
                    }
                }
            }
        });
    }
}

