/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenChangeSetReasonsAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        List<ChangeSetInContextWrapper> changeSets = AdapterUtil.adaptList(ss.toList(), ChangeSetInContextWrapper.class);
        ArrayList wrappers = NewCollection.arrayList();
        for (ChangeSetInContextWrapper next : changeSets) {
            wrappers.add(next);
        }
        if (wrappers.isEmpty()) {
            wrappers.addAll(AdapterUtil.adaptList(ss.toList(), ChangeSetWrapper.class));
        }
        this.openLinks(this.getContext(), wrappers);
    }

    private void openLinks(UIContext context, final List<ChangeSetWrapper> changeSets) {
        HashSet<ITeamRepository> repos = new HashSet<ITeamRepository>();
        for (ChangeSetWrapper changeSet : changeSets) {
            ITeamRepository repo = changeSet.getRepository();
            if (repo == null) continue;
            repos.add(repo);
        }
        context.getUserOperationRunner().enqueue(Messages.OpenChangeSetReasonsAction_OpeningWorkItemsJobName, (Operation)new RepositoryOperation(repos){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changeSets.size());
                    ArrayList reasonReferences = new ArrayList();
                    for (ChangeSetWrapper wrapper : changeSets) {
                        ProviderFactory factory = (ProviderFactory)SCMPlatform.getClientLibrary((IItemHandle)wrapper.getChangeSet(), ProviderFactory.class);
                        List links = ChangeSetLinks.findLinks((ProviderFactory)factory, (IChangeSetHandle)wrapper.getChangeSet(), (String[])new String[]{"com.ibm.team.filesystem.workitems.change_set", "com.ibm.team.filesystem.oslc_cm.change_request.change_set"}, (IProgressMonitor)progress.newChild(1));
                        reasonReferences.addAll(links);
                    }
                    if (reasonReferences.isEmpty()) {
                        JFaceUtils.showMessage((String)Messages.OpenChangeSetReasonsAction_NothingToShowMessageTitle, (String)Messages.OpenChangeSetReasonsAction_NoWorkItemsMessage, (int)0);
                        return;
                    }
                    for (ILink reference : reasonReferences) {
                        ITeamRepository repo = (ITeamRepository)reference.getOrigin();
                        URI uri = OpenChangeSetReasonsAction.this.createURI(repo.getRepositoryURI(), reference);
                        if (uri == null) continue;
                        URI context = Location.itemLocation((IItemHandle)reference, (String)repo.getRepositoryURI()).toAbsoluteUri();
                        Hyperlinks.open((URI)uri, (ContextProvider)new StandardContextProvider(null, new URIReference("context", "", context)), (IProgressMonitor)monitor);
                    }
                }
                catch (TeamRepositoryException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)((Object)this), (String)"Problems opening work items", (Throwable)e));
                }
            }
        });
    }

    private URI createURI(String repositoryURI, ILink link) throws IllegalStateException, TeamRepositoryException {
        IReference reference = link.getTargetRef();
        URI other = null;
        if (reference.isURIReference()) {
            other = ((IURIReference)reference).getURI();
        } else if (reference.isItemReference()) {
            other = ((IItemReference)reference).createURI();
        }
        return other;
    }
}

