/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenChangeSetChangeRequestsAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        List<ChangeSetInContextWrapper> changeSets = AdapterUtil.adaptList(ss.toList(), ChangeSetInContextWrapper.class);
        this.openLinks(this.getContext(), changeSets);
    }

    private void openLinks(UIContext context, final List<ChangeSetInContextWrapper> changeSets) {
        context.getUserOperationRunner().enqueue(Messages.OpenChangeSetChangeRequestsAction_1, new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * changeSets.size()));
                ArrayList<URI> uris = new ArrayList<URI>();
                try {
                    for (ChangeSetInContextWrapper wrapper : changeSets) {
                        ITeamRepository repo = wrapper.getRepository();
                        List links = OslcLinkUtil.fetchScmOslcLinks((ITeamRepository)repo, Collections.singletonList(wrapper.getChangeSet()), (IProgressMonitor)progress.newChild(1));
                        for (ILink link : links) {
                            IReference ref = link.getTargetRef();
                            if (!ref.isURIReference()) continue;
                            IURIReference uriRef = (IURIReference)ref;
                            uris.add(uriRef.createURI());
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    problems.reportProblem(StatusUtil.newStatus((Object)this, (String)"Problems removing change requests", (Throwable)e));
                }
                if (uris.isEmpty()) {
                    JFaceUtils.showMessage((String)Messages.OpenChangeSetReasonsAction_NothingToShowMessageTitle, (String)Messages.OpenChangeSetChangeRequestsAction_0, (int)0);
                    return;
                }
                progress.setWorkRemaining(100);
                Hyperlinks.open(uris, (ContextProvider)new StandardContextProvider(null), (IProgressMonitor)progress.newChild(100));
            }
        });
    }
}

