/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.IMoveVersionablesOperation;
import com.ibm.team.filesystem.client.operations.MoveVersionablesDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.views.SimplePartInput;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPicker;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerInput;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.internal.filesystem.ui.util.WarnMoveFoldersUser;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class MoveInRepositoryAction
extends CommonAction {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        this.runOnSelection(selection, new CommonAction.ITeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection workspaceConnection, Object[] selection, IProgressMonitor monitor) {
                Map shareables;
                IShareable[] allShareables;
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MoveShareRootAction_MovingShareRoots, (int)100);
                HashSet<ISandbox> allSandboxes = new HashSet<ISandbox>();
                IShareable[] iShareableArray = allShareables = MoveInRepositoryAction.this.extractShareables(selection);
                int n = allShareables.length;
                int n2 = 0;
                while (n2 < n) {
                    IShareable shareable = iShareableArray[n2];
                    allSandboxes.add(shareable.getSandbox());
                    ++n2;
                }
                try {
                    shareables = MoveInRepositoryAction.this.partitionByComponent(allShareables, (IProgressMonitor)sub.newChild(1));
                }
                catch (FileSystemException e) {
                    throw TempHelper.throwEx((TeamRepositoryException)((Object)e));
                }
                HashMap<IComponentHandle, IVersionableHandle[]> handles = new HashMap<IComponentHandle, IVersionableHandle[]>();
                HashMap<IComponentHandle, String> componentNames = new HashMap<IComponentHandle, String>();
                HashMap<UUID, String> itemNames = new HashMap<UUID, String>();
                HashSet<UUID> filterUUIDs = new HashSet<UUID>();
                HashSet<UUID> shareRoots = new HashSet<UUID>();
                sub.setWorkRemaining(allShareables.length + shareables.size() + 99);
                for (Map.Entry entry : shareables.entrySet()) {
                    IShareable shareable;
                    ArrayList<IVersionableHandle> items = new ArrayList<IVersionableHandle>(((IShareable[])entry.getValue()).length);
                    IShareable[] iShareableArray2 = (IShareable[])entry.getValue();
                    int n3 = iShareableArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        shareable = iShareableArray2[n4];
                        try {
                            IVersionableHandle handle = shareable.getVersionable((IProgressMonitor)sub.newChild(1));
                            items.add(handle);
                            UUID uuid = handle.getItemId();
                            filterUUIDs.add(uuid);
                            itemNames.put(uuid, shareable.getLocalPath().getName());
                            IShare share = shareable.getShare((IProgressMonitor)sub.newChild(1));
                            if (share != null && share.getShareable().equals(shareable)) {
                                shareRoots.add(uuid);
                            }
                        }
                        catch (FileSystemException e) {
                            TempHelper.throwEx((TeamRepositoryException)((Object)e));
                        }
                        ++n4;
                    }
                    handles.put((IComponentHandle)entry.getKey(), items.toArray(new IVersionableHandle[items.size()]));
                    shareable = ((IShareable[])entry.getValue())[0];
                    try {
                        ISharingDescriptor sharingDescriptor = shareable.getShare((IProgressMonitor)sub.newChild(1)).getSharingDescriptor();
                        String componentName = sharingDescriptor.getComponentName();
                        componentNames.put((IComponentHandle)entry.getKey(), componentName);
                    }
                    catch (FileSystemException e) {
                        TempHelper.throwEx((TeamRepositoryException)((Object)e));
                    }
                }
                if (!shareRoots.isEmpty()) {
                    try {
                        IShare[] shares;
                        IShare[] e = shares = SharingManager.getInstance().allShares((IProgressMonitor)sub.newChild(1));
                        int shareable = shares.length;
                        int items = 0;
                        while (items < shareable) {
                            IShare share = e[items];
                            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                            if (sharingDescriptor.isAssociatedWithConnection((IConnection)workspaceConnection)) {
                                filterUUIDs.add(sharingDescriptor.getRootVersionable().getItemId());
                            }
                            ++items;
                        }
                    }
                    catch (FileSystemException shares) {
                        // empty catch block
                    }
                }
                IFolderHandle[] targetHandle = new IFolderHandle[1];
                IComponentHandle[] targetComponent = new IComponentHandle[1];
                final String[] targetComponentName = new String[1];
                try {
                    MoveInRepositoryAction.pickComponent(shell, workspaceConnection, filterUUIDs, targetHandle, targetComponent, targetComponentName, (IProgressMonitor)sub.newChild(9));
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                if (targetHandle[0] == null) {
                    return Status.CANCEL_STATUS;
                }
                IMoveVersionablesOperation moveOp = IOperationFactory.instance.getMoveVersionablesOperation((MoveVersionablesDilemmaHandler)new WarnMoveFoldersUser(shell, Messages.MoveShareRootAction_Dilemma));
                HashSet<UUID> loadedComponents = null;
                final TreeSet<UUID> itemsToDelete = new TreeSet<UUID>();
                for (Map.Entry entry : handles.entrySet()) {
                    String sourceComment;
                    IComponentHandle sourceComponent = (IComponentHandle)entry.getKey();
                    IVersionableHandle[] itemsToMove = (IVersionableHandle[])entry.getValue();
                    String projectsDesc = itemsToMove.length == 1 ? (itemsToMove[0] instanceof IFolderHandle ? NLS.bind((String)Messages.MoveInRepositoryAction_0, itemNames.get(itemsToMove[0].getItemId())) : NLS.bind((String)Messages.MoveInRepositoryAction_1, itemNames.get(itemsToMove[0].getItemId()))) : NLS.bind((String)Messages.MoveInRepositoryAction_2, (Object)itemsToMove.length);
                    IFolderHandle[] targetHandles = new IFolderHandle[itemsToMove.length];
                    int i = 0;
                    while (i < targetHandles.length) {
                        targetHandles[i] = targetHandle[0];
                        ++i;
                    }
                    if (targetComponent[0].sameItemId((IItemHandle)sourceComponent)) {
                        sourceComment = NLS.bind((String)Messages.MoveShareRootAction_MoveWithinComponent, (Object)projectsDesc);
                        moveOp.addMoveWithinComponentRequest(workspaceConnection, sourceComponent, itemsToMove, targetHandles, sourceComment);
                        continue;
                    }
                    if (loadedComponents == null) {
                        loadedComponents = new HashSet<UUID>();
                        for (ISandbox sandbox : allSandboxes) {
                            try {
                                for (LoadedConfigurationDescriptor config : sandbox.allLoadedConfigurations(null)) {
                                    loadedComponents.add(config.getComponentHandle().getItemId());
                                }
                            }
                            catch (FileSystemException e) {
                                Status result = new Status(4, "com.ibm.team.filesystem.ide.ui", e.getMessage(), (Throwable)e);
                                StatusUtil.log((IStatus)result);
                                return result;
                            }
                        }
                    }
                    if (!loadedComponents.contains(targetComponent[0].getItemId())) {
                        IVersionableHandle[] iVersionableHandleArray = itemsToMove;
                        int n5 = itemsToMove.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IVersionableHandle item = iVersionableHandleArray[n6];
                            if (shareRoots.contains(item.getItemId())) {
                                itemsToDelete.add(item.getItemId());
                            }
                            ++n6;
                        }
                    }
                    sourceComment = NLS.bind((String)Messages.EditWorkspaceOperation_moveSrcComment, (Object)projectsDesc, (Object)targetComponentName[0]);
                    String targetComment = NLS.bind((String)Messages.EditWorkspaceOperation_moveDestComment, (Object)projectsDesc, componentNames.get(sourceComponent));
                    moveOp.addMoveVersionablesAcrossComponentRequest(workspaceConnection, sourceComponent, itemsToMove, targetComponent[0], targetHandles, sourceComment, targetComment);
                }
                try {
                    if (!itemsToDelete.isEmpty()) {
                        final boolean[] result = new boolean[]{true};
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                boolean hasNested;
                                TreeSet<String> allNested = new TreeSet<String>();
                                try {
                                    IShareable[] iShareableArray = allShareables;
                                    int n = allShareables.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IShareable shareable = iShareableArray[n2];
                                        for (IShare share : CopyFileAreaUtil.getNestedShares((IShareable)shareable)) {
                                            StringBuilder b = new StringBuilder();
                                            b.append(share.getPath());
                                            b.append(" (");
                                            b.append(share.getSharingDescriptor().getComponentName());
                                            b.append(')');
                                            allNested.add(b.toString());
                                        }
                                        ++n2;
                                    }
                                }
                                catch (FileSystemException shareable) {
                                    // empty catch block
                                }
                                int size = itemsToDelete.size();
                                boolean bl = hasNested = allNested.size() > itemsToDelete.size();
                                String dialogText = size == 1 ? (hasNested ? NLS.bind((String)Messages.MoveShareRootAction_MoveToUnloadedComponent_One_Nested, (Object)targetComponentName[0]) : NLS.bind((String)Messages.MoveShareRootAction_MoveToUnloadedComponent_One, (Object)targetComponentName[0])) : (hasNested ? NLS.bind((String)Messages.MoveShareRootAction_MoveToUnloadedComponent_Many_Nested, (Object)size, (Object)targetComponentName[0]) : NLS.bind((String)Messages.MoveShareRootAction_MoveToUnloadedComponent_Many, (Object)size, (Object)targetComponentName[0]));
                                ListDetailsDialog dialog = new ListDetailsDialog(shell, Messages.MoveShareRootAction_title, dialogText, 2, DetailsDialog.ButtonBar.OkCancelDetails, allNested);
                                dialog.setDefaultButtonId(1);
                                dialog.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

                                    public void updateLabel(ViewerLabel label, Object element) {
                                        label.setText((String)element);
                                    }
                                });
                                result[0] = dialog.open() == 0;
                            }
                        });
                        if (!result[0]) {
                            return Status.OK_STATUS;
                        }
                    }
                    moveOp.run((IProgressMonitor)sub.newChild(90));
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    protected String getOperationName() {
        return Messages.MoveShareRootAction_0;
    }

    private static void pickComponent(final Shell shell, IWorkspaceConnection teamPlace, Set<UUID> filterUUID, final IFolderHandle[] targetHandle, final IComponentHandle[] targetComponent, final String[] targetComponentName, IProgressMonitor monitor) throws TeamRepositoryException {
        List components = teamPlace.getComponents();
        HashSet<WorkspaceNamespace> namespaces = new HashSet<WorkspaceNamespace>();
        for (IComponentHandle component : components) {
            namespaces.add(WorkspaceNamespace.create((IWorkspaceConnection)teamPlace, (IComponentHandle)component));
        }
        final MovePartInput input = new MovePartInput((SnapshotId)NamespaceSetId.create((ITeamRepository)teamPlace.teamRepository(), namespaces), true, true, Messages.MoveShareRootAction_PickerMessage, false, Collections.EMPTY_SET, null, filterUUID);
        IPartResult<RepositoryFilesPickerOutput> result = new IPartResult<RepositoryFilesPickerOutput>(){

            public void setResult(RepositoryFilesPickerOutput result) {
                List<SiloedItemId> itemIds = result.getItemIds();
                if (!itemIds.isEmpty()) {
                    SiloedItemId siloedItemId = itemIds.get(0);
                    targetComponent[0] = siloedItemId.getComponentHandle();
                    targetHandle[0] = (IFolderHandle)siloedItemId.toHandle();
                } else {
                    List<WorkspaceComponentWrapper> resultComponents = result.getComponents();
                    IComponent component = resultComponents.get(0).getComponent();
                    targetComponent[0] = component;
                    targetComponentName[0] = component.getName();
                    targetHandle[0] = component.getRootFolder();
                }
            }
        };
        JFaceUtils.syncExec((Runnable)new Runnable((IPartResult)result){
            private final /* synthetic */ IPartResult val$result;
            {
                this.val$result = iPartResult;
            }

            @Override
            public void run() {
                Parts.openModalDialog((Shell)shell, new SimplePartInput(input, this.val$result), (IPartFactory)new PartFactory(RepositoryFilesMovePicker.class));
            }
        });
        if (targetComponent[0] != null) {
            if (targetComponent[0].hasFullState()) {
                targetComponentName[0] = ((IComponent)targetComponent[0].getFullState()).getName();
            } else {
                IComponent target = (IComponent)teamPlace.teamRepository().itemManager().fetchCompleteItem((IItemHandle)targetComponent[0], 0, null);
                targetComponentName[0] = target.getName();
            }
        }
    }

    private static class MovePartInput
    extends RepositoryFilesPickerInput {
        private Set<UUID> disabler;

        public MovePartInput(SnapshotId namespace, boolean foldersOnly, boolean allowComponentOutput, String message, boolean multi, Set<SiloedItemId<IVersionable>> initialSelection, IFilter filter, Set<UUID> disabler) {
            super(namespace, foldersOnly, allowComponentOutput, message, multi, initialSelection, null);
            this.disabler = disabler;
        }

        public Set<UUID> getDisabler() {
            return this.disabler;
        }
    }

    public static class RepositoryFilesMovePicker
    extends RepositoryFilesPicker {
        private Set<UUID> disabler;

        public RepositoryFilesMovePicker(IControlSite site, SimplePartInput<RepositoryFilesPickerInput, RepositoryFilesPickerOutput> newInput) {
            super(site, newInput);
            this.disabler = ((MovePartInput)newInput.getInput()).getDisabler();
        }

        @Override
        protected void updateSelection() {
            AbstractFileSystemItemWrapper overlap = null;
            TreePath[] treePathArray = this.getSelection().getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                int i = 0;
                while (i < path.getSegmentCount()) {
                    FolderItemWrapper folder;
                    Object segment = path.getSegment(i);
                    if (segment instanceof FolderItemWrapper && this.disabler.contains((folder = (FolderItemWrapper)((Object)segment)).getItem().getItemUUID())) {
                        overlap = folder;
                        break;
                    }
                    ++i;
                }
                ++n2;
            }
            if (overlap != null) {
                String name = overlap.getFQName();
                if (name != null && name.length() > 1 && name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                this.setStatus(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.MoveShareRootAction_1, (Object)name)));
                this.setOkayEnabled(false);
            } else {
                this.setStatus(Status.OK_STATUS);
                super.updateSelection();
            }
        }
    }
}

