/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ListDetailsDialog;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnCommitUser;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteProjectAction
extends CommonAction {
    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        final IShareable[] shareables = this.extractShareables(selection.toArray());
        String message = null;
        String toggleMessage = null;
        if (shareables.length == 1) {
            message = NLS.bind((String)Messages.DeleteProjectAction_WantDeleteMessage, (Object)shareables[0].getLocalPath().toString());
            toggleMessage = Messages.DeleteProjectAction_LeaveProjectMessage;
        } else {
            message = NLS.bind((String)Messages.DeleteProjectAction_DeleteProjectsMessage, (Object)shareables.length);
            toggleMessage = Messages.DeleteProjectAction_LeaveProjectsMessage;
        }
        MessageDialogWithToggle d = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.DeleteProjectAction_ConfirmDeleteMessage, (String)message, (String)toggleMessage, (boolean)false, null, null);
        int code = d.getReturnCode();
        if (code != 2) {
            return;
        }
        final boolean deleteContent = !d.getToggleState();
        try {
            TreeSet<String> nested = new TreeSet<String>();
            IShareable[] iShareableArray = shareables;
            int n = shareables.length;
            int n2 = 0;
            while (n2 < n) {
                IShareable shareable = iShareableArray[n2];
                IShare myShare = shareable.getShare(null);
                for (IShare share : CopyFileAreaUtil.getNestedShares((IShareable)shareable)) {
                    if (share.equals(myShare)) continue;
                    String componentName = share.getSharingDescriptor().getComponentName();
                    nested.add(String.valueOf(share.getPath().toString()) + " (" + componentName + ")");
                }
                ++n2;
            }
            if (nested.size() > 0) {
                String dialogText;
                String dialogTitle;
                if (deleteContent) {
                    dialogTitle = Messages.DeleteProjectAction_NestedChildrenDeleteTitle;
                    dialogText = Messages.DeleteProjectAction_NestedChildrenDeleteText;
                } else {
                    dialogTitle = Messages.DeleteProjectAction_NestedChildrenDisconnectTitle;
                    dialogText = Messages.DeleteProjectAction_NestedChildrenDisconnectText;
                }
                ListDetailsDialog dialog = new ListDetailsDialog(shell, dialogTitle, dialogText, 1, DetailsDialog.ButtonBar.YesNoDetails, nested);
                dialog.setDefaultButtonId(3);
                dialog.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

                    public void updateLabel(ViewerLabel label, Object element) {
                        label.setText(element.toString());
                    }
                });
                if (2 != dialog.open()) {
                    return;
                }
            }
        }
        catch (FileSystemException e) {
            StatusUtil.log((IStatus)StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e));
            return;
        }
        this.runOnSelection(selection, new CommonAction.ITeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection teamPlace, Object[] selection, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                WarnCommitUser problemHandler = new WarnCommitUser(shell, DeleteProjectAction.this.getOperationName());
                try {
                    IDeleteFoldersOperation op = IOperationFactory.instance.getDeleteFoldersOperation((CommitDilemmaHandler)problemHandler);
                    op.addDeleteRequest(shareables, IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)progress.newChild(25));
                    op.setDeleteContent(deleteContent);
                    op.run((IProgressMonitor)progress.newChild(75));
                }
                catch (FileSystemException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((Object)this, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    protected String getOperationName() {
        return Messages.DeleteProjectAction_DeletingProjectsJobName;
    }
}

