/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.actions;

import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.calm.foundation.common.linking.OSLCReference;
import com.ibm.team.calm.foundation.rcp.ui.linking.CALMResourcePickerDialog;
import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.ui.item.AdapterUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetInContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.process.common.IProjectLinkHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;

public class AssociateChangeSetChangeRequestAction
extends AbstractActionDelegate {
    List<ChangeSetInfo> adaptList(List elements) {
        ArrayList<ChangeSetInfo> result = new ArrayList<ChangeSetInfo>();
        List<ChangeSetInContextWrapper> wrappers = AdapterUtil.adaptList(elements, ChangeSetInContextWrapper.class);
        if (wrappers.size() == elements.size()) {
            for (ChangeSetInContextWrapper wrapper : wrappers) {
                ChangeSetInfo info = new ChangeSetInfo();
                info.changeSet = wrapper.getChangeSet();
                info.repo = wrapper.getRepository();
                info.workspace = (IWorkspaceHandle)wrapper.getNamespace().getContextHandle();
                result.add(info);
            }
        } else {
            List<ChangeSetWrapper> wrappers2 = AdapterUtil.adaptList(elements, ChangeSetWrapper.class);
            if (wrappers2.size() == elements.size()) {
                for (ChangeSetWrapper wrapper : wrappers2) {
                    ChangeSetInfo info = new ChangeSetInfo();
                    info.changeSet = wrapper.getChangeSet();
                    info.repo = wrapper.getRepository();
                    info.workspace = null;
                    result.add(info);
                }
            } else {
                for (Object element : elements) {
                    if (!(element instanceof IRemoteActivity)) continue;
                    IRemoteActivity activity = (IRemoteActivity)element;
                    ChangeSetInfo info = new ChangeSetInfo();
                    info.changeSet = activity.getChangeSetHandle();
                    info.repo = activity.getActivitySource().getTeamRepository();
                    info.workspace = (IWorkspaceHandle)activity.getActivitySource().getContextHandle();
                    result.add(info);
                }
            }
        }
        return result;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection ss) {
        final List<ChangeSetInfo> wrappers = this.adaptList(ss.toList());
        if (wrappers.size() == 0) {
            return;
        }
        ITeamRepository repo = null;
        for (ChangeSetInfo wrapper : wrappers) {
            if (repo == null) {
                repo = wrapper.repo;
            }
            if (repo.getId() == wrapper.repo.getId()) continue;
            MessageDialogFactory.showMessage((Shell)shell, (int)4, (String)Messages.AssociateChangeSetChangeRequestAction_5, (String)Messages.AssociateChangeSetChangeRequestAction_6);
            return;
        }
        final ITeamRepository sourceRepo = repo;
        final IWorkbenchWindow window = page.getWorkbenchWindow();
        String linkTypeId = "com.ibm.team.filesystem.oslc_cm.change_request.change_set";
        ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(linkTypeId);
        final CALMLinkTypeInformation targetLinkType = CALMLinkTypeInformationRegistry.getLinkTypeInformation((ILinkType)linkType);
        final List projectAreaHandles = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(sourceRepo);
        this.getOperationRunner().enqueue(Messages.AssociateChangeSetChangeRequestAction_0, (Operation)new RepositoryOperation(sourceRepo){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ArrayList<IProjectLinkHandle> projectLinkHandles = new ArrayList<IProjectLinkHandle>();
                    IFetchResult fetchResult = sourceRepo.itemManager().fetchCompleteItemsPermissionAware(projectAreaHandles, 0, (IProgressMonitor)progress.newChild(40));
                    for (Object o : fetchResult.getRetrievedItems()) {
                        if (!(o instanceof IProjectArea)) continue;
                        IProjectArea projectArea = (IProjectArea)o;
                        projectLinkHandles.addAll(Arrays.asList(projectArea.getProjectLinks()));
                    }
                    HashMap<String, ArrayList<IProjectLink>> urlToProjectLinkMap = new HashMap<String, ArrayList<IProjectLink>>();
                    if (!projectLinkHandles.isEmpty()) {
                        fetchResult = sourceRepo.itemManager().fetchCompleteItemsPermissionAware(projectLinkHandles, 0, (IProgressMonitor)progress.newChild(60));
                        for (Object o : fetchResult.getRetrievedItems()) {
                            if (!(o instanceof IProjectLink)) continue;
                            IProjectLink projectLink = (IProjectLink)o;
                            if (urlToProjectLinkMap.containsKey(projectLink.getTargetUrl())) {
                                ((List)urlToProjectLinkMap.get(projectLink.getTargetUrl())).add(projectLink);
                                continue;
                            }
                            ArrayList<IProjectLink> ipl = new ArrayList<IProjectLink>(Arrays.asList(projectLink));
                            urlToProjectLinkMap.put(projectLink.getTargetUrl(), ipl);
                        }
                    }
                    ArrayList activeProjectLinks = new ArrayList();
                    for (List iProjectLinkList : urlToProjectLinkMap.values()) {
                        activeProjectLinks.addAll(iProjectLinkList);
                    }
                    final Collection serviceProviders = targetLinkType.getServiceProviders(activeProjectLinks);
                    new UIJob(AssociateChangeSetChangeRequestAction.this.getContext().getDisplay(), Messages.AssociateChangeSetChangeRequestAction_1){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Collection references;
                            CALMResourcePickerDialog dialog = new CALMResourcePickerDialog(window, targetLinkType, sourceRepo, serviceProviders);
                            int result = dialog.open();
                            if (result == 0 && (references = dialog.getPickedReferences()) != null && !references.isEmpty()) {
                                List wrappers2 = wrappers;
                                CreateLinksInfo arg = new CreateLinksInfo();
                                for (OSLCReference reference : references) {
                                    arg.oslcURIs.add(reference.getResourceURI());
                                    arg.oslcLabels.add(reference.getLabel());
                                }
                                for (ChangeSetInfo wrapper : wrappers2) {
                                    arg.sourceChangeSets.add(wrapper.changeSet);
                                    arg.sourceRepos.add(wrapper.repo);
                                    arg.sourceWorkspaces.add(wrapper.workspace);
                                }
                                arg.targetRepo = null;
                                arg.context = AssociateChangeSetChangeRequestAction.this.getContext();
                                AssociateChangeSetChangeRequestAction.createLinks(arg);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                catch (TeamRepositoryException e) {
                    problems.reportException((Throwable)e);
                }
            }
        });
    }

    public static void createLinks(final CreateLinksInfo arg) {
        arg.context.getUserOperationRunner().enqueue(Messages.AssociateChangeSetChangeRequestAction_10, new Operation(){

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                progress1 = SubMonitor.convert((IProgressMonitor)progress, (int)arg.oslcURIs.size());
                infos = new ArrayList<OslcLinkUtil.ResourceURIInfo>();
                i = 0;
                while (i < arg.oslcURIs.size()) {
                    sourceRepo = arg.sourceRepos.get(0);
                    oslcURI = arg.oslcURIs.get(i);
                    oslcLabel = arg.oslcLabels.get(i);
                    info = new OslcLinkUtil.ResourceURIInfo();
                    info.uri = oslcURI;
                    info.label = oslcLabel;
                    info.repo = arg.targetRepo;
                    try {
                        info.repoInfo = OslcLinkUtil.fetchOslcTargetRepoInfo((ITeamRepository)sourceRepo, (URI)info.uri, (IProgressMonitor)progress1.newChild(1));
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)this, (String)("Failed to retrieve oslc repo info for " + info.uri), (Throwable)e);
                    }
                    infos.add(info);
                    ++i;
                }
                AssociateChangeSetChangeRequestAction.addRepoInformation(infos);
                i = 0;
                while (i < arg.sourceChangeSets.size()) {
                    block12: {
                        sourceRepo = arg.sourceRepos.get(i);
                        changeSet = arg.sourceChangeSets.get(i);
                        workspace = arg.sourceWorkspaces.get(i);
                        wm = SCMPlatform.getWorkspaceManager((ITeamRepository)sourceRepo);
                        resourceUris = new ArrayList<URI>();
                        comments = new ArrayList<String>();
                        extraInfos = new ArrayList<String>();
                        for (OslcLinkUtil.ResourceURIInfo info : infos) {
                            resourceUris.add(info.uri);
                            comments.add(info.label);
                            extraInfo = null;
                            if (info.repo != null) {
                                extraInfo = ChangeSetLinks.serializeExtraInfo((String)info.repo.getRepositoryURI(), (UUID)info.repo.getId());
                            } else if (info.repoInfo != null && info.repoInfo.repoId != null && info.repoInfo.repositoryURI != null) {
                                extraInfo = ChangeSetLinks.serializeExtraInfo((String)info.repoInfo.repositoryURI, (UUID)UUID.valueOf((String)info.repoInfo.repoId));
                            }
                            extraInfos.add(extraInfo);
                        }
                        try {
                            result = wm.createLinks("com.ibm.team.filesystem.oslc_cm.change_request.change_set", workspace, changeSet, resourceUris, comments, extraInfos, null, true, false, (IProgressMonitor)progress.newChild(1));
                            if (result.isBacklinksAdded()) break block12;
                            StatusUtil.log((Object)this, (String)"Failed to create change set backlink(s) for: ");
                            for (OslcLinkUtil.ResourceURIInfo info : infos) {
                                StatusUtil.log((Object)this, (String)info.uri.toString());
                            }
                            new UIJob(arg.context.getDisplay(), Messages.AssociateChangeSetChangeRequestAction_7){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    MessageBox dialog = new MessageBox(arg.context.getShell(), 296);
                                    dialog.setText(Messages.AssociateChangeSetChangeRequestAction_8);
                                    dialog.setMessage(Messages.AssociateChangeSetChangeRequestAction_9);
                                    if (dialog.open() == 32) {
                                        arg.context.getUserOperationRunner().enqueue(Messages.AssociateChangeSetChangeRequestAction_11, new Operation(){

                                            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                                try {
                                                    wm.createLinks("com.ibm.team.filesystem.oslc_cm.change_request.change_set", workspace, changeSet, resourceUris, comments, extraInfos, null, false, false, monitor);
                                                }
                                                catch (TeamRepositoryException e) {
                                                    problems.reportProblem(StatusUtil.newStatus((Object)this, (String)"Problems associating change requests", (Throwable)e));
                                                }
                                            }
                                        });
                                    }
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                            break block12;
                        }
                        catch (TeamRepositoryException e) {
                            StatusUtil.log((Object)this, (String)"Error occurred when creating links and back links", (Throwable)e);
                            ** for (info : infos)
                        }
lbl-1000:
                        // 1 sources

                        {
                            StatusUtil.log((Object)this, (String)info.uri.toString());
                            continue;
                        }
                    }
                    ++i;
                }
            }
        });
    }

    static void addRepoInformation(List<OslcLinkUtil.ResourceURIInfo> infos) {
        for (OslcLinkUtil.ResourceURIInfo info : infos) {
            if (info.repo != null) continue;
            info.repo = OslcLinkUtil.findTeamRepository((URI)info.uri);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean containsSourceChangeSet = false;
        Object[] objectArray = ((IStructuredSelection)selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ChangeSetWrapper && ((ChangeSetWrapper)((Object)o)).isSourceChangeSet()) {
                containsSourceChangeSet = true;
                break;
            }
            ++n2;
        }
        action.setEnabled(!containsSourceChangeSet);
    }

    class ChangeSetInfo {
        ITeamRepository repo;
        IChangeSetHandle changeSet;
        IWorkspaceHandle workspace;

        ChangeSetInfo() {
        }
    }

    public static class CreateLinksInfo {
        public UIContext context;
        public List<ITeamRepository> sourceRepos = new ArrayList<ITeamRepository>();
        public List<IChangeSetHandle> sourceChangeSets = new ArrayList<IChangeSetHandle>();
        public List<IWorkspaceHandle> sourceWorkspaces = new ArrayList<IWorkspaceHandle>();
        public ITeamRepository targetRepo;
        public List<URI> oslcURIs = new ArrayList<URI>();
        public List<String> oslcLabels = new ArrayList<String>();
    }
}

