/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ui.FilteringElementSelector;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ContributorPlaceLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.TeamPlaceLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.SettableSelectionProvider;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WorkspaceStreamSelector
extends FilteringElementSelector {
    public static final AbstractPlaceWrapper[] EMPTY_SELECTION = new AbstractPlaceWrapper[0];
    private static final Point PREFERRED_TOOLTIP_FOCUS_SIZE = new Point(320, 200);
    JobRunner jobRunner = new JobRunner(Messages.WorkspaceStreamSelector_UpdatingWorkspaceDialogProgressName, true);
    private Display display;
    private SettableSelectionProvider selectionProvider = new SettableSelectionProvider();
    Operation fStartupJob = new RepositoryOperation(){

        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
            List entries = null;
            if (WorkspaceStreamSelector.this.wc != null) {
                HashMap<ITeamRepository, ArrayList<IFlowNodeHandle>> requests = new HashMap<ITeamRepository, ArrayList<IFlowNodeHandle>>();
                ArrayList<IFlowEntry> flowEntries = new ArrayList<IFlowEntry>(WorkspaceStreamSelector.this.wc.getFlowTable().acceptSources());
                for (IFlowEntry entryToAdd : WorkspaceStreamSelector.this.wc.getFlowTable().deliverTargets()) {
                    boolean found = false;
                    for (IFlowEntry entry : flowEntries) {
                        if (!entryToAdd.getFlowNode().getItemId().equals((Object)entry.getFlowNode().getItemId())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    flowEntries.add(entryToAdd);
                }
                for (IFlowEntry entry : flowEntries) {
                    ArrayList<IFlowNodeHandle> toFetch;
                    ITeamRepository targetRepo = WorkspaceStreamSelector.this.repo;
                    if (entry.getRemoteRepositoryURI() != null) {
                        targetRepo = RepositoryUtils.getTeamRepository((String)entry.getRemoteRepositoryURI(), (UUID)entry.getRemoteRepositoryIdentifier());
                    }
                    if ((toFetch = (ArrayList<IFlowNodeHandle>)requests.get(targetRepo)) == null) {
                        toFetch = new ArrayList<IFlowNodeHandle>();
                        requests.put(targetRepo, toFetch);
                    }
                    toFetch.add(entry.getFlowNode());
                }
                entries = WorkspaceStreamSelector.fetchEntriesByRepo(requests, monitor);
            } else {
                List workspaceConnections = SCMPlatform.getWorkspaceManager((ITeamRepository)WorkspaceStreamSelector.this.repo).knownWorkspaceConnections();
                ArrayList<IWorkspace> workspaceHandles = new ArrayList<IWorkspace>(workspaceConnections.size());
                for (IWorkspaceConnection wc : workspaceConnections) {
                    workspaceHandles.add(wc.getResolvedWorkspace());
                }
                entries = WorkspaceStreamSelector.fetchEntries(WorkspaceStreamSelector.this.repo, workspaceHandles, monitor);
            }
            final Entry[] history = entries.toArray(new Entry[entries.size()]);
            SWTUtil.greedyExec((Display)WorkspaceStreamSelector.this.display, (Control)WorkspaceStreamSelector.this.getTable(), (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = WorkspaceStreamSelector.this.fMutex;
                    synchronized (object) {
                        (this).WorkspaceStreamSelector.this.fStartupJob = null;
                        WorkspaceStreamSelector.this.fHistory = history;
                        WorkspaceStreamSelector.super.startup();
                    }
                }
            });
        }
    };
    private WorkspaceStreamMatcher fMatcher;
    private Object fMutex = new Object();
    private FilterList fFilterList = new FilterList();
    private Entry[] fHistory = new Entry[0];
    private ITeamRepository repo;
    private IWorkspaceConnection wc;
    private WORKSPACES_OR_STREAMS workspacesOrStreams = WORKSPACES_OR_STREAMS.STREAMS;
    private String exactOwnerName = null;
    private IAuditableHandle ownerHandle = null;
    private IFilter workspaceFilter = new IFilter(){

        public boolean select(Object toTest) {
            if (WorkspaceStreamSelector.this.workspacesOrStreams == WORKSPACES_OR_STREAMS.BOTH) {
                return true;
            }
            return ((AbstractPlaceWrapper)((Object)toTest)).getWorkspace().isStream() == WorkspaceStreamSelector.this.workspacesOrStreams.isStreams();
        }
    };

    private static List<Entry> fetchEntriesByRepo(Map<ITeamRepository, List> requests, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.size());
        ArrayList<Entry> results = new ArrayList<Entry>();
        for (ITeamRepository repo : requests.keySet()) {
            List toFetch = requests.get(repo);
            try {
                List<Entry> entries = WorkspaceStreamSelector.fetchEntries(repo, toFetch, (IProgressMonitor)progress);
                results.addAll(entries);
            }
            catch (NotLoggedInException notLoggedInException) {
                // empty catch block
            }
        }
        return results;
    }

    private static List<Entry> fetchEntries(ITeamRepository repo, List workspaceHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List workspaces = repo.itemManager().fetchCompleteItems(workspaceHandles, 0, (IProgressMonitor)progress.newChild(50));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ArrayList<IAuditableHandle> ownerHandles = new ArrayList<IAuditableHandle>(workspaces.size());
        Iterator i = workspaces.iterator();
        while (i.hasNext()) {
            IWorkspace workspace = (IWorkspace)i.next();
            if (workspace == null) {
                i.remove();
                continue;
            }
            ownerHandles.add(workspace.getOwner());
        }
        List owners = repo.itemManager().fetchCompleteItems(ownerHandles, 0, (IProgressMonitor)progress.newChild(50));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        int n = workspaces.size();
        ArrayList<Entry> entries = new ArrayList<Entry>(n);
        int i2 = 0;
        while (i2 < n) {
            IWorkspace workspace = (IWorkspace)workspaces.get(i2);
            IAuditable owner = (IAuditable)owners.get(i2);
            entries.add(new Entry(AbstractPlaceWrapper.newWrapper(workspace), owner));
            ++i2;
        }
        return entries;
    }

    public WorkspaceStreamSelector(ITeamRepository repo, Composite parent, int flags, String initalPattern) {
        this(repo, null, parent, flags, initalPattern);
    }

    public WorkspaceStreamSelector(ITeamRepository repo, IWorkspaceConnection wc, Composite parent, int flags, String initialPattern) {
        this(repo, wc, parent, flags, initialPattern, null, null);
    }

    public WorkspaceStreamSelector(ITeamRepository repo, IWorkspaceConnection wc, Composite parent, int flags, String initialPattern, String ownerName, String historyHeaderMessage) {
        super(parent, flags, initialPattern, WorkspaceStreamSelector.createLabelProvider(wc, repo));
        Assert.isLegal((repo != null ? 1 : 0) != 0);
        this.repo = repo;
        this.wc = wc;
        this.exactOwnerName = ownerName;
        this.initToolTips();
        this.addFilter(this.workspaceFilter);
        this.display = Display.getCurrent();
        this.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceStreamSelector.this.selectionProvider.realSetSelection((ISelection)new StructuredSelection(WorkspaceStreamSelector.this.getSelection()));
            }
        });
        this.setHistorySeparatorMessage(historyHeaderMessage);
    }

    public void setRepository(ITeamRepository repo) {
        this.repo = repo;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setShowWorkspaces(WORKSPACES_OR_STREAMS showWorkspaces) {
        this.workspacesOrStreams = showWorkspaces;
    }

    public void setExactOwnerName(String exactOwnerName) {
        this.exactOwnerName = exactOwnerName;
    }

    public void setOwner(IAuditableHandle ownerHandle) {
        this.ownerHandle = ownerHandle;
    }

    public WORKSPACES_OR_STREAMS getShowWorkspaces() {
        return this.workspacesOrStreams;
    }

    @Override
    public void startup() {
        this.jobRunner.enqueue(Messages.WorkspaceStreamSelector_LoadingFromCacheJobName, this.fStartupJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSearchPattern(String text) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fMatcher = new WorkspaceStreamMatcher(text);
            super.setSearchPattern(text);
        }
    }

    public void setSelection(IItemHandle handle) {
        Table table = this.getTable();
        if (handle == null) {
            table.deselectAll();
            return;
        }
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry;
            TableItem item = tableItemArray[n2];
            Object data = item.getData();
            if (data != null && data instanceof Entry && handle.sameItemId((IItemHandle)(entry = (Entry)data).getWrapper().getItem())) {
                table.setSelection(item);
                return;
            }
            ++n2;
        }
    }

    public AbstractPlaceWrapper[] getWrapperSelection() {
        Object[] selection = this.getSelection();
        return WorkspaceStreamSelector.filterWrappers(selection);
    }

    public AbstractPlaceWrapper[] getItems() {
        ArrayList<Object> objects = new ArrayList<Object>(this.getTable().getItemCount());
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            objects.add(item.getData());
            ++n2;
        }
        return WorkspaceStreamSelector.filterWrappers(objects.toArray());
    }

    private static AbstractPlaceWrapper[] filterWrappers(Object[] objects) {
        ArrayList<AbstractPlaceWrapper> result = new ArrayList<AbstractPlaceWrapper>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object != null && object instanceof Entry) {
                result.add(((Entry)object).getWrapper());
            }
            ++i;
        }
        return result.toArray(new AbstractPlaceWrapper[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(IFilter filter) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fFilterList.addFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(IFilter filter) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fFilterList.removeFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFilters() {
        Object object = this.fMutex;
        synchronized (object) {
            this.fFilterList.clearFilters();
        }
    }

    @Override
    protected String getSeparatorMessage() {
        return Messages.WorkspaceStreamSelector_RepositoryMatchesMessage;
    }

    @Override
    protected FilteringElementSelector.SyncJob createSyncJob() {
        return null;
    }

    @Override
    protected FilteringElementSelector.AbstractSearchJob createSearchJob() {
        return new RepositoryBasedSearchJob((FilteringElementSelector)this);
    }

    @Override
    protected boolean canUseCachedResult() {
        return false;
    }

    @Override
    protected FilteringElementSelector.AbstractSearchJob createCachedSearchJob(Object[] cachedElements) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] getHistoryElements() {
        Object object = this.fMutex;
        synchronized (object) {
            Entry[] history = this.fHistory;
            ArrayList<Entry> result = new ArrayList<Entry>();
            Entry[] entryArray = history;
            int n = history.length;
            int n2 = 0;
            while (n2 < n) {
                boolean checkOwner;
                Entry entry = entryArray[n2];
                boolean bl = checkOwner = this.exactOwnerName == null || this.exactOwnerName.equals(entry.getOwnerName());
                if (checkOwner && this.fFilterList.select((Object)entry.getWrapper())) {
                    result.add(entry);
                }
                ++n2;
            }
            Collections.sort(result);
            return result.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<AbstractPlaceWrapper> getHistoryWrappers() {
        Object object = this.fMutex;
        synchronized (object) {
            Entry[] history = this.fHistory;
            HashSet<AbstractPlaceWrapper> result = new HashSet<AbstractPlaceWrapper>();
            Entry[] entryArray = history;
            int n = history.length;
            int n2 = 0;
            while (n2 < n) {
                boolean checkOwner;
                Entry entry = entryArray[n2];
                boolean bl = checkOwner = this.exactOwnerName == null || this.exactOwnerName.equals(entry.getOwnerName());
                if (checkOwner && this.fFilterList.select((Object)entry.getWrapper())) {
                    result.add(entry.wrapper);
                }
                ++n2;
            }
            return result;
        }
    }

    private static FilteringElementSelector.ElementLabelProvider createLabelProvider(final IWorkspaceConnection wc, ITeamRepository repo) {
        return new FilteringElementSelector.ElementLabelProvider(){

            @Override
            public String getText(Object element) {
                String text;
                Entry entry = (Entry)element;
                AbstractPlaceWrapper wrapper = entry.getWrapper();
                if (wrapper instanceof ContributorPlaceWrapper) {
                    ContributorPlaceWrapper cpw = (ContributorPlaceWrapper)wrapper;
                    text = ContributorPlaceLabelProvider.getElementText(cpw);
                } else if (wrapper instanceof TeamPlaceWrapper) {
                    TeamPlaceWrapper pw = (TeamPlaceWrapper)wrapper;
                    text = TeamPlaceLabelProvider.getElementText(pw);
                } else {
                    return Messages.WorkspaceStreamSelector_UnknownLabel;
                }
                String ownerName = Messages.WorkspaceStreamSelector_UnknownOwnerLabel;
                if (entry.getOwner() instanceof IContributor) {
                    ownerName = ((IContributor)entry.getOwner()).getName();
                } else if (entry.getOwner() instanceof IProcessArea) {
                    ownerName = ((IProcessArea)entry.getOwner()).getName();
                }
                text = String.valueOf(text) + " (" + ownerName + ")";
                if (wc != null) {
                    boolean isDefaultOutgoingFlow;
                    IFlowEntry currentIncomingFlow = wc.getFlowTable().getCurrentAcceptFlow();
                    IFlowEntry currentOutgoingFlow = wc.getFlowTable().getCurrentDeliverFlow();
                    IFlowEntry defaultIncomingFlow = wc.getFlowTable().getDefaultAcceptFlow();
                    IFlowEntry defaultOutgoingFlow = wc.getFlowTable().getDefaultDeliverFlow();
                    boolean isCurrentIncomingFlow = currentIncomingFlow != null && wrapper.getWorkspace().getItemId().equals((Object)currentIncomingFlow.getFlowNode().getItemId());
                    boolean isCurrentOutgoingFlow = currentOutgoingFlow != null && wrapper.getWorkspace().getItemId().equals((Object)currentOutgoingFlow.getFlowNode().getItemId());
                    boolean isDefaultIncomingFlow = defaultIncomingFlow != null && wrapper.getWorkspace().getItemId().equals((Object)defaultIncomingFlow.getFlowNode().getItemId());
                    boolean bl = isDefaultOutgoingFlow = defaultOutgoingFlow != null && wrapper.getWorkspace().getItemId().equals((Object)defaultOutgoingFlow.getFlowNode().getItemId());
                    if (isDefaultIncomingFlow && isDefaultOutgoingFlow) {
                        text = NLS.bind((String)Messages.TeamPlaceOverviewPage_defaultFlow, (Object)text);
                    } else {
                        if (isDefaultIncomingFlow) {
                            text = NLS.bind((String)Messages.TeamPlaceOverviewPage_defaultIncomingFlow, (Object)text);
                        }
                        if (isDefaultOutgoingFlow) {
                            text = NLS.bind((String)Messages.TeamPlaceOverviewPage_defaultOutgoingFlow, (Object)text);
                        }
                    }
                    if (isCurrentIncomingFlow && isCurrentOutgoingFlow) {
                        text = NLS.bind((String)Messages.TeamPlaceOverviewPage_currentFlow, (Object)text);
                    } else {
                        if (isCurrentIncomingFlow) {
                            text = NLS.bind((String)Messages.TeamPlaceOverviewPage_currentIncomingFlow, (Object)text);
                        }
                        if (isCurrentOutgoingFlow) {
                            text = NLS.bind((String)Messages.TeamPlaceOverviewPage_currentOutgoingFlow, (Object)text);
                        }
                    }
                }
                text = String.valueOf(text) + " [" + com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(wrapper.getRepository()) + "]";
                return text;
            }

            @Override
            public ImageDescriptor getImageDescriptor(Object element) {
                Entry entry = (Entry)element;
                AbstractPlaceWrapper wrapper = entry.getWrapper();
                if (wrapper instanceof ContributorPlaceWrapper) {
                    ContributorPlaceWrapper cpw = (ContributorPlaceWrapper)wrapper;
                    return ContributorPlaceLabelProvider.getElementImage(cpw);
                }
                if (wrapper instanceof TeamPlaceWrapper) {
                    TeamPlaceWrapper pw = (TeamPlaceWrapper)wrapper;
                    return TeamPlaceLabelProvider.getElementImage(pw);
                }
                return null;
            }
        };
    }

    private void initToolTips() {
        TooltipSupport tooltips = new TooltipSupport((Control)this.getTable(), true, false){

            public Object getElement(Control control, int x, int y) {
                TableItem item = ((Table)control).getItem(new Point(x, y));
                return item != null ? item.getData() : null;
            }
        };
        tooltips.setPreferredFocusSize(PREFERRED_TOOLTIP_FOCUS_SIZE);
    }

    private class CacheBasedSearchJob
    extends FilteringElementSelector.AbstractSearchJob {
        private CacheBasedSearchJob(FilteringElementSelector viewer) {
            super(viewer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object[] getHistoryResult(IProgressMonitor monitor) throws CoreException {
            Object[] historyEntries = WorkspaceStreamSelector.this.getHistoryElements();
            ArrayList<Object> result = new ArrayList<Object>();
            Object object = WorkspaceStreamSelector.this.fMutex;
            synchronized (object) {
                if (!WorkspaceStreamSelector.this.fMatcher.isReset()) {
                    int i = 0;
                    while (i < historyEntries.length) {
                        Entry entry = (Entry)historyEntries[i];
                        if (WorkspaceStreamSelector.this.fMatcher.matches(entry.getMatchingString())) {
                            result.add(historyEntries[i]);
                        }
                        ++i;
                    }
                }
            }
            return result.toArray();
        }

        @Override
        protected FilteringElementSelector.SearchResult getSearchResult(Object[] historyElements, IProgressMonitor monitor) throws CoreException {
            return new FilteringElementSelector.SearchResult(new Object[0], true);
        }
    }

    private static class Entry
    implements Comparable {
        AbstractPlaceWrapper wrapper;
        IAuditable owner;

        Entry(AbstractPlaceWrapper wrapper, IAuditable owner) {
            this.wrapper = wrapper;
            this.owner = owner;
        }

        public AbstractPlaceWrapper getWrapper() {
            return this.wrapper;
        }

        public IAuditable getOwner() {
            return this.owner;
        }

        public String getOwnerName() {
            String result = null;
            if (this.getOwner() instanceof IContributor) {
                result = ((IContributor)this.getOwner()).getName();
            } else if (this.getOwner() instanceof IProcessArea) {
                result = ((IProcessArea)this.getOwner()).getName();
            }
            return result;
        }

        public int hashCode() {
            return this.wrapper.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.wrapper.equals((Object)other.wrapper);
        }

        public String getMatchingString() {
            String str = this.getWrapper().getWorkspace().getName();
            String ownerName = this.getOwnerName();
            if (ownerName != null) {
                str = String.valueOf(str) + " " + ownerName;
            }
            return str;
        }

        public int compareTo(Object o) {
            Entry other = (Entry)o;
            return this.getWrapper().getWorkspace().getName().compareToIgnoreCase(other.getWrapper().getWorkspace().getName());
        }
    }

    private static class FilterList
    implements IFilter {
        private ArrayList<IFilter> fFilters = new ArrayList();

        private FilterList() {
        }

        public boolean select(Object toTest) {
            for (IFilter filter : this.fFilters) {
                if (filter.select(toTest)) continue;
                return false;
            }
            return true;
        }

        public void addFilter(IFilter filter) {
            this.fFilters.add(filter);
        }

        public void removeFilter(IFilter filter) {
            this.fFilters.remove(filter);
        }

        public void clearFilters() {
            this.fFilters.clear();
        }
    }

    private class RepositoryBasedSearchJob
    extends CacheBasedSearchJob {
        private RepositoryBasedSearchJob(FilteringElementSelector viewer) {
            super(viewer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FilteringElementSelector.SearchResult getSearchResult(Object[] historyElements, IProgressMonitor monitor) throws CoreException {
            HashSet<Object> historyEntries = new HashSet<Object>();
            historyEntries.addAll(Arrays.asList(historyElements));
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.WorkspaceStreamSelector_SearchingProgressName, (int)100);
                String pattern = WorkspaceStreamSelector.this.getSearchPattern();
                IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance();
                criteria.setPartialNameIgnoreCase(pattern);
                criteria.setPartialOwnerNameIgnoreCase(pattern);
                if (WorkspaceStreamSelector.this.workspacesOrStreams.isStreams() && WorkspaceStreamSelector.this.workspacesOrStreams.isWorkspaces()) {
                    criteria.setKind(3);
                } else if (WorkspaceStreamSelector.this.workspacesOrStreams.isStreams()) {
                    criteria.setKind(1);
                } else {
                    criteria.setKind(2);
                }
                if (WorkspaceStreamSelector.this.exactOwnerName != null) {
                    criteria.setExactOwnerName(WorkspaceStreamSelector.this.exactOwnerName);
                }
                if (WorkspaceStreamSelector.this.ownerHandle != null) {
                    criteria.getFilterByOwnerOptional().add(WorkspaceStreamSelector.this.ownerHandle);
                }
                criteria.setRequireNameFilterUnion(true);
                List itemHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)WorkspaceStreamSelector.this.repo).findWorkspaces(criteria, Integer.MAX_VALUE, monitor);
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                List entries = WorkspaceStreamSelector.fetchEntries(WorkspaceStreamSelector.this.repo, itemHandles, (IProgressMonitor)progress.newChild(25));
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                progress.setTaskName(Messages.WorkspaceStreamSelector_SearchingDoneProgressName);
                ArrayList<Entry> matches = new ArrayList<Entry>(entries.size());
                Object object = WorkspaceStreamSelector.this.fMutex;
                synchronized (object) {
                    if (WorkspaceStreamSelector.this.fMatcher.isReset()) {
                        throw new OperationCanceledException();
                    }
                    for (Entry entry : entries) {
                        if (historyEntries.contains(entry) || !WorkspaceStreamSelector.this.fFilterList.select((Object)entry.getWrapper())) continue;
                        matches.add(entry);
                    }
                }
                progress.done();
                Object[] result = matches.toArray();
                Arrays.sort(result);
                return new FilteringElementSelector.SearchResult(result, true);
            }
            catch (TeamRepositoryException e) {
                String message = Messages.WorkspaceStreamSelector_ExceptionWhileSearching;
                if (e instanceof NotLoggedInException) {
                    message = Messages.WorkspaceStreamSelector_NotLoggedIn;
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", 4, message, (Throwable)e));
            }
            catch (OperationCanceledException e) {
                return new FilteringElementSelector.SearchResult(new Object[0], true);
            }
        }
    }

    private static class WorkspaceStreamMatcher {
        private String fPattern;
        private Pattern fRegexPattern;

        public WorkspaceStreamMatcher(String pattern) {
            this.fPattern = pattern;
            this.fRegexPattern = this.fPattern.length() == 0 ? null : Pattern.compile(WorkspaceUtil.convertToRegex(pattern, false, true), 2);
        }

        public boolean matches(String text) {
            Matcher matcher = this.fRegexPattern.matcher(text);
            return matcher.matches();
        }

        public boolean isReset() {
            return this.fRegexPattern == null;
        }
    }
}

