/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class WorkspaceComponentSelectionDialog {
    private WorkspaceComponentSelectionDialog() {
    }

    public static Collection<IComponentHandle> pickWorkspaceComponents(Shell shell, ITeamRepository repo, IWorkspace workspace, String title, String message, Collection<IComponentHandle> initialSelection, IProgressMonitor progress) throws TeamRepositoryException {
        Object[] componentsSelected;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)workspace, (IProgressMonitor)monitor.newChild(25));
        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(connection.getComponents(), 0, (IProgressMonitor)monitor.newChild(75));
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        for (Object o : fetchResult.getRetrievedItems()) {
            if (!(o instanceof IComponent)) continue;
            components.add((IComponent)o);
        }
        IComponent[] allComponents = components.toArray(new IComponent[components.size()]);
        Arrays.sort(allComponents, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((IComponent)o1).getName();
                String name2 = ((IComponent)o2).getName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        HashSet<UUID> initialSelectionUUIDs = new HashSet<UUID>();
        for (IComponentHandle componentHandle : initialSelection) {
            initialSelectionUUIDs.add(componentHandle.getItemId());
        }
        ArrayList<IComponent> initialSelectionComponents = new ArrayList<IComponent>(components.size());
        IComponent[] iComponentArray = allComponents;
        int n = allComponents.length;
        int n2 = 0;
        while (n2 < n) {
            IComponent component = iComponentArray[n2];
            if (initialSelectionUUIDs.contains(component.getItemId())) {
                initialSelectionComponents.add(component);
            }
            ++n2;
        }
        Object[] selection = initialSelectionComponents.toArray(new IComponent[initialSelectionComponents.size()]);
        ListSelectionDialog dialog = new ListSelectionDialog(DialogUtil.checkShell((Shell)shell), (Object)allComponents, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ComponentLabelProvider(), message);
        dialog.setTitle(title);
        dialog.setInitialSelections(selection);
        Collection<IComponentHandle> result = initialSelection;
        if (dialog.open() == 0 && (componentsSelected = dialog.getResult()) != null) {
            result = new ArrayList<IComponentHandle>(componentsSelected.length);
            int i = 0;
            while (i < componentsSelected.length) {
                result.add((IComponentHandle)((IComponent)componentsSelected[i]));
                ++i;
            }
        }
        return result;
    }

    private static class ComponentLabelProvider
    extends BaseLabelProvider {
        private Image componentImage;

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IComponent) {
                label.setText(((IComponent)element).getName());
            }
            if (this.componentImage == null) {
                this.componentImage = this.getImage(ImagePool.COMPONENT);
            }
            label.setImage(this.componentImage);
        }
    }
}

