/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ui.INCOMING_OR_OUTGOING;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialogOptions;
import com.ibm.team.filesystem.ui.WorkspaceStreamSelector;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.framework.geometry.Units;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryPicker;
import com.ibm.team.jface.internal.IElementSelectorStatusListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class WorkspaceAndStreamSelectionPart {
    public static final boolean MULTIPLE_SELECTION = true;
    private static final IStatus INIT_STATUS = new Status(0, "com.ibm.team.filesystem.ide.ui", 0, "", null);
    private Text fFilter;
    private WorkspaceStreamSelector fViewer;
    private Label fProgressLabel;
    private ITeamRepository fRepo;
    private final IStatusCollector fStatusCollector;
    private final IPartResult<AbstractPlaceWrapper[]> fPartResult;
    private IStatus fLastStatus = Status.OK_STATUS;
    private Runnable timerRunnable;
    private ITeamRepository repoPrimer;
    private final WorkspaceAndStreamSelectionDialogOptions fOptions;
    private RepositoryCombo combo;
    private Button selectDefaultIncomingButton;
    private Button selectDefaultOutgoingButton;
    private Button incomingFlowDirectionButton;
    private Button outgoingFlowDirectionButton;
    private Button bothFlowDirectionButton;
    private boolean isFlowDirectionButtonUpdated = false;
    private AbstractPlaceWrapper[] previousWrapperSelection = new AbstractPlaceWrapper[1];
    private SelectionListener defaultButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (WorkspaceAndStreamSelectionPart.this.fOptions.getTarget() != null) {
                Object[] defaultItems = WorkspaceAndStreamSelectionPart.this.getSelectDefault();
                Object defaultButton = e.item != null ? e.item : e.getSource();
                WorkspaceAndStreamSelectionPart.this.fViewer.setSelection(defaultButton == WorkspaceAndStreamSelectionPart.this.selectDefaultIncomingButton ? (IItemHandle)defaultItems[0] : (IItemHandle)defaultItems[2]);
                WorkspaceAndStreamSelectionPart.this.updateStatus(WorkspaceAndStreamSelectionPart.this.fLastStatus == Status.OK_STATUS ? INIT_STATUS : WorkspaceAndStreamSelectionPart.this.fLastStatus);
            }
        }
    };

    public WorkspaceAndStreamSelectionPart(Composite parent, ITeamRepository repo, IWorkspaceConnection target, boolean multi, List<IComponentHandle> components, WORKSPACES_OR_STREAMS showWorkspaces, boolean showWorkspacesRadio, String exactOwnerName, IFilter filter, IStatusCollector statusCollector, IPartResult<AbstractPlaceWrapper[]> partResult, boolean forceRepo) {
        this(parent, repo, new WorkspaceAndStreamSelectionDialogOptions().setTarget(target).setAllowMultiSelect(multi).setComponents(components).setShowWorkspaces(showWorkspaces).setShowWorkspacesRadio(showWorkspacesRadio).setExactOwnerName(exactOwnerName).setFilter(filter).setForceRepo(forceRepo), statusCollector, partResult);
    }

    public WorkspaceAndStreamSelectionPart(Composite parent, ITeamRepository repo, WorkspaceAndStreamSelectionDialogOptions options, IStatusCollector statusCollector, IPartResult<AbstractPlaceWrapper[]> partResult) {
        this.fRepo = repo;
        this.fOptions = options;
        this.fStatusCollector = statusCollector;
        this.fPartResult = partResult;
        if (this.fOptions.getComponents() != null && !this.fOptions.getComponents().isEmpty()) {
            this.createComponentControls(parent);
        } else {
            this.createControls(parent);
        }
        this.fViewer.startup();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fViewer.getSelectionProvider();
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + this.getClass().getName());
        return result;
    }

    private Control createInputControl(Composite parent) {
        Label label = new Label(parent, 0);
        if (!this.fOptions.isShowWorkspacesRadio() && this.fOptions.getShowWorkspaces() == WORKSPACES_OR_STREAMS.STREAMS) {
            label.setText(Messages.WorkspaceAndStreamSelectionPart_EnterStreamNameLabel);
        } else if (!this.fOptions.isShowWorkspacesRadio() && this.fOptions.getShowWorkspaces() == WORKSPACES_OR_STREAMS.WORKSPACES) {
            label.setText(Messages.WorkspaceAndStreamSelectionPart_EnterWorkspaceNameLabel);
        } else {
            label.setText(Messages.WorkspaceAndStreamSelectionPart_EnterStreamOrWorkspaceNameLabel);
        }
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fProgressLabel = new Label(parent, 131072);
        this.fProgressLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fFilter = new Text(parent, 2048);
        this.fFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkspaceAndStreamSelectionPart.this.patternChanged((Text)e.widget);
            }
        });
        this.fFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    WorkspaceAndStreamSelectionPart.this.fViewer.setFocus();
                }
            }
        });
        this.fFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkspaceAndStreamSelectionPart.this.apply();
            }
        });
        DialogUtil.setFocusControl(label, (Control)this.fFilter);
        this.fFilter.setFocus();
        return this.fFilter;
    }

    private void createRepoPicker(Composite parent) {
        if (!this.fOptions.isForceRepo() && UiPlugin.isDistributedUI()) {
            Label repoLabel = new Label(parent, 0);
            repoLabel.setText(Messages.WorkspaceAndStreamSelectionPart_1);
            repoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Button useSameRepo = new Button(parent, 16);
            Button useDistributed = new Button(parent, 16);
            this.combo = new RepositoryCombo(parent, (Preferences)this.getConfigPrefs(), WidgetFactoryContext.forDialogBox());
            this.combo.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    WorkspaceAndStreamSelectionPart.this.changeRepository(WorkspaceAndStreamSelectionPart.this.combo.getRepository());
                    WorkspaceAndStreamSelectionPart.this.fStatusCollector.reportProblem((IStatus)new Status(0, "com.ibm.team.filesystem.ide.ui", 1, "", null));
                }
            });
            String userId = this.repoPrimer.loggedIn() ? this.repoPrimer.loggedInContributor().getUserId() : Messages.WorkspaceAndStreamSelectionPart_6;
            useSameRepo.setText(NLS.bind((String)Messages.WorkspaceAndStreamSelectionPart_2, (Object)(String.valueOf(userId) + "@" + com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(this.repoPrimer))));
            useSameRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkspaceAndStreamSelectionPart.this.combo.setEnabled(false);
                    WorkspaceAndStreamSelectionPart.this.changeRepository(WorkspaceAndStreamSelectionPart.this.repoPrimer);
                    WorkspaceAndStreamSelectionPart.this.fStatusCollector.reportProblem((IStatus)new Status(0, "com.ibm.team.filesystem.ide.ui", 1, "", null));
                }
            });
            useSameRepo.setSelection(true);
            useSameRepo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            useDistributed.setText(Messages.WorkspaceAndStreamSelectionPart_3);
            useDistributed.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkspaceAndStreamSelectionPart.this.combo.setEnabled(true);
                    WorkspaceAndStreamSelectionPart.this.changeRepository(WorkspaceAndStreamSelectionPart.this.combo.getRepository());
                }
            });
            useDistributed.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.combo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.combo.setSelectedElement(this.repoPrimer);
            this.combo.setEnabled(false);
            this.fRepo = this.repoPrimer;
        }
    }

    private void createComponentControls(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttonComposite);
        Dialog.applyDialogFont((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(buttonComposite);
        this.createSameAsRepositoryWorkspaceRadioButton(buttonComposite, Messages.WorkspaceAndStreamSelectionPart_SameAsRepositoryWorkspace, Messages.WorkspaceAndStreamSelectionPart_SetFlowTarget);
        this.createSelectWorkspaceRadioButton(buttonComposite, Messages.WorkspaceAndStreamSelectionPart_SelectWorkspace, Messages.WorkspaceAndStreamSelectionPart_SetFlowTarget);
        Composite selectWorkspaceComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(selectWorkspaceComposite);
        GridDataFactory.fillDefaults().align(4, 4).indent(20, 0).grab(true, true).applyTo((Control)selectWorkspaceComposite);
        Dialog.applyDialogFont((Control)selectWorkspaceComposite);
        this.createControls(selectWorkspaceComposite);
    }

    private void createControls(Composite result) {
        this.createInputControl(result);
        if (this.fOptions.isShowWorkspacesRadio()) {
            Composite buttonComposite = new Composite(result, 0);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)buttonComposite);
            Dialog.applyDialogFont((Control)buttonComposite);
            GridLayoutFactory.fillDefaults().numColumns(4).applyTo(buttonComposite);
            Label buttonsLabel = new Label(buttonComposite, 0);
            buttonsLabel.setText(Messages.WorkspaceAndStreamSelectionPart_ShowButton);
            this.createRadioButton(buttonComposite, Messages.WorkspaceAndStreamSelectionPart_StreamsRadioButton, WORKSPACES_OR_STREAMS.STREAMS, Messages.WorkspaceAndStreamSelectionPart_ShowButton);
            this.createRadioButton(buttonComposite, Messages.WorkspaceAndStreamSelectionPart_WorkspacesRadioButton, WORKSPACES_OR_STREAMS.WORKSPACES, Messages.WorkspaceAndStreamSelectionPart_ShowButton);
            this.createRadioButton(buttonComposite, Messages.WorkspaceAndStreamSelectionPart_BothRadioButton, WORKSPACES_OR_STREAMS.BOTH, Messages.WorkspaceAndStreamSelectionPart_ShowButton);
        }
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        this.repoPrimer = this.fRepo;
        if (this.repoPrimer == null) {
            Object[] defaultItems = this.getSelectDefault();
            this.repoPrimer = (ITeamRepository)defaultItems[1];
            if (this.repoPrimer == null) {
                this.repoPrimer = (ITeamRepository)defaultItems[3];
            }
            if (this.repoPrimer == null) {
                if (repos.length == 0) {
                    throw new IllegalArgumentException(Messages.WorkspaceAndStreamSelectionPart_0);
                }
                this.repoPrimer = repos[0];
            }
        }
        String message = Messages.WorkspaceAndStreamSelectionPart_12;
        message = MessageFormat.format(message, com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(this.repoPrimer));
        this.updateStatus((IStatus)new Status(0, "com.ibm.team.filesystem.ide.ui", 0, message, null));
        Label label = new Label(result, 0);
        label.setText(Messages.WorkspaceAndStreamSelectionPart_MatchingItemsLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)label);
        int flags = 2816;
        Composite viewerComposite = result;
        int tableSpan = 2;
        String historySeparatorMessage = Messages.WorkspaceAndStreamSelectionPart_SUGGESTED_MATCHES;
        if (this.fOptions.getComponents() != null) {
            viewerComposite = new Composite(result, 0);
            tableSpan = 1;
            historySeparatorMessage = Messages.WorkspaceAndStreamSelectionPart_WORKSPACE_FLOW_TARGET_MATCHES;
        }
        this.fViewer = new WorkspaceStreamSelector(this.repoPrimer, this.fOptions.getTarget(), viewerComposite, this.fOptions.isAllowMultiSelect() ? flags | 2 : flags, "", this.fOptions.getExactOwnerName(), historySeparatorMessage);
        this.fViewer.setShowWorkspaces(this.fOptions.getShowWorkspaces());
        this.fViewer.setOwner(this.fOptions.getOwnerHandle());
        this.fViewer.setProgressLabel(this.fProgressLabel);
        this.fViewer.addStatusListener(new IElementSelectorStatusListener(){
            private boolean fIsError;

            public void reset() {
                String message = Messages.WorkspaceAndStreamSelectionPart_12;
                message = MessageFormat.format(message, com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(WorkspaceAndStreamSelectionPart.this.fRepo));
                this.started(message);
            }

            public void started(String message) {
                this.fIsError = false;
                WorkspaceAndStreamSelectionPart.this.updateStatus((IStatus)new Status(0, "com.ibm.team.filesystem.ide.ui", 0, message, null));
            }

            public void progress(String message, double actualWork, int totalWork) {
            }

            public void stopped() {
                if (!this.fIsError) {
                    String historyMessage;
                    int itemCount = WorkspaceAndStreamSelectionPart.this.fViewer.getItemCount();
                    int historyCount = 0;
                    AbstractPlaceWrapper[] results = WorkspaceAndStreamSelectionPart.this.fViewer.getItems();
                    Set<AbstractPlaceWrapper> historyElements = WorkspaceAndStreamSelectionPart.this.fViewer.getHistoryWrappers();
                    AbstractPlaceWrapper[] abstractPlaceWrapperArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractPlaceWrapper result = abstractPlaceWrapperArray[n2];
                        if (historyElements.contains((Object)result)) {
                            --itemCount;
                            ++historyCount;
                        }
                        ++n2;
                    }
                    String messageFormat = itemCount == 1 ? Messages.WorkspaceAndStreamSelectionPart_ItemFoundMessage : Messages.WorkspaceAndStreamSelectionPart_ItemsFoundMessage;
                    String infoMessage = MessageFormat.format(messageFormat, new Integer(itemCount), com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(WorkspaceAndStreamSelectionPart.this.fRepo));
                    String string = historyMessage = historyCount == 1 ? Messages.WorkspaceAndStreamSelectionPart_ItemInRecentlyAccessed : Messages.WorkspaceAndStreamSelectionPart_ItemsInRecentlyAccessed;
                    if (WorkspaceAndStreamSelectionPart.this.fOptions.getComponents() != null) {
                        historyMessage = historyCount == 1 ? Messages.WorkspaceAndStreamSelectionPart_ItemInFlowTable : Messages.WorkspaceAndStreamSelectionPart_ItemsInFlowTable;
                    }
                    historyMessage = MessageFormat.format(historyMessage, new Integer(historyCount));
                    WorkspaceAndStreamSelectionPart.this.updateStatus((IStatus)new Status(1, "com.ibm.team.filesystem.ide.ui", 1, String.valueOf(historyMessage) + infoMessage, null));
                }
            }

            public void error(CoreException e) {
                WorkspaceAndStreamSelectionPart.this.updateStatus(StatusUtil.newStatus((Object)this, (Throwable)e));
                this.fIsError = true;
            }
        });
        if (this.fOptions.getFilter() != null) {
            this.fViewer.addFilter(this.fOptions.getFilter());
        }
        Table table = this.fViewer.getTable();
        GridDataFactory.fillDefaults().grab(true, true).span(tableSpan, 1).hint(Units.getDLUToPixels().multiply(new Point(250, 120))).applyTo((Control)table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPlaceWrapper[] currentWrapperSelection = WorkspaceAndStreamSelectionPart.this.getItems();
                boolean sameAsPreviousWrapperSelection = true;
                if (currentWrapperSelection != null && currentWrapperSelection.length > 0 && WorkspaceAndStreamSelectionPart.this.previousWrapperSelection[0] != null && !WorkspaceAndStreamSelectionPart.this.previousWrapperSelection[0].equals((Object)currentWrapperSelection[0])) {
                    sameAsPreviousWrapperSelection = false;
                }
                if (!WorkspaceAndStreamSelectionPart.this.isFlowDirectionButtonUpdated || !sameAsPreviousWrapperSelection) {
                    WorkspaceAndStreamSelectionPart.this.updateStatus(WorkspaceAndStreamSelectionPart.this.fLastStatus == Status.OK_STATUS ? INIT_STATUS : WorkspaceAndStreamSelectionPart.this.fLastStatus);
                    if (WorkspaceAndStreamSelectionPart.this.fOptions.getComponents() != null && WorkspaceAndStreamSelectionPart.this.fOptions.getComponents().isEmpty()) {
                        WorkspaceAndStreamSelectionPart.this.updateFlowDirectionRadioButton();
                    }
                    WorkspaceAndStreamSelectionPart.this.updateEnablement();
                }
                if (currentWrapperSelection != null && currentWrapperSelection.length > 0) {
                    ((WorkspaceAndStreamSelectionPart)WorkspaceAndStreamSelectionPart.this).previousWrapperSelection[0] = currentWrapperSelection[0];
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                WorkspaceAndStreamSelectionPart.this.apply();
            }
        });
        if (this.fOptions.getComponents() != null) {
            Composite buttonComposite = new Composite(viewerComposite, 0);
            IPartResult<ITeamRepository> repoResult = new IPartResult<ITeamRepository>(){

                public void setResult(ITeamRepository result) {
                    WorkspaceAndStreamSelectionPart.this.changeRepository(result);
                    String infoMessage = Messages.WorkspaceAndStreamSelectionPart_12;
                    String message = MessageFormat.format(infoMessage, com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(WorkspaceAndStreamSelectionPart.this.fRepo));
                    WorkspaceAndStreamSelectionPart.this.updateStatus((IStatus)new Status(0, "com.ibm.team.filesystem.ide.ui", 1, message, null));
                }
            };
            if (repos.length > 1) {
                Button changeRepositoryButton = new Button(buttonComposite, 8);
                changeRepositoryButton.setText(Messages.WorkspaceAndStreamSelectionPart_4);
                changeRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter((IPartResult)repoResult){
                    private final /* synthetic */ IPartResult val$repoResult;
                    {
                        this.val$repoResult = iPartResult;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Shell shell = e.display.getActiveShell();
                        RepositoryPicker.pickRepository(shell, Messages.WorkspaceAndStreamSelectionPart_5, (IPartResult<ITeamRepository>)this.val$repoResult);
                    }
                });
            }
            this.selectDefaultIncomingButton = new Button(buttonComposite, 8);
            this.selectDefaultIncomingButton.setText(Messages.WorkspaceAndStreamSelectionPart_SelectDefaultIncomingButton);
            this.selectDefaultOutgoingButton = new Button(buttonComposite, 8);
            this.selectDefaultOutgoingButton.setText(Messages.WorkspaceAndStreamSelectionPart_SelectDefaultOutgoingButton);
            if (this.fOptions.getTarget() != null) {
                this.selectDefaultIncomingButton.addSelectionListener(this.defaultButtonListener);
                this.selectDefaultOutgoingButton.addSelectionListener(this.defaultButtonListener);
            }
            Dialog.applyDialogFont((Control)buttonComposite);
            GridLayoutFactory.fillDefaults().generateLayout(buttonComposite);
            Dialog.applyDialogFont((Control)viewerComposite);
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(viewerComposite);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)viewerComposite);
            if (this.fOptions.getComponents().isEmpty()) {
                Composite flowDirectionButtonComposite = new Composite(result, 0);
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)flowDirectionButtonComposite);
                Dialog.applyDialogFont((Control)flowDirectionButtonComposite);
                GridLayoutFactory.fillDefaults().numColumns(4).applyTo(flowDirectionButtonComposite);
                Label buttonsLabel = new Label(flowDirectionButtonComposite, 0);
                buttonsLabel.setText(Messages.WorkspaceAndStreamSelectionPart_SetFlowDirectionButton);
                this.incomingFlowDirectionButton = this.createFlowDirectionRadioButton(flowDirectionButtonComposite, Messages.WorkspaceAndStreamSelectionPart_IncomingRadioButton, INCOMING_OR_OUTGOING.INCOMING, Messages.WorkspaceAndStreamSelectionPart_SetFlowDirectionButton);
                this.outgoingFlowDirectionButton = this.createFlowDirectionRadioButton(flowDirectionButtonComposite, Messages.WorkspaceAndStreamSelectionPart_OutgoingRadioButton, INCOMING_OR_OUTGOING.OUTGOING, Messages.WorkspaceAndStreamSelectionPart_SetFlowDirectionButton);
                this.bothFlowDirectionButton = this.createFlowDirectionRadioButton(flowDirectionButtonComposite, Messages.WorkspaceAndStreamSelectionPart_BothFlowDirectionRadioButton, INCOMING_OR_OUTGOING.BOTH, Messages.WorkspaceAndStreamSelectionPart_SetFlowDirectionButton);
            }
        }
        this.createRepoPicker(result);
    }

    private void updateEnablement() {
        if (this.fOptions.getComponents() != null) {
            boolean incomingEnabled = false;
            boolean outgoingEnabled = false;
            if (this.fOptions.getTarget() != null) {
                Object[] defaultItems = this.getSelectDefault();
                IItemHandle selectDefaultIncoming = (IItemHandle)defaultItems[0];
                IItemHandle selectDefaultOutgoing = (IItemHandle)defaultItems[2];
                if (selectDefaultIncoming != null || selectDefaultOutgoing != null) {
                    AbstractPlaceWrapper[] items;
                    AbstractPlaceWrapper[] abstractPlaceWrapperArray = items = this.fViewer.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractPlaceWrapper item = abstractPlaceWrapperArray[n2];
                        if (item.getItem().sameItemId(selectDefaultIncoming)) {
                            incomingEnabled = true;
                        }
                        if (item.getItem().sameItemId(selectDefaultOutgoing)) {
                            outgoingEnabled = true;
                        }
                        if (!(selectDefaultIncoming != null && !incomingEnabled || selectDefaultOutgoing != null && !outgoingEnabled)) break;
                        ++n2;
                    }
                }
            }
            this.updateStatus(this.fLastStatus == Status.OK_STATUS ? INIT_STATUS : this.fLastStatus);
            this.selectDefaultIncomingButton.setEnabled(incomingEnabled);
            this.selectDefaultOutgoingButton.setEnabled(outgoingEnabled);
        }
    }

    private Button createRadioButton(Composite parent, final String text, final WORKSPACES_OR_STREAMS value, final String groupLabel) {
        final Button button = new Button(parent, 16);
        button.setText(text);
        button.setSelection(value == this.fOptions.getShowWorkspaces());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    WorkspaceAndStreamSelectionPart.this.fViewer.setShowWorkspaces(value);
                    String searchPattern = WorkspaceAndStreamSelectionPart.this.fViewer.getSearchPattern();
                    WorkspaceAndStreamSelectionPart.this.fViewer.setSearchPattern(searchPattern);
                }
            }
        });
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(groupLabel) + " " + text;
            }
        });
        return button;
    }

    private Button createFlowDirectionRadioButton(Composite flowDirectionButtonComposite, final String text, INCOMING_OR_OUTGOING value, final String groupLabel) {
        final Button button = new Button(flowDirectionButtonComposite, 16);
        button.setText(text);
        button.setSelection(value == this.fOptions.getFlowDirection());
        button.setData("FlowDirection", (Object)value);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceAndStreamSelectionPart.this.setFlowDirection(button);
            }
        });
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(groupLabel) + " " + text;
            }
        });
        return button;
    }

    private Button createSameAsRepositoryWorkspaceRadioButton(final Composite composite, final String text, final String groupLabel) {
        final Button button = new Button(composite, 16);
        button.setText(text);
        button.setSelection(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    Composite child = (Composite)composite.getParent().getChildren()[1];
                    WorkspaceAndStreamSelectionPart.this.recursiveSetEnabled((Control)child, false);
                    WorkspaceAndStreamSelectionPart.this.fOptions.setSameAsRepositoryWorkspace(true);
                    WorkspaceAndStreamSelectionPart.this.updateStatus(INIT_STATUS);
                }
            }
        });
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(groupLabel) + " " + text;
            }
        });
        return button;
    }

    private Button createSelectWorkspaceRadioButton(final Composite composite, final String text, final String groupLabel) {
        final Button button = new Button(composite, 16);
        button.setText(text);
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    Composite child = (Composite)composite.getParent().getChildren()[1];
                    WorkspaceAndStreamSelectionPart.this.recursiveSetEnabled((Control)child, true);
                    WorkspaceAndStreamSelectionPart.this.fOptions.setSameAsRepositoryWorkspace(false);
                    WorkspaceAndStreamSelectionPart.this.updateStatus(INIT_STATUS);
                }
            }
        });
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(groupLabel) + " " + text;
            }
        });
        return button;
    }

    private void apply() {
        AbstractPlaceWrapper[] items;
        if (this.fPartResult != null && (items = this.getItems()).length > 0) {
            this.fPartResult.setResult((Object)items);
        }
    }

    private void updateStatus(IStatus status) {
        this.fLastStatus = status;
        if (this.fStatusCollector != null) {
            this.fStatusCollector.reportProblem(status);
        }
    }

    private void patternChanged(final Text text) {
        if (this.timerRunnable == null) {
            this.timerRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!text.isDisposed()) {
                        WorkspaceAndStreamSelectionPart.this.fViewer.setSearchPattern(text.getText());
                    }
                }
            };
        }
        text.getDisplay().timerExec(500, this.timerRunnable);
    }

    public AbstractPlaceWrapper[] getItems() {
        return this.fOptions.getComponents() != null && this.fOptions.isSameAsRepositoryWorkspace() ? new AbstractPlaceWrapper[1] : this.fViewer.getWrapperSelection();
    }

    private Object[] getSelectDefault() {
        IFlowEntry defaultDeliverFlow;
        IFlowEntry defaultAcceptFlow;
        if (this.fOptions.getTarget() == null || this.fOptions.getComponents() == null) {
            return new Object[4];
        }
        ITeamRepository repoIncoming = null;
        ITeamRepository repoOutgoing = null;
        IFlowTable flowTable = this.fOptions.getTarget().getFlowTable();
        IFlowNodeHandle selectDefaultIncoming = null;
        IFlowNodeHandle selectDefaultOutgoing = null;
        boolean processIncoming = true;
        boolean processOutgoing = true;
        for (IComponentHandle component : this.fOptions.getComponents()) {
            IFlowNodeHandle flowNode;
            if (processIncoming) {
                IFlowEntry defaultAcceptFlow2 = flowTable.getDefaultAcceptFlow(component);
                if (defaultAcceptFlow2 == null) {
                    selectDefaultIncoming = null;
                    processIncoming = false;
                } else {
                    flowNode = defaultAcceptFlow2.getFlowNode();
                    if (selectDefaultIncoming == null) {
                        selectDefaultIncoming = flowNode;
                        repoIncoming = RepositoryUtils.getTeamRepository((String)defaultAcceptFlow2.getRemoteRepositoryURI(), (UUID)defaultAcceptFlow2.getRemoteRepositoryIdentifier());
                    } else if (!selectDefaultIncoming.sameItemId((IItemHandle)flowNode)) {
                        selectDefaultIncoming = null;
                        processIncoming = false;
                    }
                }
            }
            if (processOutgoing) {
                IFlowEntry defaultDeliverFlow2 = flowTable.getDefaultDeliverFlow(component);
                if (defaultDeliverFlow2 == null) {
                    selectDefaultOutgoing = null;
                    processOutgoing = false;
                } else {
                    flowNode = defaultDeliverFlow2.getFlowNode();
                    if (selectDefaultOutgoing == null) {
                        selectDefaultOutgoing = flowNode;
                        repoOutgoing = RepositoryUtils.getTeamRepository((String)defaultDeliverFlow2.getRemoteRepositoryURI(), (UUID)defaultDeliverFlow2.getRemoteRepositoryIdentifier());
                    } else if (!selectDefaultOutgoing.sameItemId((IItemHandle)flowNode)) {
                        selectDefaultOutgoing = null;
                        processOutgoing = false;
                    }
                }
            }
            if (!processIncoming && !processOutgoing) break;
        }
        if (selectDefaultIncoming == null && (defaultAcceptFlow = flowTable.getDefaultAcceptFlow()) != null) {
            selectDefaultIncoming = defaultAcceptFlow.getFlowNode();
            repoIncoming = defaultAcceptFlow.getRemoteRepositoryURI() == null ? this.fOptions.getTarget().teamRepository() : RepositoryUtils.getTeamRepository((String)defaultAcceptFlow.getRemoteRepositoryURI(), (UUID)defaultAcceptFlow.getRemoteRepositoryIdentifier());
        }
        if (selectDefaultOutgoing == null && (defaultDeliverFlow = flowTable.getDefaultDeliverFlow()) != null) {
            selectDefaultOutgoing = defaultDeliverFlow.getFlowNode();
            repoOutgoing = defaultDeliverFlow.getRemoteRepositoryURI() == null ? this.fOptions.getTarget().teamRepository() : RepositoryUtils.getTeamRepository((String)defaultDeliverFlow.getRemoteRepositoryURI(), (UUID)defaultDeliverFlow.getRemoteRepositoryIdentifier());
        }
        return new Object[]{selectDefaultIncoming, repoIncoming, selectDefaultOutgoing, repoOutgoing};
    }

    public void changeRepository(ITeamRepository repo) {
        if (repo == null || repo.equals(this.fRepo)) {
            return;
        }
        this.fRepo = repo;
        this.fViewer.setRepository(repo);
        this.patternChanged(this.fFilter);
    }

    private void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
            comp.setEnabled(enabled);
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    private INCOMING_OR_OUTGOING getFlowDirection() {
        INCOMING_OR_OUTGOING flowDirection = null;
        AbstractPlaceWrapper[] item = this.fViewer.getWrapperSelection();
        if (item.length != 0) {
            try {
                IWorkspaceConnection source = this.fOptions.getTarget();
                IWorkspace target = item[0].getWorkspace();
                boolean hasIncomingCollaboration = false;
                boolean hasOutgoingCollaboration = false;
                if (FlowTableUtil.hasCurrentCollaboration((IWorkspaceConnection)source)) {
                    if (FlowTableUtil.isCurrentIncomingCollaboration((IWorkspaceConnection)source, (IWorkspace)target)) {
                        hasIncomingCollaboration = true;
                    }
                    if (FlowTableUtil.isCurrentOutgoingCollaboration((IWorkspaceConnection)source, (IWorkspace)target)) {
                        hasOutgoingCollaboration = true;
                    }
                }
                if (!hasIncomingCollaboration && !hasOutgoingCollaboration) {
                    if (FlowTableUtil.hasIncomingCollaboration((IWorkspaceConnection)source, (IWorkspace)target)) {
                        hasIncomingCollaboration = true;
                    }
                    if (FlowTableUtil.hasOutgoingCollaboration((IWorkspaceConnection)source, (IWorkspace)target)) {
                        hasOutgoingCollaboration = true;
                    }
                }
                flowDirection = hasIncomingCollaboration && !hasOutgoingCollaboration ? INCOMING_OR_OUTGOING.INCOMING : (!hasIncomingCollaboration && hasOutgoingCollaboration ? INCOMING_OR_OUTGOING.OUTGOING : (hasIncomingCollaboration && hasOutgoingCollaboration ? INCOMING_OR_OUTGOING.BOTH : INCOMING_OR_OUTGOING.BOTH));
            }
            catch (TeamRepositoryException e) {
                this.updateStatus((IStatus)new Status(4, "com.ibm.team.filesystem.ide.ui", 4, Messages.WorkspaceAndStreamSelectionPart_FetchFlowDirectionException, (Throwable)e));
            }
        }
        return flowDirection;
    }

    private void updateFlowDirectionRadioButton() {
        INCOMING_OR_OUTGOING flowDirection = this.getFlowDirection();
        if (flowDirection == null) {
            flowDirection = INCOMING_OR_OUTGOING.BOTH;
        }
        this.fOptions.setFlowDirection(flowDirection);
        this.incomingFlowDirectionButton.setSelection(flowDirection == INCOMING_OR_OUTGOING.INCOMING);
        this.outgoingFlowDirectionButton.setSelection(flowDirection == INCOMING_OR_OUTGOING.OUTGOING);
        this.bothFlowDirectionButton.setSelection(flowDirection == INCOMING_OR_OUTGOING.BOTH);
    }

    private void setFlowDirection(Button button) {
        INCOMING_OR_OUTGOING flowDirection = this.getFlowDirection();
        if (flowDirection == null) {
            return;
        }
        if (button.getData("FlowDirection") != flowDirection) {
            this.isFlowDirectionButtonUpdated = true;
        }
        this.fOptions.setFlowDirection((INCOMING_OR_OUTGOING)((Object)button.getData("FlowDirection")));
        this.updateStatus(this.fLastStatus == Status.OK_STATUS ? INIT_STATUS : this.fLastStatus);
    }
}

