/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.ui.INCOMING_OR_OUTGOING;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialogOptions;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionPart;
import com.ibm.team.filesystem.ui.framework.geometry.Units;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.StatusCollectorAdapter;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class WorkspaceAndStreamSelectionDialog
extends SelectionStatusDialog {
    private static final String SETTINGS = WorkspaceAndStreamSelectionDialog.class.getName();
    private final ITeamRepository fRepo;
    private WorkspaceAndStreamSelectionPart fSelectionPart;
    private WorkspaceAndStreamSelectionDialogOptions fOptions;
    private static INCOMING_OR_OUTGOING fDirection;
    private static boolean isSameAsRepositoryWorkspace;

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, Collections.EMPTY_LIST);
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, List<? extends IWorkspaceHandle> toIgnore) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, null, WORKSPACES_OR_STREAMS.STREAMS, toIgnore);
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, IWorkspaceConnection target, List<? extends IWorkspaceHandle> toIgnore) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, target, WORKSPACES_OR_STREAMS.STREAMS, toIgnore);
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, IWorkspaceConnection target, WORKSPACES_OR_STREAMS showWorkspaces, List<? extends IWorkspaceHandle> toIgnore) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, target, null, showWorkspaces, toIgnore);
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, IWorkspaceConnection target, List<IComponentHandle> components, WORKSPACES_OR_STREAMS showWorkspaces, List<? extends IWorkspaceHandle> toIgnore) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, target, components, showWorkspaces, true, null, toIgnore);
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, IWorkspaceConnection target, List<IComponentHandle> components, WORKSPACES_OR_STREAMS showWorkspaces, String exactOwnerName, List<? extends IWorkspaceHandle> toIgnore) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, target, components, showWorkspaces, true, exactOwnerName, toIgnore);
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, IWorkspaceConnection target, List<IComponentHandle> components, WORKSPACES_OR_STREAMS showWorkspaces, boolean showWorkspacesRadio, String exactOwnerName, List<? extends IWorkspaceHandle> toIgnore) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, target, components, showWorkspaces, showWorkspacesRadio, exactOwnerName, toIgnore, true);
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, IWorkspaceConnection target, List<IComponentHandle> components, WORKSPACES_OR_STREAMS showWorkspaces, boolean showWorkspacesRadio, String exactOwnerName, List<? extends IWorkspaceHandle> toIgnore, boolean forceRepo) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(parent, repo, new WorkspaceAndStreamSelectionDialogOptions().setTarget(target).setAllowMultiSelect(false).setComponents(components).setShowWorkspaces(showWorkspaces).setShowWorkspacesRadio(showWorkspacesRadio).setExactOwnerName(exactOwnerName).setToIgnore(toIgnore).setForceRepo(forceRepo));
    }

    public static AbstractPlaceWrapper getWorkspaceOrStream(Shell parent, ITeamRepository repo, WorkspaceAndStreamSelectionDialogOptions options) {
        WorkspaceAndStreamSelectionDialog dialog = new WorkspaceAndStreamSelectionDialog(parent, repo, options);
        dialog.setTitle(WorkspaceAndStreamSelectionDialog.getDialogTitle(options));
        if (dialog.open() == 0) {
            fDirection = dialog.fOptions.getFlowDirection();
            isSameAsRepositoryWorkspace = dialog.fOptions.isSameAsRepositoryWorkspace();
            return (AbstractPlaceWrapper)((Object)dialog.getFirstResult());
        }
        return null;
    }

    public static AbstractPlaceWrapper[] getWorkspacesOrStreams(Shell parent, ITeamRepository repo, IFilter filter) {
        Assert.isLegal((repo != null ? 1 : 0) != 0);
        WorkspaceAndStreamSelectionDialogOptions options = new WorkspaceAndStreamSelectionDialogOptions().setAllowMultiSelect(true).setShowWorkspaces(WORKSPACES_OR_STREAMS.BOTH).setShowWorkspacesRadio(true).setFilter(filter).setForceRepo(true);
        WorkspaceAndStreamSelectionDialog dialog = new WorkspaceAndStreamSelectionDialog(parent, repo, options);
        dialog.setTitle(WorkspaceAndStreamSelectionDialog.getDialogTitle(options));
        if (dialog.open() == 0) {
            return (AbstractPlaceWrapper[])dialog.getResult();
        }
        return null;
    }

    public static AbstractPlaceWrapper[] getWorkspacesOrStreams2(Shell parent, ITeamRepository repo, WorkspaceAndStreamSelectionDialogOptions options) {
        WorkspaceAndStreamSelectionDialog dialog = new WorkspaceAndStreamSelectionDialog(parent, repo, options);
        dialog.setTitle(WorkspaceAndStreamSelectionDialog.getDialogTitle(options));
        if (dialog.open() == 0) {
            return (AbstractPlaceWrapper[])dialog.getResult();
        }
        return null;
    }

    private static String getDialogTitle(WorkspaceAndStreamSelectionDialogOptions options) {
        String dialogTitle = options.isShowWorkspacesRadio() ? (options.isAllowMultiSelect() ? Messages.WorkspaceAndStreamSelectionDialog_SelectStreamsAndWorkspacesDialogTitle : Messages.WorkspaceAndStreamSelectionDialog_SelectStreamOrWorkspaceDialogTitle) : (WORKSPACES_OR_STREAMS.STREAMS.equals((Object)options.getShowWorkspaces()) ? (options.isAllowMultiSelect() ? Messages.WorkspaceAndStreamSelectionDialog_SelectStreamsDialogTitle : Messages.WorkspaceAndStreamSelectionDialog_SelectStreamDialogTitle) : (WORKSPACES_OR_STREAMS.WORKSPACES.equals((Object)options.getShowWorkspaces()) ? (options.isAllowMultiSelect() ? Messages.WorkspaceAndStreamSelectionDialog_SelectRepositoryWorkspacesDialogTitle : Messages.WorkspaceAndStreamSelectionDialog_SelectRepositoryWorkspaceDialogTitle) : (options.isAllowMultiSelect() ? Messages.WorkspaceAndStreamSelectionDialog_SelectStreamsAndWorkspacesDialogTitle : Messages.WorkspaceAndStreamSelectionDialog_SelectStreamOrWorkspaceDialogTitle)));
        return dialogTitle;
    }

    public static INCOMING_OR_OUTGOING getFlowDirection() {
        return fDirection;
    }

    public static boolean isSameAsRepositoryWorkspace() {
        return isSameAsRepositoryWorkspace;
    }

    private WorkspaceAndStreamSelectionDialog(Shell parent, ITeamRepository repo, WorkspaceAndStreamSelectionDialogOptions options) {
        super(parent);
        this.fRepo = repo;
        this.fOptions = options == null ? new WorkspaceAndStreamSelectionDialogOptions() : options;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        this.setStatusLineAboveButtons(true);
        StatusCollectorAdapter statusCollector = new StatusCollectorAdapter(){

            public void reportProblem(IStatus status) {
                WorkspaceAndStreamSelectionDialog.this.updateStatus(status);
            }
        };
        IPartResult<AbstractPlaceWrapper[]> partResult = new IPartResult<AbstractPlaceWrapper[]>(){

            public void setResult(AbstractPlaceWrapper[] result) {
                WorkspaceAndStreamSelectionDialog.this.okPressed();
            }
        };
        this.fSelectionPart = new WorkspaceAndStreamSelectionPart(composite, this.fRepo, this.fOptions, (IStatusCollector)statusCollector, partResult);
        WorkspaceAndStreamSelectionDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.filesystem.ide.ui.dialog_selectworkspaceorstream");
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setMinimumSize(Units.getDLUToPixels().multiply(new Point(225, 150)));
    }

    protected void computeResult() {
        this.setSelectionResult((Object[])this.fSelectionPart.getItems());
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (this.fSelectionPart.getItems().length == 0) {
            this.getOkButton().setEnabled(false);
        } else {
            super.updateButtonsEnableState(status);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings all = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings result = all.getSection(SETTINGS);
        if (result == null) {
            result = new DialogSettings(SETTINGS);
            all.addSection(result);
        }
        return result;
    }
}

