/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.ui.AbstractDeliveryHyperlinkHandler;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.links.WorkspaceLocationFactory;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class WorkspaceAndStreamHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            IItemType type = location.getItemType();
            return type != null && type == IWorkspace.ITEM_TYPE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor monitor) {
        try {
            final AbstractPlaceWrapper placeWrapper = this.getWrapper(uri, monitor);
            if (placeWrapper != null) {
                UIJob job = new UIJob(Messages.WorkspaceAndStreamHyperlinkHandler_OpeningJobName){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                        if (page != null) {
                            TeamPlaceEditorInput input = TeamPlaceEditorInput.newForEdit(placeWrapper);
                            TeamPlacePart2.open(page, input);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        }
        catch (TeamRepositoryException e) {
            String msg = String.valueOf(Messages.WorkspaceAndStreamHyperlinkHandler_ErrorOpeningWorkspaceLinkError) + uri.toString();
            StatusUtil.log((Object)((Object)this), (String)msg, (Throwable)e);
            JFaceUtils.showError((String)Messages.WorkspaceAndStreamHyperlinkHandler_OpenWorkspaceErrorTitle, (String)msg, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected AbstractPlaceWrapper getWrapper(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Location location = Location.location((URI)uri);
        ITeamRepository repo = AbstractDeliveryHyperlinkHandler.resolveTeamRepository(location, (IProgressMonitor)progress.newChild(30));
        IWorkspace workspace = null;
        try {
            workspace = (IWorkspace)repo.itemManager().fetchCompleteItem(location, 0, (IProgressMonitor)progress.newChild(70));
        }
        catch (ItemNotFoundException e) {
            String msg = Messages.WorkspaceAndStreamHyperlinkHandler_DoesNotExistMessage;
            StatusUtil.log((Object)((Object)this), (String)msg, (Throwable)e);
            JFaceUtils.showError((String)Messages.WorkspaceAndStreamHyperlinkHandler_DoesNotExistTitle, (String)msg, (Throwable)e);
            return null;
        }
        if (workspace == null || workspace.getOrigin() == null) {
            throw new TeamRepositoryException(Messages.WorkspaceAndStreamHyperlinkHandler_CannotResolveUri);
        }
        return AbstractPlaceWrapper.newWrapper(workspace);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        if (object instanceof AbstractPlaceWrapper) {
            object = ((AbstractPlaceWrapper)((Object)object)).getWorkspace();
        }
        if (object instanceof IWorkspaceHandle) {
            IWorkspaceHandle wh;
            block6: {
                wh = (IWorkspaceHandle)object;
                if (((ITeamRepository)wh.getOrigin()).loggedIn()) break block6;
                return null;
            }
            try {
                IReference ref = WorkspaceLocationFactory.createWorkspaceURI((ItemProvider)new ClientProviderFactory((ITeamRepository)wh.getOrigin()).getItemProvider(), (IWorkspaceHandle)wh, (IProgressMonitor)monitor);
                return new URIReference(ref.getComment(), "", ref.createURI());
            }
            catch (IllegalStateException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return this.getWrapper(uri, monitor);
        }
        catch (TeamRepositoryException e) {
            return null;
        }
    }

    public boolean resolves(URI uri) {
        return this.handles(uri);
    }

    public boolean links(Object object) {
        if (object instanceof AbstractPlaceWrapper) {
            return true;
        }
        if (object instanceof IWorkspaceHandle) {
            return true;
        }
        return super.links(object);
    }

    public IItemType guessItemType(URI uri) {
        String uriString = uri.toString();
        if (uriString.contains("#action=com.ibm.team.scm.browseStream")) {
            return IWorkspace.ITEM_TYPE;
        }
        if (uriString.contains("#action=com.ibm.team.scm.browseWorkspace")) {
            return IWorkspace.ITEM_TYPE;
        }
        return super.guessItemType(uri);
    }
}

