/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.HardcodedPermissionUtils;
import com.ibm.team.filesystem.client.internal.PlatformDetector;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.daemon.trace.DaemonTraceConfigurator;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import com.ibm.team.filesystem.client.rest.ILifecycleRestClient;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import com.ibm.team.filesystem.client.restproxy.IDaemonHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.ide.ui.internal.preferences.PreferencesListener;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.IAutoCommitParticipant;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.AutoCommitManager;
import com.ibm.team.filesystem.rcp.core.internal.compare.ExternalCompareToolManager;
import com.ibm.team.filesystem.rcp.core.internal.compare.IExternalCompareTool;
import com.ibm.team.filesystem.rcp.core.internal.resources.RepositoryProviderChangeNotifier;
import com.ibm.team.filesystem.rcp.core.patches.PatchModel;
import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.IConflictDialogFactory;
import com.ibm.team.filesystem.ui.autocommit.AutoCommitParticipant;
import com.ibm.team.filesystem.ui.changes.actions.ResolveWithProposed;
import com.ibm.team.filesystem.ui.editor.SharedFormColors;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorAdapterFactory;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.ColorRegistry;
import com.ibm.team.internal.filesystem.ui.corruption.CorruptCopyFileAreaListener;
import com.ibm.team.internal.filesystem.ui.ignore.IdeIgnoreManagerEventConnector;
import com.ibm.team.internal.filesystem.ui.util.WorkingSetUtils;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.StandardActionFilter;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.scm.client.SCMPlatform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.team.filesystem.ide.ui";
    private static final List TEST_APPLICATIONS = Arrays.asList("org.eclipse.test.uitestapplication", "org.eclipse.test.coretestapplication", "org.eclipse.pde.junit.runtime.uitestapplication", "org.eclipse.pde.junit.runtime.coretestapplication", "org.eclipse.pde.junit.runtime.legacyUItestapplication", "org.eclipse.pde.junit.runtime.legacyCoretestapplication");
    private static final String APPLICATION_PROPERTY = "eclipse.application";
    private static final String APPLICATION_ARG = "-application";
    public static final boolean TRACE_AML_MARKUP = Platform.inDebugMode() ? "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.filesystem.ide.ui/trace.process.markup")) : false;
    public static final String AUTO_COMMIT_PREFERENCE = "auto commit";
    public static final String AUTO_MERGE_CONTENT_PROMPT = "com.ibm.team.filesystem.ide.ui.prompt_auto_merge_content";
    public static final String SHOW_NOT_LOADED_COMPONENTS = "com.ibm.team.filesystem.ide.ui.show_not_loaded_components";
    public static final String SHOW_COMPONENTS_WITH_NO_CHANGES_PREFERENCE = "com.ibm.team.filesystem.ide.ui.prefs_show_with_no_changes";
    public static final String PREF_SHOW_UNTRACKED_WORKSPACES = "com.ibm.team.filesystem.ide.ui.prefs_show_untracked_workspaces";
    public static final String SHOW_ADDED_REMOVED_COMPONENT = "com.ibm.team.filesystem.ide.ui.show_added_removed_components";
    public static final String SHOW_SUSPENDED_CHANGE_SETS_PREFERENCE = "com.ibm.team.filesystem.ide.ui.prefs_show_suspended_change_sets";
    public static final String USE_CURRENT_PROJECTAREA_FORWORKITEMPROMPTS = "com.ibm.team.filesystem.ide.ui.prefs_use_currentproject_workitem_prompts";
    public static final String SHOW_PENDING_VIEW_ON_CHANGES = "com.ibm.team.filesystem.ide.ui.prefs_show_pending_view_on_changes";
    public static final String SHOW_CONFLICT_PROMPT_DIALOG_ON_CONFLICT = "com.ibm.team.filesystem.ide.ui.prefs_show_conflict_prompt_dialog_on_conflict";
    public static final String ATTEMPT_TO_AUTO_RESOLVE_CONFLICTS = "com.ibm.team.filesystem.ide.ui.prefs_attempt_to_auto_resolve_conflicts_on_accept";
    public static final String SHOW_METRONOME_TRIM = "prefs_show_metronome_trim";
    public static final String ENABLED_MODEL_PROVIDERS = "prefs_enabled_model_providers";
    public static final String REFRESH_ECLIPSE_RESOURCE_WHEN_REFRESHING_SANDBOX = "prefs_skip_eclipse_resources_whenrefreshing";
    public static final String PREF_HISTORY_VIEW_ORIENTATION = "prefs_history_view_orientation";
    private static UiPlugin plugin;
    private Class[] classesWithActionFilters = new Class[]{AbstractWrapper.class, StructuralChangesViewNode.class};
    private boolean isShutdown = false;
    private ColorRegistry colorRegistry;
    public static final Object PROP_NEW_WORKSPACE_COMPARE;
    public static final Object PROP_NEW_UPDATE_REPORT;
    public static final String ADD_A_DESCRIPTION = "";
    public static final String COMPONENT_TEAM_PLACES_DECORATION_PREFERENCE = "COMPONENT_TEAM_PLACES_DECORATION_PREFERENCE";
    public static final String ACTIVITY_MODIFIED_DECORATION_PREFERENCE = "ACTIVITY_MODIFIED_DECORATION";
    public static final String ACTIVITY_LINK_DECORATION_PREFERENCE = "ACTIVITY_LINK_DECORATION";
    public static final String SOURCE_CONNECTION_STATUS_DECORATION_PREFERENCE = "SOURCE_CONNECTION_STATUS_DECORATION_PREFERENCE";
    public static final String CHANGE_SUMMARY_TYPE_DECORATION_PREFERENCE = "CHANGE_SUMMARY_TYPE_DECORATION";
    public static final String BASIS_COMPONENT_DECORATION = "BASIS_COMPONENT_DECORATION";
    public static final String CHANGE_SUMMARY_CONFLICT_TYPE_DECORATION_PREFERENCE = "CHANGE_SUMMARY_CONFLICT_TYPE_DECORATION";
    public static final String ACTIVITY_MODIFIED_BY_DECORATION_PREFERENCE = "ACTIVITY_MODIFIED_BY_DECORATION";
    public static final String SHOW_ALL_OCCURRENCES = "SHOW_ALL_OCCURRENCES";
    public static final String SHOW_VERSION_IDENTIFIERS = "SHOW_VERSION_IDENTIFIERS";
    public static final String AUTOCOMMIT_ON_SAVE_PREFERENCE = "commit_on_save";
    public static final String AUTOCOMMIT_ON_BLUR_PREFERENCE = "commit_on_blur";
    public static final String AUTOCOMMIT_MAX_INTERVAL_PREFERENCE = "max_commit_interval";
    public static final String AUTOCOMMIT_MIN_INTERVAL_PREFERENCE = "min_commit_interval";
    public static final String AUTOCOMMIT_INTERVAL_ENABLED_PREFERENCE = "commit_interval_enabled";
    public static final String AUTOCOMMIT_MIN_IDLE_PREFERENCE = "keyboard_idle_commit";
    public static final String AUTOCOMMIT_ON_SHUTDOWN = "commit_on_shutdown";
    private WorkingSetUtils workingSetUtils = new WorkingSetUtils();
    private SharedFormColors sharedFormColors;
    private ScopedPreferenceStore corePreferenceStore;
    public static final String PREF_UNCHECKED_IN_CHANGES = "uncheckedInChanges";
    public static final String PREF_UNCHECKED_IN_CHANGES_SUSPEND = "uncheckedInChangesForSuspend";
    public static final String PREF_UNCHECKED_IN_UNSHARE_CHANGES = "uncheckedInUnshareChanges";
    public static final String PREF_CHECKIN_LINK_WARNINGS = "checkinLinkWarnings";
    public static final String PREF_WARN_DISCONNECTED_COMPONENTS = "warn_disconnected_components";
    public static final String PREF_LOCK_BEING_HELD = "lockBeingHeld";
    public static final String PREF_LOCKS_WERE_HELD = "locksWereHeld";
    public static final String PREF_LOCKS_TO_RELEASE = "locksToRelease";
    public static final String PREF_SHOW_FILES_NOT_PATCHED = "show_files_not_patched";
    public static final String PREF_PROMPT_SORT_HISTORY = "prompt_sort_history";
    public static final String PREF_INFO_APPLY_PATCH = "info_apply_patch";
    public static final String PREF_INFO_CREATE_PATCH = "info_create_patch";
    public static final String PREF_INFO_LOAD_PROBLEMS = "info_load_problems";
    public static final String PREF_PROMPT_LOAD_WITHOUT_PROJECT_CREATION = "prompt_load_without_project_creation";
    public static final String PREF_WARN_IGNORE_CHANGED_RESOURCE = "warn_ignore_changed_resource";
    public static final String PREF_WARN_COMMIT_INACCESSIBLE_CHANGES = "warn_commit_inaccessible_changes";
    public static final String PREF_PROMPT_SIBLINGS_SHARES_TO_ADD = "prompt_sibling_shares_to_add";
    public static final String PREF_PROMPT_DISCONNECT_PROJECT = "pref_prompt_disconnect_project";
    public static final String PREF_PROMPT_STREAMS_LOCK_UNLOCK_DIALOG = "pref_prompt_streams_lock_unlock_dialog";
    public static final String PREF_COMPARE_PROPERTIES = "compare_properties";
    public static final String PREVIOUS_ECLIPSE_IGNORES_PREFERENCE = "previous_ignore_patterns";
    public static final String PREF_PENDING_CHANGES_REFRESH_ACTION = "prefs_pending_changes_refresh_action";
    public static final String PREF_PENDING_CHANGES_REFRESH_ACTION_REMOTE_VALUE = "REMOTE";
    public static final String PREF_PENDING_CHANGES_REFRESH_ACTION_SANDBOXES_VALUE = "SANDBOXES";
    public static final String PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE = "PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE";
    public static final String PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE_PROMPT_ON_INCOMPLETE_CHANGE = "PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE_PROMPT_ON_INCOMPLETE_CHANGE";
    @Deprecated
    private static final String EXTERNAL_COMPARE_DEFAULT_COMPARE_TOOL = "external_compare_default_tool_preference_key";
    public static final String EXTERNAL_COMPARE_PREVIOUSY_SELECTED_COMPARE_TOOL = "external_compare_previously_selected_compare_tool";
    public static final String EXTERNAL_COMPARE_PREVIOUSY_SELECTED_COMPARE_TOOL_DEFAULT = "";
    public static final String EXTERNAL_COMPARE_TOOL_POLICY = "external_compare_tool_policy";
    public static final String EXTERNAL_COMPARE_TOOL_POLICY_ALWAYS_VALUE = "always";
    public static final String EXTERNAL_COMPARE_TOOL_POLICY_NEVER_VALUE = "never";
    public static final String EXTERNAL_COMPARE_TOOL_POLICY_INCLUSIVE_VALUE = "inclusive";
    public static final String EXTERNAL_COMPARE_TOOL_POLICY_EXCLUSIVE_VALUE = "exclusive";
    public static final String EXTERNAL_COMPARE_TOOL_POLICY_DEFAULT_VALUE = "never";
    public static final String EXTERNAL_COMPARE_FILE_PATTERNS_LIST = "external_compare_file_patterns_list";
    public static final String EXTERNAL_COMPARE_FILE_PATTERNS_LIST_DEFAULT_VALUE = "";
    public static final String PT_ADVISOR_TAG = "advisor_tag";
    public static final String PT_SANDOBOX_PICKER = "sandboxPicker";
    public static final String PT_SANDOBOX_FILE_EDITOR = "sandboxEditorInputSource";
    public static final String PREF_SHOW_CLOSE_PORT_EDITOR_DIALOG = "com.ibm.team.filesystem.ide.ui.show_close_port_editor_dialog";
    public static final String PREF_SHOW_HIDING_OUTGOING_CHANGES_DIALOG = "com.ibm.team.filesystem.ide.ui.show_hiding_outgoing_changes_dialog";
    public static final String PREF_SHOW_RESOLVED_PORT_CHANGES = "com.ibm.team.filesystem.ide.ui.show_resolved_port_changes";
    public static final String PREF_PROCESS_MERGE_QUEUE_AFTER_COMPLETE = "com.ibm.team.filesystem.ide.ui.process_merge_queue_after_complete";
    public static final String PREF_HIDE_ADD_SANDBOX_WARNING = "com.ibm.team.filesystem.ide.ui.hide_sandbox_warning";
    public static final String PREF_PROMPT_COMMENT_NEW_CHANGE_SET = "com.ibm.team.filesystem.ide.ui.prompt_comment_new_change_set";
    public static final String PREF_PROMPT_NOTFIY_BEFORE_LOCK = "com.ibm.team.filesystem.ide.ui.prompt_notify_before_lock";
    public static final String PREF_SUSPEND_LOCKS_TO_RELEASE = "suspend_locksToRelease";
    public static final String PREF_DISCARD_LOCKS_TO_RELEASE = "discard_locksToRelease";
    public static final String PREF_UNDO_LOCKS_TO_RELEASE = "undo_locksToRelease";
    public static final String PREF_RESUME_LOCKS_TO_RELEASE = "resume_locksToRelease";
    public static final String PREF_WARN_NO_BACKUP_BASELINE_BEFORE_REMOVE = "warn_no_backup_baseline_before_remove";
    public static final String PREF_WARN_NO_BACKUP_BASELINE_BEFORE_REPLACE = "warn_no_backup_baseline_before_replace";
    public static final String ADD_COMPONENT_FROM_WORKSPACE_WITH_HIERARCHY_PREF_KEY = "com.ibm.team.filesystem.ide.ui.add_component_from_workspace_with_hierarchy";
    public static final boolean ADD_COMPONENT_FROM_WORKSPACE_WITH_HIERARCHY_PREF_DEFAULT_VALUE = true;
    public static final String REPLACE_COMPONENT_FROM_WORKSPACE_WITH_HIERARCHY_PREF_KEY = "com.ibm.team.filesystem.ide.ui.replace_component_from_workspace_with_hierarchy";
    public static final boolean REPLACE_COMPONENT_FROM_WORKSPACE_WITH_HIERARCHY_PREF_DEFAULT_VALUE = true;
    public static final String REPLACE_WITH_BASELINE_HIERARCHY_PREF_KEY = "com.ibm.team.filesystem.ide.ui.replace_with_hierarchy";
    public static final boolean REPLACE_WITH_BASELINE_HIERARCHY_PREF_DEFAULT_VALUE = false;
    private static final String GRAPHICAL_BASELINE_DEFAULT_STREAMS = "com.ibm.team.filesystem.ide.ui.graphical_baseline_default_stream";
    private static final String GRAPHICAL_BASELINE_PREFS = "com.ibm.team.filesystem.ide.ui.graphical_baseline_prefs";
    public static final String GRAPHICAL_BASELINE_STREAMS_SEPARATOR = ",";
    public static final String GRAPHICAL_BASELINE_HIDE_LIFECYCLE_DIALOG = ".graphical_baseline_lifecycle_dialog";
    public static final String USE_EXTERNAL_BROWSER = "prefs_use_external_browser";
    public static final String CONFIRM_DELIVERY = "pref_confirm_deliver";
    private MessageConsole console;
    private MessageConsoleStream consoleStream;
    private static int BUFF_LEN;

    static {
        PROP_NEW_WORKSPACE_COMPARE = new Object();
        PROP_NEW_UPDATE_REPORT = new Object();
        BUFF_LEN = 2000;
    }

    public static String getGraphicalBaselineDefaultStreamsPreferenceKey(String repoId, String componentId) {
        return "com.ibm.team.filesystem.ide.ui.graphical_baseline_default_stream:" + repoId + ":" + componentId;
    }

    public static String getGraphicalBaselinesPreferenceKey(String repoId, String componentId) {
        return "com.ibm.team.filesystem.ide.ui.graphical_baseline_prefs:" + repoId + ":" + componentId;
    }

    public UiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        WorkspaceContext.TRACE_INCOMING_EVENTS = WorkspaceContext.TRACE_CONTEXT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.filesystem.ide.ui/trace.workspace.context"));
        WorkspaceContext.TRACE_LISTENERS = WorkspaceContext.TRACE_CONTEXT;
        this.isShutdown = false;
        StandardActionFilter.register((Class[])this.classesWithActionFilters);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)new ContributorAdapterFactory(), ContributorWrapper.class);
        RepositoryProviderChangeNotifier.getInstance().addGenericListener((Object)"map", (IListener)this.workingSetUtils);
        RepositoryProviderChangeNotifier.getInstance().addGenericListener((Object)"unmap", (IListener)this.workingSetUtils);
        IdeIgnoreManagerEventConnector.getInstance().start();
        String appId = this.getAppId(context);
        if (!TEST_APPLICATIONS.contains(appId)) {
            if (Display.getCurrent() != null) {
                ThreadCheck.prohibitLongOps();
            } else if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ThreadCheck.prohibitLongOps();
                    }
                });
            }
            ISharingManager manager = FileSystemCore.getSharingManager();
            ((SharingManager)manager).addListener((ICorruptCopyFileAreaListener)CorruptCopyFileAreaListener.getInstance());
        }
        AutoCommitManager.getInstance().setParticipant((IAutoCommitParticipant)new AutoCommitParticipant());
        PreferencesListener.start(FileSystemResourcesPlugin.getComponentSyncModel());
        PatchModel.loadAsynchronously();
        DialogUtil.conflictDialogFactory = new IConflictDialogFactory(){

            public ListDialog createConflictDialog(Shell shell, Collection<ILogicalChange> conflictItems, String title, String message) {
                return ResolveWithProposed.createConflictDialog(shell, conflictItems, title, message);
            }
        };
        try {
            this.startDaemon(context);
        }
        catch (Exception e) {
            LogFactory.getLog((String)((Object)((Object)this)).getClass().getName()).error((Object)Messages.UiPlugin_0, (Throwable)e);
        }
    }

    protected void startDaemon(BundleContext context) throws IOException {
        final Discovery2.DiscoveryParams parms = new Discovery2.DiscoveryParams();
        parms.setAllowStart(true).setEnableStats(true).setRunInProcess(true).setInterface(ILifecycleRestClient.class).setPermissionUtils((IPermissionUtil)new HardcodedPermissionUtils(PlatformDetector.LauncherType.ECLIPSE, System.getenv())).setLauncherType(PlatformDetector.LauncherType.ECLIPSE);
        DaemonTraceConfigurator.configure((Discovery2.DiscoveryParams)parms, (File)FileSystemCore.getUserConfigDir().getConfigDirAsFile(), System.getenv(), null);
        final String appId = this.getAppId(context);
        Job j = new Job(Messages.UiPlugin_1){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Object o = Discovery2.RESOLVER.resolve(parms, monitor);
                    IDaemonHandle loc = Discovery2.RESOLVER.find(o);
                    FSDaemon fsd = loc.getInProcessServer();
                    fsd.setDescription(appId, null);
                }
                catch (Exception e) {
                    LogFactory.getLog((String)((Object)((Object)this)).getClass().getName()).error((Object)Messages.UiPlugin_0, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }

    private String getAppId(BundleContext context) {
        String[] args = Platform.getCommandLineArgs();
        int i = args.length - 2;
        while (i >= 0) {
            if (args[i].equals(APPLICATION_ARG) && i < args.length - 1 && !args[i + 1].startsWith("-")) {
                return args[i + 1];
            }
            --i;
        }
        String id = context.getProperty(APPLICATION_PROPERTY);
        if (id != null) {
            return id;
        }
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getApplication();
        }
        return null;
    }

    public void stop(BundleContext context) throws Exception {
        AutoCommitManager.getInstance().setParticipant(null);
        IdeIgnoreManagerEventConnector.getInstance().stop();
        ((SharingManager)FileSystemCore.getSharingManager()).removeListener((ICorruptCopyFileAreaListener)CorruptCopyFileAreaListener.getInstance());
        StandardActionFilter.unregister((Class[])this.classesWithActionFilters);
        RepositoryProviderChangeNotifier.getInstance().purgeTypedListener((Object)this.workingSetUtils);
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)new ContributorAdapterFactory(), ContributorWrapper.class);
        PreferencesListener.stop();
        if (this.colorRegistry != null) {
            this.colorRegistry.dispose();
            this.colorRegistry = null;
        }
        if (this.sharedFormColors != null) {
            this.sharedFormColors.dispose();
            this.sharedFormColors = null;
        }
        if (this.console != null) {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.removeConsoles(new IConsole[]{this.console});
            this.console = null;
            this.consoleStream = null;
        }
        super.stop(context);
        this.isShutdown = true;
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static boolean isShutdown() {
        return plugin == null || UiPlugin.plugin.isShutdown;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        if (!store.contains(EXTERNAL_COMPARE_TOOL_POLICY)) {
            boolean value = store.getBoolean(EXTERNAL_COMPARE_DEFAULT_COMPARE_TOOL);
            store.putValue(EXTERNAL_COMPARE_TOOL_POLICY, value ? EXTERNAL_COMPARE_TOOL_POLICY_ALWAYS_VALUE : "never");
        }
        store.setDefault(AUTO_COMMIT_PREFERENCE, false);
        store.setDefault(COMPONENT_TEAM_PLACES_DECORATION_PREFERENCE, true);
        store.setDefault(ACTIVITY_MODIFIED_DECORATION_PREFERENCE, false);
        store.setDefault(ACTIVITY_LINK_DECORATION_PREFERENCE, true);
        store.setDefault(SOURCE_CONNECTION_STATUS_DECORATION_PREFERENCE, true);
        store.setDefault(SHOW_VERSION_IDENTIFIERS, true);
        store.setDefault(AUTOCOMMIT_ON_SAVE_PREFERENCE, true);
        store.setDefault(AUTOCOMMIT_ON_BLUR_PREFERENCE, false);
        store.setDefault(AUTOCOMMIT_MIN_INTERVAL_PREFERENCE, 0);
        store.setDefault(AUTOCOMMIT_MAX_INTERVAL_PREFERENCE, 30);
        store.setDefault(AUTOCOMMIT_INTERVAL_ENABLED_PREFERENCE, false);
        store.setDefault(AUTOCOMMIT_MIN_IDLE_PREFERENCE, 0);
        store.setDefault(CHANGE_SUMMARY_TYPE_DECORATION_PREFERENCE, false);
        store.setDefault(CHANGE_SUMMARY_CONFLICT_TYPE_DECORATION_PREFERENCE, false);
        store.setDefault(BASIS_COMPONENT_DECORATION, false);
        store.setDefault(ACTIVITY_MODIFIED_BY_DECORATION_PREFERENCE, true);
        store.setDefault(SHOW_ALL_OCCURRENCES, true);
        store.setDefault(SHOW_NOT_LOADED_COMPONENTS, true);
        store.setDefault(SHOW_ADDED_REMOVED_COMPONENT, true);
        store.setDefault(SHOW_COMPONENTS_WITH_NO_CHANGES_PREFERENCE, true);
        store.setDefault(PREF_SHOW_UNTRACKED_WORKSPACES, true);
        store.setDefault(SHOW_SUSPENDED_CHANGE_SETS_PREFERENCE, true);
        store.setDefault(USE_CURRENT_PROJECTAREA_FORWORKITEMPROMPTS, false);
        store.setDefault(AUTO_MERGE_CONTENT_PROMPT, "prompt");
        store.setDefault(PREF_WARN_IGNORE_CHANGED_RESOURCE, true);
        store.setDefault(PREF_PROMPT_DISCONNECT_PROJECT, true);
        store.setDefault(PREF_PROMPT_STREAMS_LOCK_UNLOCK_DIALOG, true);
        store.setDefault(SHOW_PENDING_VIEW_ON_CHANGES, true);
        store.setDefault(SHOW_CONFLICT_PROMPT_DIALOG_ON_CONFLICT, true);
        store.setDefault(ATTEMPT_TO_AUTO_RESOLVE_CONFLICTS, false);
        store.setDefault(SHOW_METRONOME_TRIM, false);
        store.setDefault(USE_EXTERNAL_BROWSER, false);
        store.setDefault(CONFIRM_DELIVERY, true);
        store.setDefault(REFRESH_ECLIPSE_RESOURCE_WHEN_REFRESHING_SANDBOX, true);
        store.setDefault("content_threads", 10);
        store.setDefault(EXTERNAL_COMPARE_PREVIOUSY_SELECTED_COMPARE_TOOL, "");
        store.setDefault(EXTERNAL_COMPARE_TOOL_POLICY, "never");
        store.setDefault(EXTERNAL_COMPARE_FILE_PATTERNS_LIST, "");
        store.setDefault(PREF_INFO_CREATE_PATCH, true);
        store.setDefault(PREF_INFO_LOAD_PROBLEMS, true);
        store.setDefault(PREF_PROMPT_LOAD_WITHOUT_PROJECT_CREATION, true);
        store.setDefault(PREF_INFO_APPLY_PATCH, true);
        store.setDefault(PREF_PROMPT_SORT_HISTORY, true);
        store.setDefault(PREF_WARN_DISCONNECTED_COMPONENTS, true);
        store.setDefault(PREF_WARN_NO_BACKUP_BASELINE_BEFORE_REMOVE, true);
        store.setDefault(PREF_WARN_NO_BACKUP_BASELINE_BEFORE_REPLACE, true);
        store.setDefault(PREF_UNCHECKED_IN_CHANGES, 0);
        store.setDefault(PREF_CHECKIN_LINK_WARNINGS, 1);
        store.setDefault(PREF_LOCK_BEING_HELD, -1);
        store.setDefault(PREF_LOCKS_TO_RELEASE, -1);
        store.setDefault(PREF_LOCKS_WERE_HELD, true);
        store.setDefault(PREF_SHOW_FILES_NOT_PATCHED, true);
        store.setDefault(PREF_PENDING_CHANGES_REFRESH_ACTION, PREF_PENDING_CHANGES_REFRESH_ACTION_REMOTE_VALUE);
        store.setDefault(PREF_WARN_COMMIT_INACCESSIBLE_CHANGES, true);
        store.setDefault(PREF_PROMPT_SIBLINGS_SHARES_TO_ADD, -1);
        store.setDefault(PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE, false);
        store.setDefault(PREF_CHANGE_SUMMARY_SHOW_DETAILS_PANE_PROMPT_ON_INCOMPLETE_CHANGE, true);
        store.setDefault(PREF_SHOW_CLOSE_PORT_EDITOR_DIALOG, true);
        store.setDefault(PREF_SHOW_HIDING_OUTGOING_CHANGES_DIALOG, true);
        store.setDefault(PREF_SHOW_RESOLVED_PORT_CHANGES, true);
        store.setDefault(PREF_PROCESS_MERGE_QUEUE_AFTER_COMPLETE, true);
        store.setDefault(PREF_HIDE_ADD_SANDBOX_WARNING, false);
        store.setDefault(PREF_PROMPT_COMMENT_NEW_CHANGE_SET, false);
        store.setDefault(PREF_PROMPT_NOTFIY_BEFORE_LOCK, true);
        store.setDefault(PREF_SUSPEND_LOCKS_TO_RELEASE, -1);
        store.setDefault(PREF_DISCARD_LOCKS_TO_RELEASE, -1);
        store.setDefault(PREF_UNDO_LOCKS_TO_RELEASE, -1);
        store.setDefault(PREF_RESUME_LOCKS_TO_RELEASE, -1);
        store.setDefault(ADD_COMPONENT_FROM_WORKSPACE_WITH_HIERARCHY_PREF_KEY, true);
        store.setDefault(REPLACE_WITH_BASELINE_HIERARCHY_PREF_KEY, false);
        IExternalCompareTool[] externalTools = ExternalCompareToolManager.getExternalCompareToolsArray();
        int i = 0;
        while (i < externalTools.length) {
            store.setDefault(externalTools[i].get2WayCompareExecutablePathPrefKey(), externalTools[i].get2WayCompareExecutablePathPrefDefaultValue());
            store.setDefault(externalTools[i].get2WayLocalCompareArgumentsPrefKey(), externalTools[i].get2WayLocalCompareArgumentsPrefDefaultValue());
            store.setDefault(externalTools[i].get2WayRemoteCompareArgumentsPrefKey(), externalTools[i].get2WayRemoteCompareArgumentsPrefDefaultValue());
            store.setDefault(externalTools[i].get3WayMergeExecutablePathPrefKey(), externalTools[i].get3WayMergeExecutablePathPrefDefaultValue());
            store.setDefault(externalTools[i].get3WayMergeArgumentsPrefKey(), externalTools[i].get3WayMergeArgumentsPrefDefaultValue());
            store.setDefault(externalTools[i].getAutoResolveExecutablePathPrefKey(), externalTools[i].getAutoResolveExecutablePathPrefDefaultValue());
            store.setDefault(externalTools[i].getAutoResolveArgumentsPrefKey(), externalTools[i].getAutoResolveArgumentsPrefDefaultValue());
            ++i;
        }
        int contentTransferThreads = store.getInt("content_threads");
        contentTransferThreads = Math.max(0, Math.min(50, contentTransferThreads));
        SCMPlatform.setMaxContentThreads((int)contentTransferThreads);
    }

    public static ImageDescriptor getFileSystemImageDescriptor(String filename) {
        if (filename == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(filename);
    }

    private static ITeamRepository getTeamRepositoryFromURL(URL url) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            for (String repoUri : repo.getAliasRepositoryURIs()) {
                if (!url.toString().startsWith(repoUri)) continue;
                return repo;
            }
            ++n2;
        }
        return null;
    }

    private static void download(ITeamRepository repo, URL url, File localFile) throws IOException {
        ITeamRawRestServiceClient.IRawRestClientConnection connection;
        try {
            connection = repo.getRawRestServiceClient().getConnection(url.toURI());
        }
        catch (URISyntaxException e1) {
            throw new IOException(e1);
        }
        InputStream inputStream = new InputStream(){
            private InputStream realInput = null;

            @Override
            public int read() throws IOException {
                if (this.realInput == null) {
                    try {
                        this.realInput = connection.doGet().getResponseStream();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return -1;
                    }
                }
                return this.realInput.read();
            }
        };
        FileOutputStream outputStream = new FileOutputStream(localFile);
        byte[] buf = new byte[BUFF_LEN];
        try {
            int readCount;
            while ((readCount = inputStream.read(buf, 0, BUFF_LEN)) != -1) {
                outputStream.write(buf, 0, readCount);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private static URL createFileFromServer(Display display, IOperationRunner runner, final URL url) throws IOException, FileNotFoundException {
        final ITeamRepository repo = UiPlugin.getTeamRepositoryFromURL(url);
        if (repo == null) {
            return JazzResources.createImageURL((URL)url);
        }
        Path relpath = new Path(url.getFile());
        final File file = new File(JazzResources.getRootURL().append(String.valueOf(url.getHost()) + "_" + relpath.lastSegment()).toOSString());
        if (!file.exists()) {
            final FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    UiPlugin.download(repo, url, file);
                    return true;
                }
            });
            runner.enqueue("Download Icon Image ...", (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    task.run();
                }
            });
            boolean succeeded = false;
            while (!task.isDone()) {
                try {
                    succeeded = task.get(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException | TimeoutException e) {
                    e.printStackTrace();
                    break;
                }
            }
            if (!succeeded || !file.exists()) {
                return null;
            }
        }
        return file.toURL();
    }

    public static ImageDescriptor getImageDescriptor(Display display, IOperationRunner runner, URL url) {
        if (url != null) {
            URL localurl;
            block4: {
                try {
                    localurl = UiPlugin.createFileFromServer(display, runner, url);
                    if (localurl != null) break block4;
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)localurl);
            JazzResources.registerUrl((ImageDescriptor)descriptor, (URL)localurl);
            return descriptor;
        }
        return null;
    }

    public ColorRegistry getColorRegistry() {
        Display display = Display.getCurrent();
        Assert.isNotNull((Object)display, (String)"Must be called from UI thread.");
        if (this.colorRegistry == null) {
            this.colorRegistry = new ColorRegistry(display);
        }
        return this.colorRegistry;
    }

    public static boolean getBooleanPreference(String preference) {
        if (UiPlugin.isShutdown()) {
            return false;
        }
        return UiPlugin.getDefault().getPreferenceStore().getBoolean(preference);
    }

    public static boolean isChangeProperty(String property) {
        return property.equals(COMPONENT_TEAM_PLACES_DECORATION_PREFERENCE) || property.equals(ACTIVITY_MODIFIED_DECORATION_PREFERENCE) || property.equals(ACTIVITY_LINK_DECORATION_PREFERENCE) || property.equals(CHANGE_SUMMARY_TYPE_DECORATION_PREFERENCE) || property.equals(CHANGE_SUMMARY_CONFLICT_TYPE_DECORATION_PREFERENCE) || property.equals(ACTIVITY_MODIFIED_BY_DECORATION_PREFERENCE) || property.equals(SHOW_ALL_OCCURRENCES) || property.equals(SHOW_NOT_LOADED_COMPONENTS) || property.equals(SHOW_COMPONENTS_WITH_NO_CHANGES_PREFERENCE) || property.equals(BASIS_COMPONENT_DECORATION) || property.equals(SOURCE_CONNECTION_STATUS_DECORATION_PREFERENCE) || property.equals(SHOW_VERSION_IDENTIFIERS) || property.equals(SHOW_SUSPENDED_CHANGE_SETS_PREFERENCE) || property.equals(PREF_SHOW_UNTRACKED_WORKSPACES) || property.equals(SHOW_ADDED_REMOVED_COMPONENT);
    }

    public FormColors getSharedFormColors(Display display) {
        if (this.sharedFormColors == null) {
            this.sharedFormColors = new SharedFormColors();
        }
        return this.sharedFormColors.getFormColors(display);
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            this.corePreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ibm.team.filesystem.rcp.core");
        }
        return this.corePreferenceStore;
    }

    public static boolean isDistributedUI() {
        String distributed = System.getProperty("filesystem.ide.ui.distributed", "true");
        return Boolean.parseBoolean(distributed);
    }

    public synchronized MessageConsole getConsole() {
        if (this.console == null) {
            this.console = new MessageConsole(Messages.UiPlugin_2, null);
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.addConsoles(new IConsole[]{this.console});
        }
        return this.console;
    }

    public synchronized MessageConsoleStream getMessageStream() {
        if (this.consoleStream == null) {
            MessageConsole mc = this.getConsole();
            this.consoleStream = mc.newMessageStream();
        }
        return this.consoleStream;
    }
}

