/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.ui.ChangeSetHyperlinkHandler;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class SnapshotHyperlinkHandler
extends HyperlinkHandler {
    public IStatus open2(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        if (this.handles(uri)) {
            try {
                RawSnapshotWrapper wrapper = (RawSnapshotWrapper)((Object)this.resolve(uri, provider, monitor));
                if (wrapper != null) {
                    final IBaselineSet baselineSet = wrapper.getSnapshot();
                    UIJob job = new UIJob(Messages.SnapshotHyperlinkHandler_OpeningSnapshotJobTitle){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            IWorkbenchPage page = JFaceUtils.getWorkbenchPage();
                            if (page != null) {
                                TeamPlacePart2.open(page, SnapshotEditorInput.newForEdit(baselineSet));
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public boolean handles(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            return location.getItemType() == IBaselineSet.ITEM_TYPE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean links(Object object) {
        RawSnapshotWrapper rawSnapshotWrapper = (RawSnapshotWrapper)((Object)Adapters.getAdapter((Object)object, RawSnapshotWrapper.class));
        if (rawSnapshotWrapper != null) {
            return true;
        }
        SnapshotWrapper snapshotWrapper = (SnapshotWrapper)((Object)Adapters.getAdapter((Object)object, SnapshotWrapper.class));
        if (snapshotWrapper != null) {
            return true;
        }
        if (object instanceof IBaselineSetHandle) {
            return true;
        }
        return super.links(object);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            IBaselineSetHandle bs = this.getBaselineSet(object);
            if (bs != null) {
                ITeamRepository repo = (ITeamRepository)bs.getOrigin();
                Location location = Location.itemLocation((IItemHandle)bs, (String)repo.getRepositoryURI());
                IBaselineSet bsItem = (IBaselineSet)repo.itemManager().fetchCompleteItem((IItemHandle)bs, 0, (IProgressMonitor)progress.newChild(1));
                return new URIReference(bsItem.getName(), bsItem.getComment(), location.toAbsoluteUri());
            }
            return super.createHyperlink(object, (IProgressMonitor)progress.newChild(1));
        }
        catch (TeamRepositoryException e) {
            return null;
        }
    }

    public boolean resolves(URI uri) {
        return this.handles(uri);
    }

    /*
     * Loose catch block
     */
    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            Location location = Location.location((URI)uri);
            if (!this.handles(uri)) {
                return null;
            }
            ITeamRepository server = ChangeSetHyperlinkHandler.resolveTeamRepository(location, (IProgressMonitor)progress.newChild(1));
            IItemManager itemManager = server.itemManager();
            IBaselineSet item = (IBaselineSet)itemManager.fetchCompleteItem(location, 0, (IProgressMonitor)progress.newChild(1));
            IWorkspace workspace = null;
            try {
                workspace = (IWorkspace)itemManager.fetchCompleteItem((IItemHandle)item.getOwner(), 0, (IProgressMonitor)progress.newChild(1));
            }
            catch (ItemNotFoundException e) {
                RawSnapshotWrapper rawSnapshotWrapper = new RawSnapshotWrapper(item);
                progress.done();
                return rawSnapshotWrapper;
            }
            catch (PermissionDeniedException e) {
                RawSnapshotWrapper rawSnapshotWrapper = new RawSnapshotWrapper(item);
                progress.done();
                return rawSnapshotWrapper;
            }
            SnapshotWrapper snapshotWrapper = new SnapshotWrapper(workspace, item);
            return snapshotWrapper;
            {
                catch (TeamRepositoryException e) {
                    CoreException coreException = new CoreException(StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.SnapshotHyperlinkHandler_UnableToResolveUriError, (Object)uri, (Object[])new Object[0]), (Throwable)e));
                    return coreException;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            progress.done();
        }
    }

    protected IBaselineSetHandle getBaselineSet(Object object) {
        RawSnapshotWrapper RawSnapshotWrapper2 = (RawSnapshotWrapper)((Object)Adapters.getAdapter((Object)object, RawSnapshotWrapper.class));
        if (RawSnapshotWrapper2 != null) {
            return RawSnapshotWrapper2.getSnapshot();
        }
        SnapshotWrapper snapshotWrapper = (SnapshotWrapper)((Object)Adapters.getAdapter((Object)object, SnapshotWrapper.class));
        if (snapshotWrapper != null) {
            return snapshotWrapper.getSnapshot();
        }
        if (object instanceof IBaselineSetHandle) {
            return (IBaselineSetHandle)object;
        }
        return null;
    }
}

