/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFileAndFolderPicker;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilePerComponentPicker;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilePicker;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPickerOutput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;

public class FileSelectionDialog {
    private FileSelectionDialog() {
    }

    public static Map<IComponentHandle, IFileItemHandle> pickFilePerComponent(Shell shell, ITeamRepository repo, IWorkspace workspace, String message, Map<IComponentHandle, IFileItemHandle> initialSelection) {
        HashSet<SiloedItemId<IVersionable>> selection;
        if (initialSelection == null) {
            selection = null;
        } else {
            selection = new HashSet<SiloedItemId<IVersionable>>(initialSelection.size());
            for (Map.Entry<IComponentHandle, IFileItemHandle> entry : initialSelection.entrySet()) {
                SiloedItemId siloedItemId = new SiloedItemId(IFileItem.ITEM_TYPE, entry.getValue().getItemId(), entry.getKey().getItemId());
                selection.add((SiloedItemId<IVersionable>)siloedItemId);
            }
        }
        Set<SiloedItemId<IVersionable>> itemsPicked = RepositoryFilePerComponentPicker.pickFilePerComponent(shell, repo, workspace, message, selection);
        if (itemsPicked == null) {
            return null;
        }
        HashMap<IComponentHandle, IFileItemHandle> result = new HashMap<IComponentHandle, IFileItemHandle>();
        for (SiloedItemId<IVersionable> siloedItemId : itemsPicked) {
            result.put(siloedItemId.getComponentHandle(), (IFileItemHandle)siloedItemId.toHandle());
        }
        return result;
    }

    public static RepositoryFilesPickerOutput pickFile(Shell shell, ITeamRepository repo, IWorkspace workspace, String description, Map<IComponentHandle, ? extends IVersionableHandle> initialSelection, boolean allowFolderSelection) {
        return FileSelectionDialog.pickFile(shell, repo, (IWorkspaceHandle)workspace, description, FileSelectionDialog.convertHandleMapToSiloedItemSet(initialSelection), allowFolderSelection);
    }

    public static RepositoryFilesPickerOutput pickFile(Shell shell, ITeamRepository repo, IWorkspaceHandle workspace, String description, Set<SiloedItemId<IVersionable>> initialSelection, boolean allowFolderSelection) {
        Set<SiloedItemId<IVersionable>> modifiedSelection = initialSelection;
        if (initialSelection != null && initialSelection.size() > 0) {
            modifiedSelection = new HashSet<SiloedItemId<IVersionable>>(1);
            modifiedSelection.add(initialSelection.iterator().next());
        }
        if (allowFolderSelection) {
            return RepositoryFileAndFolderPicker.pickFile(shell, repo, workspace, description, initialSelection);
        }
        return RepositoryFilePicker.pickFile(shell, repo, workspace, description, initialSelection);
    }

    public static RepositoryFilesPickerOutput pickFiles(Shell shell, ITeamRepository repo, IWorkspace workspace, String description, Map<IComponentHandle, ? extends IVersionableHandle> initialSelection, boolean multiSelect, boolean allowFolderSelection) {
        return FileSelectionDialog.pickFiles(shell, repo, (IWorkspaceHandle)workspace, description, FileSelectionDialog.convertHandleMapToSiloedItemSet(initialSelection), multiSelect, allowFolderSelection);
    }

    public static RepositoryFilesPickerOutput pickFiles(Shell shell, ITeamRepository repo, IWorkspaceHandle workspace, String description, Set<SiloedItemId<IVersionable>> initialSelection, boolean multiSelect, boolean allowFolderSelection) {
        if (allowFolderSelection) {
            return RepositoryFileAndFolderPicker.pickFiles(shell, repo, workspace, description, initialSelection, multiSelect);
        }
        return RepositoryFilePicker.pickFiles(shell, repo, workspace, description, initialSelection, multiSelect);
    }

    private static Set<SiloedItemId<IVersionable>> convertHandleMapToSiloedItemSet(Map<IComponentHandle, ? extends IVersionableHandle> handleMap) {
        HashSet<SiloedItemId> siloedItemSet = null;
        if (handleMap != null) {
            siloedItemSet = new HashSet<SiloedItemId>(handleMap.size());
            for (Map.Entry<IComponentHandle, ? extends IVersionableHandle> entry : handleMap.entrySet()) {
                SiloedItemId item = new SiloedItemId(IFileItem.ITEM_TYPE, entry.getValue().getItemId(), entry.getKey().getItemId());
                siloedItemSet.add(item);
            }
        }
        return siloedItemSet;
    }
}

